/*
 * Decompiled with CFR 0.152.
 */
package icy.image;

import icy.common.exception.UnsupportedFormatException;
import icy.common.listener.ProgressListener;
import icy.image.IcyBufferedImage;
import icy.image.IcyBufferedImageUtil;
import icy.image.ImageProvider;
import icy.image.ImageUtil;
import icy.sequence.MetaDataUtil;
import icy.system.SystemUtil;
import icy.system.thread.Processor;
import icy.type.DataType;
import icy.type.collection.array.Array1DUtil;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.Rectangle;
import java.io.IOException;
import java.util.List;
import ome.xml.meta.OMEXMLMetadata;

public abstract class AbstractImageProvider
implements ImageProvider {
    public static final int DEFAULT_THUMBNAIL_SIZE = 160;

    @Override
    public OMEXMLMetadata getOMEXMLMetaData() throws UnsupportedFormatException, IOException {
        return this.getMetaData();
    }

    @Override
    public int getTileWidth(int series) throws UnsupportedFormatException, IOException {
        return MetaDataUtil.getSizeX(this.getOMEXMLMetaData(), series);
    }

    @Override
    public int getTileHeight(int series) throws UnsupportedFormatException, IOException {
        OMEXMLMetadata meta = this.getOMEXMLMetaData();
        int sx = MetaDataUtil.getSizeX(meta, series);
        if (sx == 0) {
            return 0;
        }
        int maxHeight = 0x100000 / sx;
        int sy = MetaDataUtil.getSizeY(meta, series);
        return Math.min(maxHeight, sy);
    }

    @Override
    public boolean isResolutionAvailable(int series, int resolution) throws UnsupportedFormatException, IOException {
        return resolution == 0;
    }

    @Override
    public IcyBufferedImage getThumbnail(int series) throws UnsupportedFormatException, IOException {
        OMEXMLMetadata meta = this.getOMEXMLMetaData();
        int sx = MetaDataUtil.getSizeX(meta, series);
        int sy = MetaDataUtil.getSizeY(meta, series);
        int sz = MetaDataUtil.getSizeZ(meta, series);
        int st = MetaDataUtil.getSizeT(meta, series);
        if (sx == 0 || sy == 0 || sz == 0 || st == 0) {
            return null;
        }
        double ratio = Math.min(160.0 / (double)sx, 160.0 / (double)sy);
        int tnx = (int)Math.round((double)sx * ratio);
        int tny = (int)Math.round((double)sy * ratio);
        int resolution = AbstractImageProvider.getResolutionFactor(sx, sy, 160);
        IcyBufferedImage image = this.getImage(series, resolution, sz / 2, st / 2);
        IcyBufferedImage thumbnail = IcyBufferedImageUtil.scale(image, tnx, tny, IcyBufferedImageUtil.FilterType.BILINEAR);
        thumbnail.setColorMaps(image);
        return thumbnail;
    }

    @Override
    public Object getPixels(int series, int resolution, Rectangle rectangle, int z, int t, int c) throws UnsupportedFormatException, IOException {
        return this.getImage(series, resolution, rectangle, z, t, c).getDataXY(0);
    }

    @Override
    public IcyBufferedImage getImage(int series, int resolution, Rectangle rectangle, int z, int t) throws UnsupportedFormatException, IOException {
        return this.getImage(series, resolution, rectangle, z, t, -1);
    }

    @Override
    public IcyBufferedImage getImage(int series, int resolution, int z, int t, int c) throws UnsupportedFormatException, IOException {
        return this.getImage(series, resolution, null, z, t, c);
    }

    @Override
    public IcyBufferedImage getImage(int series, int resolution, int z, int t) throws UnsupportedFormatException, IOException {
        return this.getImage(series, resolution, null, z, t, -1);
    }

    @Override
    public IcyBufferedImage getImage(int series, int z, int t) throws UnsupportedFormatException, IOException {
        return this.getImage(series, 0, null, z, t, -1);
    }

    @Override
    public IcyBufferedImage getImage(int z, int t) throws UnsupportedFormatException, IOException {
        return this.getImage(0, 0, null, z, t, -1);
    }

    public Object getPixelsByTile(int series, int resolution, Rectangle region, int z, int t, int c, int tileW, int tileH, ProgressListener listener) throws UnsupportedFormatException, IOException {
        OMEXMLMetadata meta = this.getOMEXMLMetaData();
        int sizeX = MetaDataUtil.getSizeX(meta, series);
        int sizeY = MetaDataUtil.getSizeY(meta, series);
        DataType type = MetaDataUtil.getDataType(meta, series);
        boolean signed = type.isSigned();
        Rectangle adjRegion = new Rectangle(sizeX, sizeY);
        if (region != null) {
            adjRegion = adjRegion.intersection(region);
        }
        Dimension resDim = new Dimension(adjRegion.width >> resolution, adjRegion.height >> resolution);
        Object result = Array1DUtil.createArray(type, resDim.width * resDim.height);
        Processor readerProcessor = new Processor(Math.max(1, SystemUtil.getNumberOfCPUs() - 1));
        readerProcessor.setThreadName("Image tile reader");
        int tw = tileW;
        int th = tileH;
        if (tw <= 0) {
            tw = this.getTileWidth(series);
        }
        if (tw <= 0) {
            tw = 512;
        }
        if (th <= 0) {
            th = this.getTileHeight(series);
        }
        if (th <= 0) {
            th = 512;
        }
        List<Rectangle> tiles = ImageUtil.getTileList(adjRegion, tw, th);
        for (Rectangle tile : tiles) {
            while (readerProcessor.isFull()) {
                try {
                    Thread.sleep(0L);
                }
                catch (InterruptedException e) {
                    readerProcessor.shutdownNow();
                    break;
                }
            }
            readerProcessor.submit(new TilePixelsReader(series, resolution, tile.intersection(adjRegion), z, t, c, result, resDim, signed));
            if (listener == null || listener.notifyProgress(readerProcessor.getCompletedTaskCount(), tiles.size())) continue;
            readerProcessor.shutdownNow();
            break;
        }
        while (readerProcessor.isProcessing()) {
            try {
                Thread.sleep(1L);
            }
            catch (InterruptedException e) {
                readerProcessor.shutdownNow();
                break;
            }
            if (listener == null || listener.notifyProgress(readerProcessor.getCompletedTaskCount(), tiles.size())) continue;
            readerProcessor.shutdownNow();
            break;
        }
        readerProcessor.waitAll();
        return result;
    }

    public static int getResolutionFactor(int sizeX, int sizeY, int wantedSize) {
        int sx = sizeX / 2;
        int sy = sizeY / 2;
        int result = 0;
        while (sx > wantedSize || sy > wantedSize) {
            sx /= 2;
            sy /= 2;
            ++result;
        }
        return result;
    }

    public int getResolutionFactor(int series, int wantedSize) throws UnsupportedFormatException, IOException {
        OMEXMLMetadata meta = this.getOMEXMLMetaData();
        return AbstractImageProvider.getResolutionFactor(MetaDataUtil.getSizeX(meta, series), MetaDataUtil.getSizeY(meta, series), wantedSize);
    }

    class TilePixelsReader
    implements Runnable {
        final int series;
        final int resolution;
        final Rectangle region;
        final int z;
        final int t;
        final int c;
        final Object result;
        final Dimension resDim;
        final boolean signed;
        boolean done;
        boolean failed;

        public TilePixelsReader(int series, int resolution, Rectangle region, int z, int t, int c, Object result, Dimension resDim, boolean signed) {
            this.series = series;
            this.resolution = resolution;
            this.region = region;
            this.z = z;
            this.t = t;
            this.c = c;
            this.result = result;
            this.resDim = resDim;
            this.signed = signed;
            this.done = false;
            this.failed = false;
        }

        @Override
        public void run() {
            if (Thread.interrupted()) {
                this.failed = true;
                return;
            }
            try {
                Object obj = AbstractImageProvider.this.getPixels(this.series, this.resolution, this.region, this.z, this.t, this.c);
                int divider = (int)Math.pow(2.0, this.resolution);
                Array1DUtil.copyRect(obj, this.region.getSize(), null, this.result, this.resDim, new Point(this.region.x / divider, this.region.y / divider), this.signed);
            }
            catch (Exception e) {
                this.failed = true;
            }
            this.done = true;
        }
    }
}

