/*
 * Decompiled with CFR 0.152.
 */
package icy.plugin;

import icy.main.Icy;
import icy.network.NetworkUtil;
import icy.network.URLUtil;
import icy.plugin.PluginDescriptor;
import icy.preferences.PluginPreferences;
import icy.preferences.RepositoryPreferences;
import icy.system.IcyExceptionHandler;
import icy.system.thread.SingleProcessor;
import icy.system.thread.ThreadUtil;
import icy.util.XMLUtil;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EventListener;
import java.util.HashMap;
import java.util.List;
import javax.swing.event.EventListenerList;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class PluginRepositoryLoader {
    private static final String ID_ROOT = "plugins";
    private static final String ID_PLUGIN = "plugin";
    private static final PluginRepositoryLoader instance = new PluginRepositoryLoader();
    List<PluginDescriptor> plugins = new ArrayList<PluginDescriptor>();
    private final EventListenerList listeners = new EventListenerList();
    boolean loaded = false;
    boolean failed;
    private final Loader loader = new Loader();
    final SingleProcessor processor = new SingleProcessor(true, "Online Plugin Loader");

    private PluginRepositoryLoader() {
        this.load();
    }

    public static List<PluginDescriptor.PluginOnlineIdent> getPluginIdents(RepositoryPreferences.RepositoryInfo repos) {
        Document document;
        String address = repos.getLocation();
        boolean networkAddr = URLUtil.isNetworkURL(address);
        boolean betaAllowed = PluginPreferences.getAllowBeta();
        if (networkAddr && repos.getSupportParam()) {
            HashMap<String, String> values = new HashMap<String, String>();
            values.put("kernelVersion", Icy.version.toString());
            values.put("betaAllowed", Boolean.toString(betaAllowed));
            address = String.valueOf(address) + "?" + NetworkUtil.getContentString(values);
        }
        if ((document = XMLUtil.loadDocument(address, repos.getAuthenticationInfo(), false)) == null) {
            if (networkAddr && !NetworkUtil.hasInternetAccess()) {
                System.out.println("You are not connected to internet.");
            }
            return null;
        }
        ArrayList<PluginDescriptor.PluginOnlineIdent> result = new ArrayList<PluginDescriptor.PluginOnlineIdent>();
        Element pluginsNode = XMLUtil.getElement(document.getDocumentElement(), ID_ROOT);
        if (pluginsNode != null) {
            ArrayList<Node> nodes = XMLUtil.getChildren(pluginsNode, ID_PLUGIN);
            for (Node node : nodes) {
                PluginDescriptor.PluginOnlineIdent ident = new PluginDescriptor.PluginOnlineIdent();
                ident.loadFromXML(node);
                if (ident.isEmpty() || !ident.getRequiredKernelVersion().isLowerOrEqual(Icy.version) || !betaAllowed && ident.getVersion().isBeta()) continue;
                int ind = PluginDescriptor.PluginIdent.getIndex(result, ident.getClassName());
                if (ind != -1) {
                    if (!((PluginDescriptor.PluginOnlineIdent)result.get(ind)).isOlderOrEqual(ident)) continue;
                    result.set(ind, ident);
                    continue;
                }
                result.add(ident);
            }
        }
        return result;
    }

    private void load() {
        this.loaded = false;
        this.failed = false;
        this.processor.submit(this.loader);
    }

    public static synchronized void reload() {
        instance.load();
    }

    static List<PluginDescriptor> loadInternal(RepositoryPreferences.RepositoryInfo repos) {
        List<PluginDescriptor.PluginOnlineIdent> idents = PluginRepositoryLoader.getPluginIdents(repos);
        if (idents == null) {
            System.out.println("Can't access repository '" + repos.getName() + "'");
            return null;
        }
        ArrayList<PluginDescriptor> result = new ArrayList<PluginDescriptor>();
        for (PluginDescriptor.PluginOnlineIdent ident : idents) {
            try {
                result.add(new PluginDescriptor(ident, repos));
            }
            catch (Exception e) {
                System.out.println("PluginRepositoryLoader.load('" + repos.getLocation() + "') error :");
                IcyExceptionHandler.showErrorMessage(e, false);
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ArrayList<PluginDescriptor> getPlugins() {
        List<PluginDescriptor> list = PluginRepositoryLoader.instance.plugins;
        synchronized (list) {
            return new ArrayList<PluginDescriptor>(PluginRepositoryLoader.instance.plugins);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static PluginDescriptor getPlugin(String className) {
        List<PluginDescriptor> list = PluginRepositoryLoader.instance.plugins;
        synchronized (list) {
            return PluginDescriptor.getPlugin(PluginRepositoryLoader.instance.plugins, className);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<PluginDescriptor> getPlugins(String className) {
        List<PluginDescriptor> list = PluginRepositoryLoader.instance.plugins;
        synchronized (list) {
            return PluginDescriptor.getPlugins(PluginRepositoryLoader.instance.plugins, className);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<PluginDescriptor> getPlugins(RepositoryPreferences.RepositoryInfo repos) {
        ArrayList<PluginDescriptor> result = new ArrayList<PluginDescriptor>();
        List<PluginDescriptor> list = PluginRepositoryLoader.instance.plugins;
        synchronized (list) {
            for (PluginDescriptor plugin : PluginRepositoryLoader.instance.plugins) {
                if (!plugin.getRepository().equals(repos)) continue;
                result.add(plugin);
            }
        }
        return result;
    }

    public static boolean isLoading() {
        return PluginRepositoryLoader.instance.processor.isProcessing();
    }

    public static boolean isLoaded() {
        return PluginRepositoryLoader.instance.failed || PluginRepositoryLoader.instance.loaded;
    }

    public static void waitLoaded() {
        while (!PluginRepositoryLoader.isLoaded()) {
            ThreadUtil.sleep(10);
        }
    }

    @Deprecated
    public static boolean isBasicLoaded() {
        return PluginRepositoryLoader.isLoaded();
    }

    @Deprecated
    public static boolean isDescriptorsLoaded() {
        return true;
    }

    @Deprecated
    public static boolean isImagesLoaded() {
        return true;
    }

    @Deprecated
    public static void waitBasicLoaded() {
        PluginRepositoryLoader.waitLoaded();
    }

    @Deprecated
    public static void waitDescriptorsLoaded() {
    }

    public static boolean failed() {
        return PluginRepositoryLoader.instance.failed;
    }

    void changed(PluginDescriptor plugin) {
        this.fireEvent(plugin);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void addListener(PluginRepositoryLoaderListener listener) {
        EventListenerList eventListenerList = PluginRepositoryLoader.instance.listeners;
        synchronized (eventListenerList) {
            PluginRepositoryLoader.instance.listeners.add(PluginRepositoryLoaderListener.class, listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void removeListener(PluginRepositoryLoaderListener listener) {
        EventListenerList eventListenerList = PluginRepositoryLoader.instance.listeners;
        synchronized (eventListenerList) {
            PluginRepositoryLoader.instance.listeners.remove(PluginRepositoryLoaderListener.class, listener);
        }
    }

    private void fireEvent(PluginDescriptor plugin) {
        PluginRepositoryLoaderListener[] pluginRepositoryLoaderListenerArray = (PluginRepositoryLoaderListener[])this.listeners.getListeners(PluginRepositoryLoaderListener.class);
        int n = pluginRepositoryLoaderListenerArray.length;
        int n2 = 0;
        while (n2 < n) {
            PluginRepositoryLoaderListener listener = pluginRepositoryLoaderListenerArray[n2];
            listener.pluginRepositeryLoaderChanged(plugin);
            ++n2;
        }
    }

    private class Loader
    implements Runnable {
        @Override
        public void run() {
            ArrayList<PluginDescriptor> newPlugins = new ArrayList<PluginDescriptor>();
            try {
                ArrayList<RepositoryPreferences.RepositoryInfo> repositories = RepositoryPreferences.getRepositeries();
                for (RepositoryPreferences.RepositoryInfo repoInfo : repositories) {
                    if (PluginRepositoryLoader.this.processor.hasWaitingTasks()) {
                        return;
                    }
                    if (!repoInfo.isEnabled()) continue;
                    List<PluginDescriptor> pluginsRepos = PluginRepositoryLoader.loadInternal(repoInfo);
                    if (pluginsRepos == null) {
                        PluginRepositoryLoader.this.failed = true;
                        return;
                    }
                    newPlugins.addAll(pluginsRepos);
                }
                Collections.sort(newPlugins, PluginDescriptor.PluginNameSorter.instance);
                PluginRepositoryLoader.this.plugins = newPlugins;
            }
            catch (Exception e) {
                IcyExceptionHandler.showErrorMessage(e, true);
                PluginRepositoryLoader.this.failed = true;
                return;
            }
            PluginRepositoryLoader.this.loaded = true;
            PluginRepositoryLoader.this.changed(null);
        }
    }

    public static interface PluginRepositoryLoaderListener
    extends EventListener {
        public void pluginRepositeryLoaderChanged(PluginDescriptor var1);
    }
}

