/*
 * Decompiled with CFR 0.152.
 */
package icy.plugin;

import icy.gui.frame.progress.AnnounceFrame;
import icy.gui.frame.progress.CancelableProgressFrame;
import icy.gui.plugin.PluginUpdateFrame;
import icy.main.Icy;
import icy.network.NetworkUtil;
import icy.plugin.PluginDescriptor;
import icy.plugin.PluginInstaller;
import icy.plugin.PluginLoader;
import icy.plugin.PluginRepositoryLoader;
import icy.system.thread.ThreadUtil;
import java.util.ArrayList;
import java.util.List;

public class PluginUpdater {
    private static final int ANNOUNCE_SHOWTIME = 15;
    private static boolean silent;
    private static boolean checking;
    private static Runnable checker;

    static {
        checking = false;
        checker = new Runnable(){

            @Override
            public void run() {
                PluginUpdater.processCheckUpdate();
            }
        };
    }

    public static boolean isCheckingForUpdate() {
        return checking || ThreadUtil.hasWaitingBgSingleTask(checker);
    }

    public static void checkUpdate(boolean silent) {
        if (!PluginUpdater.isCheckingForUpdate()) {
            PluginUpdater.silent = silent;
            ThreadUtil.bgRunSingle(checker);
        }
    }

    @Deprecated
    public static void checkUpdate(boolean showProgress, boolean auto) {
        PluginUpdater.checkUpdate(!showProgress || auto);
    }

    public static PluginDescriptor getUpdate(PluginDescriptor plugin) {
        PluginDescriptor onlinePlugin;
        if (plugin.isKernelPlugin()) {
            return null;
        }
        List<PluginDescriptor> onlinePlugins = PluginRepositoryLoader.getPlugins(plugin.getClassName());
        if (onlinePlugins.size() > 0) {
            PluginDescriptor lastVersion = null;
            for (PluginDescriptor currentVersion : onlinePlugins) {
                if (lastVersion != null && !currentVersion.isNewer(lastVersion)) continue;
                lastVersion = currentVersion;
            }
            onlinePlugin = lastVersion;
        } else {
            onlinePlugin = null;
        }
        if (onlinePlugin != null && onlinePlugin.getVersion().isGreater(plugin.getVersion())) {
            return onlinePlugin;
        }
        return null;
    }

    public static void updatePlugins(List<PluginDescriptor> plugins, boolean showProgress) {
        try {
            for (PluginDescriptor plugin : PluginInstaller.orderDependencies(plugins)) {
                PluginInstaller.install(plugin, showProgress);
            }
        }
        finally {
            PluginLoader.reloadAsynch();
        }
    }

    public static synchronized void processCheckUpdate() {
        checking = true;
        try {
            final ArrayList<PluginDescriptor> toInstallPlugins = new ArrayList<PluginDescriptor>();
            ArrayList<PluginDescriptor> localPlugins = PluginLoader.getPlugins(false);
            try (CancelableProgressFrame checkingFrame = !silent && !Icy.getMainInterface().isHeadLess() ? new CancelableProgressFrame("checking for plugins update...") : null;){
                PluginRepositoryLoader.reload();
                PluginRepositoryLoader.waitLoaded();
                if (PluginRepositoryLoader.failed()) {
                    if (!silent && !Icy.getMainInterface().isHeadLess()) {
                        if (!NetworkUtil.hasInternetAccess()) {
                            new AnnounceFrame("You are not connected to internet.", 10);
                        } else {
                            new AnnounceFrame("Can't access the repositories... You should verify your connection.", 10);
                        }
                    }
                    return;
                }
                for (PluginDescriptor localPlugin : localPlugins) {
                    PluginDescriptor onlinePlugin = PluginUpdater.getUpdate(localPlugin);
                    if (onlinePlugin == null) continue;
                    onlinePlugin.loadDescriptor();
                    toInstallPlugins.add(onlinePlugin);
                }
                ArrayList<PluginDescriptor> onlinePlugins = PluginRepositoryLoader.getPlugins();
                for (PluginDescriptor onlinePlugin : onlinePlugins) {
                    if (!onlinePlugin.isInstalled() || PluginLoader.isLoaded(onlinePlugin.getClassName())) continue;
                    onlinePlugin.loadDescriptor();
                    toInstallPlugins.add(onlinePlugin);
                }
            }
            if (!toInstallPlugins.isEmpty()) {
                if (silent || Icy.getMainInterface().isHeadLess()) {
                    PluginUpdater.updatePlugins(toInstallPlugins, true);
                } else {
                    new AnnounceFrame(String.valueOf(toInstallPlugins.size()) + " plugin update are available", "View", new Runnable(){

                        @Override
                        public void run() {
                            new PluginUpdateFrame(toInstallPlugins);
                        }
                    }, 15);
                }
            } else if (!silent && !Icy.getMainInterface().isHeadLess()) {
                new AnnounceFrame("No plugin udpate available", 10);
            }
        }
        finally {
            checking = false;
        }
    }
}

