/*
 * Decompiled with CFR 0.152.
 */
package icy.roi.edit;

import icy.painter.Anchor3D;
import icy.roi.ROI3D;
import icy.roi.edit.AbstractPoint3DROIEdit;
import icy.type.point.Point3D;
import javax.swing.undo.CannotRedoException;
import javax.swing.undo.CannotUndoException;
import javax.swing.undo.UndoableEdit;
import plugins.kernel.roi.roi3d.ROI3DPolyLine;

public class Point3DAddedROIEdit
extends AbstractPoint3DROIEdit {
    Point3D position;
    final int index;

    public Point3DAddedROIEdit(ROI3D roi, Anchor3D point) {
        super(roi, point, "ROI point added");
        this.position = point.getPosition();
        if (!(roi instanceof ROI3DPolyLine)) {
            throw new IllegalArgumentException("Point3DAddedROIEdit: " + roi.getClassName() + " class not supported !");
        }
        this.index = ((ROI3DPolyLine)roi).getControlPoints().indexOf(point);
    }

    @Override
    public void undo() throws CannotUndoException {
        super.undo();
        if (this.getROI3D() instanceof ROI3DPolyLine) {
            ROI3DPolyLine roi = (ROI3DPolyLine)this.getROI3D();
            roi.removePoint(this.point);
        }
    }

    @Override
    public void redo() throws CannotRedoException {
        super.redo();
        this.point.setPosition(this.position);
        if (this.getROI3D() instanceof ROI3DPolyLine) {
            ROI3DPolyLine roi = (ROI3DPolyLine)this.getROI3D();
            roi.addPoint(this.point, Math.min(this.index, roi.getControlPoints().size()));
        }
    }

    @Override
    public boolean addEdit(UndoableEdit edit) {
        return false;
    }

    @Override
    public void die() {
        super.die();
        this.position = null;
    }
}

