/*
 * Decompiled with CFR 0.152.
 */
package icy.system.thread;

import icy.main.Icy;
import icy.system.IcyExceptionHandler;
import icy.system.SystemUtil;
import icy.system.thread.ThreadUtil;
import java.util.ArrayList;
import java.util.EventListener;
import java.util.List;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.Callable;
import java.util.concurrent.Future;
import java.util.concurrent.FutureTask;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.RejectedExecutionHandler;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;

public class Processor
extends ThreadPoolExecutor {
    public static final int DEFAULT_MAX_WAITING = 1024;
    public static final int DEFAULT_MAX_PROCESSING = SystemUtil.getNumberOfCPUs();
    public static final int MIN_PRIORITY = 1;
    public static final int NORM_PRIORITY = 5;
    public static final int MAX_PRIORITY = 10;
    int priority;
    protected Runnable waitingExecution;
    protected long lastAdd;

    public Processor(int maxWaiting, int numThread, int priority) {
        super(numThread, numThread, 2L, TimeUnit.SECONDS, maxWaiting == -1 ? new LinkedBlockingQueue<Runnable>() : new LinkedBlockingQueue(maxWaiting));
        this.setThreadFactory(new ProcessorThreadFactory("Processor"));
        this.setRejectedExecutionHandler(new ProcessorRejectedExecutionHandler());
        this.allowCoreThreadTimeOut(true);
        this.priority = priority;
        this.waitingExecution = null;
    }

    public Processor(int maxWaiting, int numThread) {
        this(maxWaiting, numThread, 5);
    }

    public Processor(int numThread) {
        this(-1, numThread, 5);
    }

    public Processor() {
        this(1024, DEFAULT_MAX_PROCESSING);
    }

    @Deprecated
    public boolean removeTask(Runnable task) {
        return this.removeFirstWaitingTask(task);
    }

    @Deprecated
    public boolean addTask(Runnable task, boolean onEDT, int id) {
        return this.addTask(task, onEDT);
    }

    @Deprecated
    public boolean addTask(Runnable task, boolean onEDT) {
        try {
            this.submit(task, onEDT);
        }
        catch (RejectedExecutionException E) {
            return false;
        }
        return true;
    }

    @Deprecated
    public boolean addTask(Runnable task) {
        return this.addTask(task, false);
    }

    @Override
    public boolean remove(Runnable task) {
        if (this.waitingExecution == task) {
            this.waitingExecution = null;
        }
        return super.remove(task);
    }

    @Deprecated
    protected <T> FutureTaskAdapter<T> newTaskFor(Runnable runnable, T value, boolean onEDT) {
        return new FutureTaskAdapterEDT<T>(runnable, value, onEDT);
    }

    @Deprecated
    protected <T> FutureTaskAdapter<T> newTaskFor(Callable<T> callable, boolean onEDT) {
        return new FutureTaskAdapterEDT<T>(callable, onEDT);
    }

    protected <T> FutureTaskAdapter<T> newTaskFor(boolean handledException, Runnable runnable, T value) {
        return new FutureTaskAdapter<T>(runnable, value, handledException);
    }

    protected <T> FutureTaskAdapter<T> newTaskFor(boolean handledException, Callable<T> callable) {
        return new FutureTaskAdapter<T>(callable, handledException);
    }

    @Override
    public void execute(Runnable task) {
        super.execute(task);
        this.waitingExecution = task;
    }

    protected synchronized <T> FutureTask<T> submit(FutureTaskAdapter<T> task) {
        this.execute(task);
        return task;
    }

    @Override
    public Future<?> submit(Runnable task) {
        if (task == null) {
            throw new NullPointerException();
        }
        return this.submit(this.newTaskFor(false, task, null));
    }

    @Override
    public <T> Future<T> submit(Runnable task, T result) {
        if (task == null) {
            throw new NullPointerException();
        }
        return this.submit(this.newTaskFor(false, task, result));
    }

    @Override
    public <T> Future<T> submit(Callable<T> task) {
        if (task == null) {
            throw new NullPointerException();
        }
        return this.submit(this.newTaskFor(false, task));
    }

    public Future<?> submit(boolean handleException, Runnable task) {
        if (task == null) {
            throw new NullPointerException();
        }
        return this.submit(this.newTaskFor(handleException, task, null));
    }

    public <T> Future<T> submit(boolean handleException, Runnable task, T result) {
        if (task == null) {
            throw new NullPointerException();
        }
        return this.submit(this.newTaskFor(handleException, task, result));
    }

    public <T> Future<T> submit(boolean handleException, Callable<T> task) {
        if (task == null) {
            throw new NullPointerException();
        }
        return this.submit(this.newTaskFor(handleException, task));
    }

    @Deprecated
    public Future<?> submit(Runnable task, boolean onEDT) {
        if (task == null) {
            throw new NullPointerException();
        }
        return this.submit(this.newTaskFor(task, null, onEDT));
    }

    @Deprecated
    public <T> Future<T> submit(Runnable task, T result, boolean onEDT) {
        if (task == null) {
            throw new NullPointerException();
        }
        return this.submit(this.newTaskFor(task, result, onEDT));
    }

    @Deprecated
    public <T> Future<T> submit(Callable<T> task, boolean onEDT) {
        if (task == null) {
            throw new NullPointerException();
        }
        return this.submit(this.newTaskFor(task, onEDT));
    }

    public boolean isProcessing() {
        return this.getActiveCount() > 0 || this.hasWaitingTasks();
    }

    public void waitAll() {
        while (this.isProcessing()) {
            ThreadUtil.sleep(1);
        }
    }

    public void shutdownAndWait() {
        this.shutdown();
        while (!this.isTerminated()) {
            ThreadUtil.sleep(1);
        }
    }

    public int getPriority() {
        return this.priority;
    }

    public void setPriority(int priority) {
        this.priority = priority;
    }

    @Deprecated
    public String getDefaultThreadName() {
        return ((ProcessorThreadFactory)this.getThreadFactory()).getName();
    }

    @Deprecated
    public void setDefaultThreadName(String defaultThreadName) {
        ((ProcessorThreadFactory)this.getThreadFactory()).setName(defaultThreadName);
    }

    public String getThreadName() {
        return ((ProcessorThreadFactory)this.getThreadFactory()).getName();
    }

    public void setThreadName(String defaultThreadName) {
        ((ProcessorThreadFactory)this.getThreadFactory()).setName(defaultThreadName);
    }

    public int getFreeSlotNumber() {
        return this.getQueue().remainingCapacity();
    }

    public boolean isFull() {
        return this.getFreeSlotNumber() == 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected List<FutureTaskAdapter<?>> getWaitingTasks() {
        BlockingQueue<Runnable> q = this.getQueue();
        ArrayList result = new ArrayList();
        BlockingQueue<Runnable> blockingQueue = q;
        synchronized (blockingQueue) {
            for (Runnable r : q) {
                result.add((FutureTaskAdapter)r);
            }
        }
        return result;
    }

    protected List<FutureTaskAdapter<?>> getWaitingTasks(Runnable task) {
        ArrayList result = new ArrayList();
        for (FutureTaskAdapter<?> f : this.getWaitingTasks()) {
            if (f.runnable != task) continue;
            result.add(f);
        }
        return result;
    }

    protected List<FutureTaskAdapter<?>> getWaitingTasks(Callable<?> task) {
        ArrayList result = new ArrayList();
        for (FutureTaskAdapter<?> f : this.getWaitingTasks()) {
            if (f.callable != task) continue;
            result.add(f);
        }
        return result;
    }

    public int getWaitingTasksCount() {
        int result = this.getQueue().size();
        if (result == 0 && this.waitingExecution != null && System.currentTimeMillis() - this.lastAdd < 1000L) {
            return 1;
        }
        return result;
    }

    @Deprecated
    public int getWaitingTasksCount(int id) {
        return 0;
    }

    public int getWaitingTasksCount(Runnable task) {
        int result = 0;
        for (FutureTaskAdapter<?> f : this.getWaitingTasks()) {
            if (f.runnable != task) continue;
            ++result;
        }
        return result;
    }

    public int getWaitingTasksCount(Callable<?> task) {
        int result = 0;
        for (FutureTaskAdapter<?> f : this.getWaitingTasks()) {
            if (f.callable != task) continue;
            ++result;
        }
        return result;
    }

    public boolean hasWaitingTasks() {
        return this.getWaitingTasksCount() > 0;
    }

    @Deprecated
    public boolean hasWaitingTasks(int id) {
        return false;
    }

    public boolean hasWaitingTasks(Runnable task) {
        for (FutureTaskAdapter<?> f : this.getWaitingTasks()) {
            if (f.runnable != task) continue;
            return true;
        }
        return false;
    }

    public boolean hasWaitingTasks(Callable<?> task) {
        for (FutureTaskAdapter<?> f : this.getWaitingTasks()) {
            if (f.callable != task) continue;
            return true;
        }
        return false;
    }

    @Deprecated
    public boolean removeFirstWaitingTask(int id) {
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean removeFirstWaitingTask(FutureTaskAdapter<?> task) {
        if (task == null) {
            return false;
        }
        BlockingQueue<Runnable> blockingQueue = this.getQueue();
        synchronized (blockingQueue) {
            for (FutureTaskAdapter<?> f : this.getWaitingTasks()) {
                if (f != task) continue;
                return this.remove(f);
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean removeFirstWaitingTask(Runnable task) {
        if (task == null) {
            return false;
        }
        BlockingQueue<Runnable> blockingQueue = this.getQueue();
        synchronized (blockingQueue) {
            for (FutureTaskAdapter<?> f : this.getWaitingTasks()) {
                if (f.runnable != task) continue;
                return this.remove(f);
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean removeFirstWaitingTask(Callable<?> task) {
        if (task == null) {
            return false;
        }
        BlockingQueue<Runnable> blockingQueue = this.getQueue();
        synchronized (blockingQueue) {
            for (FutureTaskAdapter<?> f : this.getWaitingTasks()) {
                if (f.callable != task) continue;
                return this.remove(f);
            }
        }
        return false;
    }

    @Deprecated
    public boolean removeWaitingTasks(int id) {
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean removeWaitingTasks(Runnable task) {
        boolean result = false;
        BlockingQueue<Runnable> blockingQueue = this.getQueue();
        synchronized (blockingQueue) {
            for (FutureTaskAdapter<?> f : this.getWaitingTasks(task)) {
                result |= this.remove(f);
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean removeWaitingTasks(Callable<?> task) {
        boolean result = false;
        BlockingQueue<Runnable> blockingQueue = this.getQueue();
        synchronized (blockingQueue) {
            for (FutureTaskAdapter<?> f : this.getWaitingTasks(task)) {
                result |= this.remove(f);
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeAllWaitingTasks() {
        BlockingQueue<Runnable> q;
        this.waitingExecution = null;
        BlockingQueue<Runnable> blockingQueue = q = this.getQueue();
        synchronized (blockingQueue) {
            q.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Deprecated
    public void limitWaitingTask(Runnable task, int value) {
        BlockingQueue<Runnable> blockingQueue = this.getQueue();
        synchronized (blockingQueue) {
            List<FutureTaskAdapter<?>> tasks = this.getWaitingTasks(task);
            int numToRemove = tasks.size() - value;
            int i = 0;
            while (i < numToRemove) {
                this.remove(tasks.get(i));
                ++i;
            }
        }
    }

    @Deprecated
    public void limitWaitingTask(int id, int value) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Deprecated
    public boolean limitWaitingTask(int value) {
        BlockingQueue<Runnable> blockingQueue = this.getQueue();
        synchronized (blockingQueue) {
            List<FutureTaskAdapter<?>> tasks = this.getWaitingTasks();
            int numToRemove = tasks.size() - value;
            int i = 0;
            while (i < numToRemove) {
                this.remove(tasks.get(i));
                ++i;
            }
        }
        return false;
    }

    @Deprecated
    public void addListener(ProcessorEventListener listener) {
    }

    @Deprecated
    public void removeListener(ProcessorEventListener listener) {
    }

    @Deprecated
    public void fireDoneEvent(FutureTaskAdapter<?> task) {
    }

    @Override
    protected void beforeExecute(Thread t, Runnable r) {
        super.beforeExecute(t, r);
        this.waitingExecution = null;
    }

    @Deprecated
    protected class CallableAdapter<T>
    implements Callable<T> {
        private final Callable<T> task;
        private final boolean onEDT;

        public CallableAdapter(Callable<T> task, boolean onEDT) {
            this.task = task;
            this.onEDT = onEDT;
        }

        public Callable<T> getTask() {
            return this.task;
        }

        @Override
        public T call() throws Exception {
            if (this.task != null) {
                if (this.onEDT) {
                    return ThreadUtil.invokeNow(this.task);
                }
                return this.task.call();
            }
            return null;
        }
    }

    protected class FutureTaskAdapter<T>
    extends FutureTask<T> {
        public Runnable runnable;
        public Callable<T> callable;
        final boolean handleException;

        public FutureTaskAdapter(Runnable runnable, T result, boolean handleException) {
            super(runnable, result);
            this.runnable = runnable;
            this.callable = null;
            this.handleException = handleException;
        }

        public FutureTaskAdapter(Runnable runnable, boolean handleException) {
            this(runnable, null, handleException);
        }

        public FutureTaskAdapter(Callable<T> callable, boolean handleException) {
            super(callable);
            this.runnable = null;
            this.callable = callable;
            this.handleException = handleException;
        }

        @Override
        protected void done() {
            super.done();
            if (this.handleException) {
                try {
                    this.get();
                }
                catch (Exception e) {
                    IcyExceptionHandler.handleException(e.getCause(), true);
                }
            }
        }
    }

    @Deprecated
    protected class FutureTaskAdapterEDT<T>
    extends FutureTaskAdapter<T> {
        public FutureTaskAdapterEDT(Runnable runnable, T result, boolean onEDT) {
            super(new RunnableAdapter(runnable, onEDT), result, true);
            this.runnable = runnable;
            this.callable = null;
        }

        public FutureTaskAdapterEDT(Runnable runnable, boolean onEDT) {
            this(runnable, null, onEDT);
        }

        public FutureTaskAdapterEDT(Callable<T> callable, boolean onEDT) {
            super(new CallableAdapter<T>(callable, onEDT), true);
            this.runnable = null;
            this.callable = callable;
        }

        public Runnable getRunnable() {
            return this.runnable;
        }

        public Callable<T> getCallable() {
            return this.callable;
        }
    }

    @Deprecated
    public static interface ProcessorEventListener
    extends EventListener {
        public void processDone(Processor var1, Runnable var2);
    }

    protected class ProcessorRejectedExecutionHandler
    implements RejectedExecutionHandler {
        protected ProcessorRejectedExecutionHandler() {
        }

        @Override
        public void rejectedExecution(Runnable r, ThreadPoolExecutor executor) {
            if (!Icy.isExiting()) {
                throw new RejectedExecutionException("Cannot add new task, ignore execution of " + r);
            }
        }
    }

    protected class ProcessorThreadFactory
    implements ThreadFactory {
        String name;

        public ProcessorThreadFactory(String name) {
            this.setName(name);
        }

        public String getName() {
            return this.name;
        }

        public void setName(String value) {
            this.name = value;
        }

        String getThreadName() {
            String result = this.name;
            return result;
        }

        @Override
        public Thread newThread(Runnable r) {
            Thread result = new Thread(r, this.getThreadName());
            result.setPriority(Processor.this.priority);
            return result;
        }
    }

    @Deprecated
    protected class RunnableAdapter
    implements Runnable {
        private final Runnable task;
        private final boolean onEDT;

        public RunnableAdapter(Runnable runnable, boolean onEDT) {
            this.task = runnable;
            this.onEDT = onEDT;
        }

        @Override
        public void run() {
            if (this.task != null) {
                if (this.onEDT) {
                    ThreadUtil.invokeNow(this.task);
                } else {
                    this.task.run();
                }
            }
        }

        public Runnable getTask() {
            return this.task;
        }
    }
}

