/*
 * Decompiled with CFR 0.152.
 */
package icy.type.dimension;

import icy.type.dimension.Dimension2D;
import icy.type.dimension.Dimension3D;
import icy.type.dimension.Dimension4D;
import java.awt.Dimension;
import java.awt.geom.Dimension2D;

public abstract class Dimension5D
implements Cloneable {
    public abstract double getSizeX();

    public abstract double getSizeY();

    public abstract double getSizeZ();

    public abstract double getSizeT();

    public abstract double getSizeC();

    public abstract void setSizeX(double var1);

    public abstract void setSizeY(double var1);

    public abstract void setSizeZ(double var1);

    public abstract void setSizeT(double var1);

    public abstract void setSizeC(double var1);

    public abstract void setSize(double var1, double var3, double var5, double var7, double var9);

    public void setSize(Dimension5D d) {
        this.setSize(d.getSizeX(), d.getSizeY(), d.getSizeZ(), d.getSizeT(), d.getSizeC());
    }

    public abstract boolean isInfiniteX();

    public abstract boolean isInfiniteY();

    public abstract boolean isInfiniteZ();

    public abstract boolean isInfiniteT();

    public abstract boolean isInfiniteC();

    public abstract Dimension2D toDimension2D();

    public abstract Dimension3D toDimension3D();

    public abstract Dimension4D toDimension4D();

    public Integer toInteger() {
        return new Integer((int)Math.ceil(this.getSizeX()), (int)Math.ceil(this.getSizeY()), (int)Math.ceil(this.getSizeZ()), (int)Math.ceil(this.getSizeT()), (int)Math.ceil(this.getSizeC()));
    }

    public boolean equals(Object obj) {
        if (obj instanceof Dimension5D) {
            Dimension5D dim = (Dimension5D)obj;
            return this.getSizeX() == dim.getSizeX() && this.getSizeY() == dim.getSizeY() && this.getSizeZ() == dim.getSizeZ() && this.getSizeT() == dim.getSizeT() && this.getSizeC() == dim.getSizeC();
        }
        return super.equals(obj);
    }

    public Object clone() {
        try {
            return super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new InternalError();
        }
    }

    public String toString() {
        return String.valueOf(this.getClass().getName()) + "[" + this.getSizeX() + "," + this.getSizeY() + "," + this.getSizeZ() + "," + this.getSizeT() + "," + this.getSizeC() + "]";
    }

    public static class Double
    extends Dimension5D {
        public double sizeX;
        public double sizeY;
        public double sizeZ;
        public double sizeT;
        public double sizeC;

        public Double(double sizeX, double sizeY, double sizeZ, double sizeT, double sizeC) {
            this.sizeX = sizeX;
            this.sizeY = sizeY;
            this.sizeZ = sizeZ;
            this.sizeT = sizeT;
            this.sizeC = sizeC;
        }

        public Double(double[] sizeXYZTC) {
            int len = sizeXYZTC.length;
            if (len > 0) {
                this.sizeX = sizeXYZTC[0];
            }
            if (len > 1) {
                this.sizeY = sizeXYZTC[1];
            }
            if (len > 2) {
                this.sizeZ = sizeXYZTC[2];
            }
            if (len > 3) {
                this.sizeT = sizeXYZTC[3];
            }
            if (len > 3) {
                this.sizeC = sizeXYZTC[4];
            }
        }

        public Double() {
            this(0.0, 0.0, 0.0, 0.0, 0.0);
        }

        @Override
        public double getSizeX() {
            return this.sizeX;
        }

        @Override
        public double getSizeY() {
            return this.sizeY;
        }

        @Override
        public double getSizeZ() {
            return this.sizeZ;
        }

        @Override
        public double getSizeT() {
            return this.sizeT;
        }

        @Override
        public double getSizeC() {
            return this.sizeC;
        }

        @Override
        public void setSizeX(double value) {
            this.sizeX = value;
        }

        @Override
        public void setSizeY(double value) {
            this.sizeY = value;
        }

        @Override
        public void setSizeZ(double value) {
            this.sizeZ = value;
        }

        @Override
        public void setSizeT(double value) {
            this.sizeT = value;
        }

        @Override
        public void setSizeC(double value) {
            this.sizeC = value;
        }

        @Override
        public boolean isInfiniteX() {
            return this.getSizeX() == java.lang.Double.POSITIVE_INFINITY;
        }

        @Override
        public boolean isInfiniteY() {
            return this.getSizeY() == java.lang.Double.POSITIVE_INFINITY;
        }

        @Override
        public boolean isInfiniteZ() {
            return this.getSizeZ() == java.lang.Double.POSITIVE_INFINITY;
        }

        @Override
        public boolean isInfiniteT() {
            return this.getSizeT() == java.lang.Double.POSITIVE_INFINITY;
        }

        @Override
        public boolean isInfiniteC() {
            return this.getSizeC() == java.lang.Double.POSITIVE_INFINITY;
        }

        @Override
        public void setSize(double sizeX, double sizeY, double sizeZ, double sizeT, double sizeC) {
            this.sizeX = sizeX;
            this.sizeY = sizeY;
            this.sizeZ = sizeZ;
            this.sizeT = sizeT;
            this.sizeC = sizeC;
        }

        @Override
        public Dimension2D toDimension2D() {
            return new Dimension2D.Double(this.sizeX, this.sizeY);
        }

        @Override
        public Dimension3D toDimension3D() {
            return new Dimension3D.Double(this.sizeX, this.sizeY, this.sizeZ);
        }

        @Override
        public Dimension4D toDimension4D() {
            return new Dimension4D.Double(this.sizeX, this.sizeY, this.sizeZ, this.sizeT);
        }
    }

    public static class Float
    extends Dimension5D {
        public float sizeX;
        public float sizeY;
        public float sizeZ;
        public float sizeT;
        public float sizeC;

        public Float(float sizeX, float sizeY, float sizeZ, float sizeT, float sizeC) {
            this.sizeX = sizeX;
            this.sizeY = sizeY;
            this.sizeZ = sizeZ;
            this.sizeT = sizeT;
            this.sizeC = sizeC;
        }

        public Float(float[] sizeXYZTC) {
            int len = sizeXYZTC.length;
            if (len > 0) {
                this.sizeX = sizeXYZTC[0];
            }
            if (len > 1) {
                this.sizeY = sizeXYZTC[1];
            }
            if (len > 2) {
                this.sizeZ = sizeXYZTC[2];
            }
            if (len > 3) {
                this.sizeT = sizeXYZTC[3];
            }
            if (len > 3) {
                this.sizeC = sizeXYZTC[4];
            }
        }

        public Float() {
            this(0.0f, 0.0f, 0.0f, 0.0f, 0.0f);
        }

        @Override
        public double getSizeX() {
            return this.sizeX;
        }

        @Override
        public double getSizeY() {
            return this.sizeY;
        }

        @Override
        public double getSizeZ() {
            return this.sizeZ;
        }

        @Override
        public double getSizeT() {
            return this.sizeT;
        }

        @Override
        public double getSizeC() {
            return this.sizeC;
        }

        @Override
        public void setSizeX(double value) {
            this.sizeX = (float)value;
        }

        @Override
        public void setSizeY(double value) {
            this.sizeY = (float)value;
        }

        @Override
        public void setSizeZ(double value) {
            this.sizeZ = (float)value;
        }

        @Override
        public void setSizeT(double value) {
            this.sizeT = (float)value;
        }

        @Override
        public void setSizeC(double value) {
            this.sizeC = (float)value;
        }

        @Override
        public boolean isInfiniteX() {
            return this.getSizeX() == java.lang.Double.POSITIVE_INFINITY;
        }

        @Override
        public boolean isInfiniteY() {
            return this.getSizeY() == java.lang.Double.POSITIVE_INFINITY;
        }

        @Override
        public boolean isInfiniteZ() {
            return this.getSizeZ() == java.lang.Double.POSITIVE_INFINITY;
        }

        @Override
        public boolean isInfiniteT() {
            return this.getSizeT() == java.lang.Double.POSITIVE_INFINITY;
        }

        @Override
        public boolean isInfiniteC() {
            return this.getSizeC() == java.lang.Double.POSITIVE_INFINITY;
        }

        @Override
        public void setSize(double sizeX, double sizeY, double sizeZ, double sizeT, double sizeC) {
            this.sizeX = (float)sizeX;
            this.sizeY = (float)sizeY;
            this.sizeZ = (float)sizeZ;
            this.sizeT = (float)sizeT;
            this.sizeC = (float)sizeC;
        }

        @Override
        public Dimension2D toDimension2D() {
            return new Dimension2D.Float(this.sizeX, this.sizeY);
        }

        @Override
        public Dimension3D toDimension3D() {
            return new Dimension3D.Float(this.sizeX, this.sizeY, this.sizeZ);
        }

        @Override
        public Dimension4D toDimension4D() {
            return new Dimension4D.Float(this.sizeX, this.sizeY, this.sizeZ, this.sizeT);
        }
    }

    public static class Integer
    extends Dimension5D {
        public int sizeX;
        public int sizeY;
        public int sizeZ;
        public int sizeT;
        public int sizeC;

        public Integer(int sizeX, int sizeY, int sizeZ, int sizeT, int sizeC) {
            this.sizeX = sizeX;
            this.sizeY = sizeY;
            this.sizeZ = sizeZ;
            this.sizeT = sizeT;
            this.sizeC = sizeC;
        }

        public Integer(int[] sizeXYZTC) {
            int len = sizeXYZTC.length;
            if (len > 0) {
                this.sizeX = sizeXYZTC[0];
            }
            if (len > 1) {
                this.sizeY = sizeXYZTC[1];
            }
            if (len > 2) {
                this.sizeZ = sizeXYZTC[2];
            }
            if (len > 3) {
                this.sizeT = sizeXYZTC[3];
            }
            if (len > 4) {
                this.sizeC = sizeXYZTC[4];
            }
        }

        public Integer() {
            this(0, 0, 0, 0, 0);
        }

        @Override
        public double getSizeX() {
            return this.sizeX;
        }

        @Override
        public double getSizeY() {
            return this.sizeY;
        }

        @Override
        public double getSizeZ() {
            return this.sizeZ;
        }

        @Override
        public double getSizeT() {
            return this.sizeT;
        }

        @Override
        public double getSizeC() {
            return this.sizeC;
        }

        @Override
        public void setSizeX(double value) {
            this.sizeX = (int)Math.ceil(value);
        }

        @Override
        public void setSizeY(double value) {
            this.sizeY = (int)Math.ceil(value);
        }

        @Override
        public void setSizeZ(double value) {
            this.sizeZ = (int)Math.ceil(value);
        }

        @Override
        public void setSizeT(double value) {
            this.sizeT = (int)Math.ceil(value);
        }

        @Override
        public void setSizeC(double value) {
            this.sizeC = (int)Math.ceil(value);
        }

        @Override
        public boolean isInfiniteX() {
            return this.getSizeX() == 2.147483647E9;
        }

        @Override
        public boolean isInfiniteY() {
            return this.getSizeY() == 2.147483647E9;
        }

        @Override
        public boolean isInfiniteZ() {
            return this.getSizeZ() == 2.147483647E9;
        }

        @Override
        public boolean isInfiniteT() {
            return this.getSizeT() == 2.147483647E9;
        }

        @Override
        public boolean isInfiniteC() {
            return this.getSizeC() == 2.147483647E9;
        }

        @Override
        public void setSize(double sizeX, double sizeY, double sizeZ, double sizeT, double sizeC) {
            this.sizeX = (int)Math.ceil(sizeX);
            this.sizeY = (int)Math.ceil(sizeY);
            this.sizeZ = (int)Math.ceil(sizeZ);
            this.sizeT = (int)Math.ceil(sizeT);
            this.sizeC = (int)Math.ceil(sizeC);
        }

        @Override
        public Dimension2D toDimension2D() {
            return new Dimension(this.sizeX, this.sizeY);
        }

        @Override
        public Dimension3D toDimension3D() {
            return new Dimension3D.Integer(this.sizeX, this.sizeY, this.sizeZ);
        }

        @Override
        public Dimension4D toDimension4D() {
            return new Dimension4D.Integer(this.sizeX, this.sizeY, this.sizeZ, this.sizeT);
        }

        @Override
        public Integer toInteger() {
            return (Integer)this.clone();
        }
    }
}

