/*
 * Decompiled with CFR 0.152.
 */
package icy.update;

import icy.file.FileUtil;
import icy.system.SystemUtil;
import icy.update.ElementDescriptor;
import icy.util.StringUtil;
import icy.util.XMLUtil;
import icy.util.ZipUtil;
import java.io.File;
import java.util.ArrayList;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class Updater {
    public static final String ICYKERNEL_NAME = "ICY Kernel";
    public static final String ICYUPDATER_NAME = "ICY Updater";
    public static final String UPDATE_DIRECTORY = String.valueOf(FileUtil.APPLICATION_DIRECTORY) + "/" + "update";
    public static final String BACKUP_DIRECTORY = String.valueOf(FileUtil.APPLICATION_DIRECTORY) + "/" + "backup";
    public static final String UPDATE_BASE_NAME = "update";
    public static final String UPDATE_EXT_NAME = ".xml";
    public static final String UPDATE_NAME = "update.xml";
    public static final String VERSION_NAME = "version.xml";
    public static final String UPDATER_NAME = "updater.jar";
    public static final String ARG_NOSTART = "-nostart";
    public static final String ARG_UPDATE = "-update";
    private static final String ID_ELEMENTS = "elements";
    private static final String ID_ELEMENT = "element";
    private static final String ID_OBSOLETES = "obsoletes";
    private static final String ID_LOCALPATH = "localpath";

    public static void validateElements(ArrayList<ElementDescriptor> elements) {
        int i = elements.size() - 1;
        while (i >= 0) {
            ElementDescriptor element = elements.get(i);
            element.validate();
            if (element.getFilesNumber() == 0) {
                elements.remove(i);
            }
            --i;
        }
    }

    public static ArrayList<ElementDescriptor> getLocalElements() {
        ArrayList<ElementDescriptor> result = Updater.loadElementsFromXML(String.valueOf(FileUtil.APPLICATION_DIRECTORY) + "/" + VERSION_NAME);
        Updater.validateElements(result);
        return result;
    }

    public static ArrayList<ElementDescriptor> getOnlineElements() {
        return Updater.loadElementsFromXML(String.valueOf(UPDATE_DIRECTORY) + "/" + UPDATE_NAME);
    }

    public static ArrayList<ElementDescriptor> getUpdateElements(ArrayList<ElementDescriptor> localElements) {
        ArrayList<ElementDescriptor> result = new ArrayList<ElementDescriptor>();
        ArrayList<ElementDescriptor> onlineElements = Updater.getOnlineElements();
        for (ElementDescriptor onlineElement : onlineElements) {
            ElementDescriptor localElement = Updater.findElement(onlineElement.getName(), localElements);
            ElementDescriptor updateElement = ElementDescriptor.getUpdateElement(localElement, onlineElement);
            if (updateElement == null) continue;
            result.add(updateElement);
        }
        return result;
    }

    public static ArrayList<String> getObsoletes() {
        Element obsoletes;
        ArrayList<Node> nodesLocalpath;
        ArrayList<String> result = new ArrayList<String>();
        Document document = XMLUtil.loadDocument(String.valueOf(UPDATE_DIRECTORY) + "/" + UPDATE_NAME, false);
        if (document != null && (nodesLocalpath = XMLUtil.getChildren(obsoletes = XMLUtil.getElement(document.getDocumentElement(), ID_OBSOLETES), ID_LOCALPATH)) != null) {
            for (Node n : nodesLocalpath) {
                String value = XMLUtil.getValue((Element)n, "");
                if (StringUtil.isEmpty(value, true)) continue;
                result.add(value);
            }
        }
        return result;
    }

    public static ArrayList<ElementDescriptor> loadElementsFromXML(String path) {
        Element elements;
        ArrayList<Node> nodesElement;
        ArrayList<ElementDescriptor> result = new ArrayList<ElementDescriptor>();
        Document document = XMLUtil.loadDocument(path, true);
        if (document != null && (nodesElement = XMLUtil.getChildren(elements = XMLUtil.getElement(document.getDocumentElement(), ID_ELEMENTS), ID_ELEMENT)) != null) {
            for (Node n : nodesElement) {
                result.add(new ElementDescriptor(n));
            }
        }
        return result;
    }

    public static boolean saveElementsToXML(ArrayList<ElementDescriptor> elements, String path, boolean onlineSave) {
        Document document = XMLUtil.createDocument(true);
        Element elementsNode = XMLUtil.addElement(document.getDocumentElement(), ID_ELEMENTS);
        for (ElementDescriptor element : elements) {
            element.saveToNode(XMLUtil.addElement(elementsNode, ID_ELEMENT), onlineSave);
        }
        return XMLUtil.saveDocument(document, path);
    }

    public static ElementDescriptor findElement(String name, ArrayList<ElementDescriptor> list) {
        for (ElementDescriptor element : list) {
            if (!name.equals(element.getName())) continue;
            return element;
        }
        return null;
    }

    public static boolean hasUpdateFiles() {
        String[] paths;
        String[] stringArray = paths = FileUtil.getFiles(UPDATE_DIRECTORY, null, true, false, false);
        int n = paths.length;
        int n2 = 0;
        while (n2 < n) {
            String path = stringArray[n2];
            String filename = FileUtil.getFileName(path);
            if (!filename.equals(UPDATER_NAME) && !filename.equals(UPDATE_NAME)) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    public static boolean udpateElement(ElementDescriptor updateElement, ArrayList<ElementDescriptor> localElements) throws InterruptedException {
        if (Updater.updateFiles(updateElement.getFiles())) {
            Updater.updateElementInfos(updateElement, localElements);
            return true;
        }
        return false;
    }

    public static void clearElementInfos(ElementDescriptor updateElement, ArrayList<ElementDescriptor> localElements) {
        ElementDescriptor localElement = Updater.findElement(updateElement.getName(), localElements);
        localElements.remove(localElement);
    }

    public static void updateElementInfos(ElementDescriptor updateElement, ArrayList<ElementDescriptor> localElements) {
        ElementDescriptor localElement = Updater.findElement(updateElement.getName(), localElements);
        if (localElement == null) {
            localElements.add(updateElement);
        } else {
            localElement.update(updateElement);
        }
    }

    public static boolean updateFiles(ArrayList<ElementDescriptor.ElementFile> files) throws InterruptedException {
        for (ElementDescriptor.ElementFile file : files) {
            if (Updater.updateFile(file)) continue;
            return false;
        }
        return true;
    }

    public static boolean updateFile(ElementDescriptor.ElementFile file) throws InterruptedException {
        File dest;
        String localPath = file.getLocalPath();
        if (file.isDirectory()) {
            String zipName;
            String dirName = String.valueOf(UPDATE_DIRECTORY) + "/" + localPath;
            if (!FileUtil.rename(dirName, zipName = String.valueOf(dirName) + ".zip", true)) {
                return false;
            }
            if (!ZipUtil.extract(zipName)) {
                return false;
            }
        }
        if (Updater.updateFile(localPath, file.getDateModif()) && (dest = new File(String.valueOf(FileUtil.APPLICATION_DIRECTORY) + "/" + localPath)).exists()) {
            if (file.isExecutable()) {
                dest.setExecutable(true, false);
            }
            if (file.isWritable() && !dest.setWritable(true, false)) {
                dest.setWritable(true, true);
            }
            if (file.isDirectory() && file.isExecutable()) {
                String dirName = String.valueOf(FileUtil.APPLICATION_DIRECTORY) + "/" + localPath;
                if (SystemUtil.isMac()) {
                    String libFile;
                    String[] stringArray = FileUtil.getFiles(dirName, "dylib", true, true);
                    int n = stringArray.length;
                    int n2 = 0;
                    while (n2 < n) {
                        libFile = stringArray[n2];
                        Updater.codeSign(libFile);
                        ++n2;
                    }
                    stringArray = FileUtil.getFiles(dirName, "jnilib", true, true);
                    n = stringArray.length;
                    n2 = 0;
                    while (n2 < n) {
                        libFile = stringArray[n2];
                        Updater.codeSign(libFile);
                        ++n2;
                    }
                }
            }
            return true;
        }
        return false;
    }

    public static boolean codeSign(String libFile) throws InterruptedException {
        return true;
    }

    public static boolean backup(String localPath) {
        String src = String.valueOf(FileUtil.APPLICATION_DIRECTORY) + "/" + localPath;
        if (FileUtil.exists(src)) {
            String dest = String.valueOf(BACKUP_DIRECTORY) + "/" + localPath;
            if (!FileUtil.copy(src, dest, true, true)) {
                return false;
            }
            return FileUtil.exists(dest);
        }
        return true;
    }

    public static boolean updateFile(String localPath, long dateModif) {
        if (!Updater.needUpdate(localPath, dateModif)) {
            return true;
        }
        if (!Updater.backup(localPath)) {
            System.err.println("Updater.udpateFile(" + localPath + ") failed :");
            return false;
        }
        if (!FileUtil.rename(String.valueOf(UPDATE_DIRECTORY) + "/" + localPath, String.valueOf(FileUtil.APPLICATION_DIRECTORY) + "/" + localPath, true)) {
            System.err.println("Updater.udpateFile('" + localPath + "') failed !");
            return false;
        }
        return true;
    }

    public static boolean needUpdate(String localPath, long dateModif) {
        File localFile = new File(String.valueOf(FileUtil.APPLICATION_DIRECTORY) + "/" + localPath);
        return !localFile.exists() || dateModif == 0L || localFile.lastModified() != dateModif;
    }

    public static boolean restore() {
        int len = BACKUP_DIRECTORY.length();
        String[] paths = FileUtil.getFiles(BACKUP_DIRECTORY, null, true, false, false);
        boolean result = true;
        String[] stringArray = paths;
        int n = paths.length;
        int n2 = 0;
        while (n2 < n) {
            String backupPath = stringArray[n2];
            String finalPath = backupPath.substring(len + 1);
            if (!finalPath.equals(UPDATER_NAME) && !FileUtil.rename(backupPath, finalPath, true)) {
                System.err.println("Updater.restore() cannot restore '" + finalPath + "', you should do it manually.");
                result = false;
            }
            ++n2;
        }
        return result;
    }

    public static void deleteObsoletes() {
        for (String obsolete : Updater.getObsoletes()) {
            FileUtil.delete(obsolete, true);
        }
    }
}

