/*
 * Decompiled with CFR 0.152.
 */
package plugins.kernel.roi.roi2d;

import icy.painter.Anchor2D;
import icy.painter.LineAnchor2D;
import icy.resource.ResourceUtil;
import icy.roi.ROI;
import icy.type.geom.Polyline2D;
import icy.type.point.Point2DUtil;
import icy.type.point.Point5D;
import icy.util.XMLUtil;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Polygon;
import java.awt.geom.Path2D;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.awt.image.DataBufferByte;
import java.util.ArrayList;
import java.util.List;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import plugins.kernel.roi.roi2d.ROI2DShape;

public class ROI2DPolyLine
extends ROI2DShape {
    public static final String ID_POINTS = "points";
    public static final String ID_POINT = "point";

    @Deprecated
    public ROI2DPolyLine(Point2D pt, boolean cm) {
        this(pt);
    }

    public ROI2DPolyLine(Point2D pt) {
        super(new Polyline2D());
        Anchor2D point = this.createAnchor(pt);
        point.setSelected(true);
        this.addPoint(point);
        this.setIcon(ResourceUtil.ICON_ROI_POLYLINE);
    }

    public ROI2DPolyLine(Point5D pt) {
        this(pt.toPoint2D());
    }

    public ROI2DPolyLine(Polygon polygon) {
        this(new Point2D.Double());
        this.setPolygon(polygon);
    }

    public ROI2DPolyLine(Polyline2D polyline) {
        this(new Point2D.Double());
        this.setPolyline2D(polyline);
    }

    public ROI2DPolyLine(List<Point2D> points) {
        this(new Point2D.Double());
        this.setPoints(points);
    }

    public ROI2DPolyLine() {
        this(new Point2D.Double());
    }

    @Override
    public String getDefaultName() {
        return "PolyLine2D";
    }

    @Override
    protected Anchor2D createAnchor(Point2D pos) {
        return new ROI2DPolyLineAnchor2D(pos, this.getColor(), this.getFocusedColor());
    }

    @Deprecated
    protected Path2D getPath() {
        return new Path2D.Double(this.shape);
    }

    public void setPoints(List<Point2D> pts) {
        this.beginUpdate();
        try {
            List<Anchor2D> ctrlPts = this.getControlPoints();
            if (pts.size() == ctrlPts.size()) {
                int i = 0;
                while (i < pts.size()) {
                    Point2D newPt = pts.get(i);
                    Anchor2D pt = ctrlPts.get(i);
                    pt.setPosition(newPt.getX(), newPt.getY());
                    ++i;
                }
            } else {
                this.removeAllPoint();
                for (Point2D pt : pts) {
                    this.addNewPoint(pt, false);
                }
            }
        }
        finally {
            this.endUpdate();
        }
    }

    @Deprecated
    public void setPoints(ArrayList<Point2D> pts) {
        this.setPoints((List<Point2D>)pts);
    }

    public Polyline2D getPolyline2D() {
        return (Polyline2D)this.shape;
    }

    public void setPolyline2D(Polyline2D polyline2D) {
        this.setPoints(polyline2D.getPoints());
    }

    public Polygon getPolygon() {
        return this.getPolyline2D().getPolygon2D().getPolygon();
    }

    public void setPolygon(Polygon polygon) {
        this.setPolyline2D(new Polyline2D(polygon));
    }

    @Override
    public boolean contains(double x, double y) {
        return false;
    }

    @Override
    public boolean contains(Point2D p) {
        return false;
    }

    @Override
    public boolean contains(double x, double y, double w, double h) {
        return false;
    }

    @Override
    public boolean contains(Rectangle2D r) {
        return false;
    }

    @Override
    public boolean contains(ROI roi) {
        return false;
    }

    @Override
    protected double getTotalDistance(List<Point2D> points, double factorX, double factorY) {
        return Point2DUtil.getTotalDistance(points, factorX, factorY, false);
    }

    @Override
    public double computeNumberOfPoints() {
        return 0.0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void updateShape() {
        Polyline2D polyline2d;
        double[] ptsY;
        double[] ptsX;
        int len;
        List list = this.controlPoints;
        synchronized (list) {
            len = this.controlPoints.size();
            ptsX = new double[len];
            ptsY = new double[len];
            int i = 0;
            while (i < len) {
                Anchor2D pt = (Anchor2D)this.controlPoints.get(i);
                ptsX[i] = pt.getX();
                ptsY[i] = pt.getY();
                ++i;
            }
        }
        Polyline2D polyline2D = polyline2d = this.getPolyline2D();
        synchronized (polyline2D) {
            polyline2d.npoints = len;
            polyline2d.xpoints = ptsX;
            polyline2d.ypoints = ptsY;
            polyline2d.calculatePath();
        }
        super.updateShape();
    }

    @Override
    public boolean[] getBooleanMask(int x, int y, int w, int h, boolean inclusive) {
        if (w <= 0 || h <= 0) {
            return new boolean[0];
        }
        if (!inclusive) {
            return new boolean[w * h];
        }
        BufferedImage maskImg = new BufferedImage(w, h, 10);
        Graphics2D g = maskImg.createGraphics();
        g.setColor(Color.white);
        g.translate(-x, -y);
        g.draw(this.shape);
        g.dispose();
        byte[] maskData = ((DataBufferByte)maskImg.getRaster().getDataBuffer()).getData();
        boolean[] result = new boolean[w * h];
        int i = 0;
        while (i < result.length) {
            result[i] = maskData[i] != 0;
            ++i;
        }
        return result;
    }

    @Override
    public boolean loadFromXML(Node node) {
        this.beginUpdate();
        try {
            if (!super.loadFromXML(node)) {
                return false;
            }
            this.removeAllPoint();
            ArrayList<Node> pointsNode = XMLUtil.getChildren(XMLUtil.getElement(node, ID_POINTS), ID_POINT);
            if (pointsNode != null) {
                for (Node n : pointsNode) {
                    Anchor2D pt = this.createAnchor(new Point2D.Double());
                    pt.loadPositionFromXML(n);
                    this.addPoint(pt);
                }
            }
        }
        finally {
            this.endUpdate();
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean saveToXML(Node node) {
        if (!super.saveToXML(node)) {
            return false;
        }
        Element pointsNode = XMLUtil.setElement(node, ID_POINTS);
        List list = this.controlPoints;
        synchronized (list) {
            for (Anchor2D pt : this.controlPoints) {
                pt.savePositionToXML(XMLUtil.addElement(pointsNode, ID_POINT));
            }
        }
        return true;
    }

    protected class ROI2DPolyLineAnchor2D
    extends LineAnchor2D {
        public ROI2DPolyLineAnchor2D(Point2D position, Color color, Color selectedColor) {
            super(position, color, selectedColor);
        }

        @Override
        protected Anchor2D getPreviousPoint() {
            int ind = ROI2DPolyLine.this.controlPoints.indexOf(this);
            if (ind == 0) {
                if (ROI2DPolyLine.this.controlPoints.size() > 1) {
                    return (Anchor2D)ROI2DPolyLine.this.controlPoints.get(1);
                }
                return null;
            }
            if (ind != -1) {
                return (Anchor2D)ROI2DPolyLine.this.controlPoints.get(ind - 1);
            }
            return null;
        }
    }
}

