/*
 * Decompiled with CFR 0.152.
 */
package plugins.kernel.roi.roi2d;

import icy.canvas.IcyCanvas;
import icy.canvas.IcyCanvas2D;
import icy.common.CollapsibleEvent;
import icy.painter.Anchor2D;
import icy.painter.OverlayEvent;
import icy.painter.OverlayListener;
import icy.painter.PainterEvent;
import icy.painter.PathAnchor2D;
import icy.roi.ROI;
import icy.roi.ROI2D;
import icy.roi.ROIEvent;
import icy.roi.edit.Point2DAddedROIEdit;
import icy.roi.edit.Point2DMovedROIEdit;
import icy.roi.edit.Point2DRemovedROIEdit;
import icy.sequence.Sequence;
import icy.system.thread.ThreadUtil;
import icy.type.point.Point2DUtil;
import icy.type.point.Point5D;
import icy.util.EventUtil;
import icy.util.GraphicsUtil;
import icy.util.ShapeUtil;
import icy.util.StringUtil;
import icy.vtk.IcyVtkPanel;
import icy.vtk.VtkUtil;
import java.awt.AlphaComposite;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.event.InputEvent;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.awt.geom.AffineTransform;
import java.awt.geom.PathIterator;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.awt.image.DataBufferByte;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.w3c.dom.Node;
import plugins.kernel.canvas.VtkCanvas;
import plugins.kernel.roi.roi2d.ROI2DPath;
import vtk.vtkActor;
import vtk.vtkCellArray;
import vtk.vtkInformation;
import vtk.vtkMapper;
import vtk.vtkPoints;
import vtk.vtkPolyData;
import vtk.vtkPolyDataMapper;
import vtk.vtkProp;
import vtk.vtkProperty;
import vtk.vtkRenderer;

public abstract class ROI2DShape
extends ROI2D
implements Shape {
    protected final Shape shape;
    protected final List<Anchor2D> controlPoints;
    protected final Anchor2D.Anchor2DPositionListener anchor2DPositionListener;
    protected final OverlayListener anchor2DOverlayListener;
    protected boolean firstMove;

    public ROI2DShape(Shape shape) {
        this.shape = shape;
        this.controlPoints = new ArrayList<Anchor2D>();
        this.firstMove = true;
        this.anchor2DPositionListener = new Anchor2D.Anchor2DPositionListener(){

            @Override
            public void positionChanged(Anchor2D source) {
                ROI2DShape.this.controlPointPositionChanged(source);
            }
        };
        this.anchor2DOverlayListener = new OverlayListener(){

            @Override
            public void overlayChanged(OverlayEvent event) {
                ROI2DShape.this.controlPointOverlayChanged(event);
            }
        };
    }

    @Override
    public String getDefaultName() {
        return "Shape2D";
    }

    @Override
    protected ROI2DShapePainter createPainter() {
        return new ROI2DShapePainter();
    }

    protected Anchor2D createAnchor(Point2D pos) {
        return new Anchor2D(pos.getX(), pos.getY(), this.getColor(), this.getFocusedColor());
    }

    protected Anchor2D createAnchor(double x, double y) {
        return this.createAnchor(new Point2D.Double(x, y));
    }

    public Shape getShape() {
        return this.shape;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void updateShape() {
        int z = this.getZ();
        this.beginUpdate();
        try {
            List<Anchor2D> list = this.controlPoints;
            synchronized (list) {
                for (Anchor2D points : this.controlPoints) {
                    points.setZ(z);
                }
            }
        }
        finally {
            this.endUpdate();
        }
        ((ROI2DShapePainter)this.painter).needRebuild = true;
    }

    public boolean canAddPoint() {
        return true;
    }

    public boolean canRemovePoint() {
        return true;
    }

    protected void addPoint(Anchor2D pt) {
        this.addPoint(pt, -1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addPoint(Anchor2D pt, int index) {
        pt.setZ(this.getZ());
        pt.setVisible(this.isSelected());
        pt.addPositionListener(this.anchor2DPositionListener);
        pt.addOverlayListener(this.anchor2DOverlayListener);
        Collection<Anchor2D> collection = this.controlPoints;
        synchronized (collection) {
            if (index == -1) {
                this.controlPoints.add(pt);
            } else {
                this.controlPoints.add(index, pt);
            }
        }
        collection = ((ROI2DShapePainter)this.getOverlay()).actorsToAdd;
        synchronized (collection) {
            ((ROI2DShapePainter)this.getOverlay()).actorsToAdd.add(pt);
        }
        collection = ((ROI2DShapePainter)this.getOverlay()).actorsToRemove;
        synchronized (collection) {
            ((ROI2DShapePainter)this.getOverlay()).actorsToRemove.remove(pt);
        }
        this.roiChanged(true);
    }

    @Deprecated
    public boolean addPoint(Point2D pos, boolean insert) {
        return this.addNewPoint(pos, insert) != null;
    }

    @Deprecated
    public boolean addPointAt(Point2D pos, boolean insert) {
        return this.addNewPoint(pos, insert) != null;
    }

    public Anchor2D addNewPoint(Point2D pos, boolean insert, boolean select) {
        if (!this.canAddPoint()) {
            return null;
        }
        Anchor2D pt = this.createAnchor(pos);
        if (insert) {
            this.addPoint(pt, this.getInsertPointPosition(pos));
        } else {
            this.addPoint(pt);
        }
        if (select) {
            pt.setSelected(true);
        }
        return pt;
    }

    public Anchor2D addNewPoint(Point2D pos, boolean insert) {
        return this.addNewPoint(pos, insert, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean removePoint(IcyCanvas canvas, Anchor2D pt) {
        boolean empty;
        pt.removeOverlayListener(this.anchor2DOverlayListener);
        pt.removePositionListener(this.anchor2DPositionListener);
        Collection<Anchor2D> collection = this.controlPoints;
        synchronized (collection) {
            this.controlPoints.remove(pt);
            empty = this.controlPoints.isEmpty();
        }
        collection = ((ROI2DShapePainter)this.getOverlay()).actorsToRemove;
        synchronized (collection) {
            ((ROI2DShapePainter)this.getOverlay()).actorsToRemove.add(pt);
        }
        collection = ((ROI2DShapePainter)this.getOverlay()).actorsToAdd;
        synchronized (collection) {
            ((ROI2DShapePainter)this.getOverlay()).actorsToAdd.remove(pt);
        }
        if (empty) {
            this.remove();
        } else {
            this.roiChanged(true);
        }
        return true;
    }

    public boolean removePoint(Anchor2D pt) {
        return this.removePoint(null, pt);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void removeAllPoint() {
        List<Anchor2D> list = this.controlPoints;
        synchronized (list) {
            Set<Anchor2D> set = ((ROI2DShapePainter)this.getOverlay()).actorsToRemove;
            synchronized (set) {
                ((ROI2DShapePainter)this.getOverlay()).actorsToRemove.addAll(this.controlPoints);
            }
            set = ((ROI2DShapePainter)this.getOverlay()).actorsToAdd;
            synchronized (set) {
                ((ROI2DShapePainter)this.getOverlay()).actorsToAdd.removeAll(this.controlPoints);
            }
            for (Anchor2D pt : this.controlPoints) {
                pt.removeOverlayListener(this.anchor2DOverlayListener);
                pt.removePositionListener(this.anchor2DPositionListener);
            }
            this.controlPoints.clear();
        }
    }

    @Deprecated
    public boolean removePointAt(IcyCanvas canvas, Point2D imagePoint) {
        if (!this.canRemovePoint()) {
            return false;
        }
        if (!this.removeSelectedPoint(canvas)) {
            if (this.selectPointAt(canvas, imagePoint)) {
                return this.removeSelectedPoint(canvas);
            }
            return false;
        }
        return true;
    }

    @Deprecated
    protected boolean removeSelectedPoint(IcyCanvas canvas, Point2D imagePoint) {
        return this.removeSelectedPoint(canvas);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean removeSelectedPoint(IcyCanvas canvas) {
        if (!this.canRemovePoint()) {
            return false;
        }
        Anchor2D selectedPoint = this.getSelectedPoint();
        if (selectedPoint == null) {
            return false;
        }
        List<Anchor2D> list = this.controlPoints;
        synchronized (list) {
            int index;
            block15: {
                index = this.controlPoints.indexOf(selectedPoint);
                if (this.removePoint(canvas, selectedPoint)) break block15;
                return false;
            }
            if (!this.controlPoints.isEmpty()) {
                Point2D imagePoint = selectedPoint.getPosition();
                if (selectedPoint instanceof PathAnchor2D) {
                    PathAnchor2D selectedPathPoint = (PathAnchor2D)selectedPoint;
                    switch (selectedPathPoint.getType()) {
                        case 0: {
                            if (index >= this.controlPoints.size()) break;
                            PathAnchor2D nextPoint = (PathAnchor2D)this.controlPoints.get(index);
                            if (nextPoint.getType() == 4) {
                                if (!this.removePoint(canvas, nextPoint) || this.controlPoints.size() != 0) break;
                                this.remove();
                                break;
                            }
                            nextPoint.setType(0);
                            break;
                        }
                        case 4: {
                            if (index <= 0) break;
                            PathAnchor2D prevPoint = (PathAnchor2D)this.controlPoints.get(index - 1);
                            if (prevPoint.getType() == 0) {
                                if (!this.removePoint(canvas, prevPoint) || this.controlPoints.size() != 0) break;
                                this.remove();
                                break;
                            }
                            prevPoint.setType(4);
                        }
                    }
                }
                if (this.controlPoints.size() > 0) {
                    this.selectPointAt(canvas, imagePoint);
                }
            }
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Anchor2D getSelectedPoint() {
        List<Anchor2D> list = this.controlPoints;
        synchronized (list) {
            for (Anchor2D pt : this.controlPoints) {
                if (!pt.isSelected()) continue;
                return pt;
            }
        }
        return null;
    }

    @Deprecated
    protected Anchor2D getSelectedControlPoint() {
        return this.getSelectedPoint();
    }

    @Override
    public boolean hasSelectedPoint() {
        return this.getSelectedPoint() != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected boolean selectPointAt(IcyCanvas canvas, Point2D imagePoint) {
        List<Anchor2D> list = this.controlPoints;
        synchronized (list) {
            Anchor2D pt;
            Iterator<Anchor2D> iterator = this.controlPoints.iterator();
            do {
                if (iterator.hasNext()) continue;
                return false;
            } while (!(pt = iterator.next()).isOver(canvas, imagePoint));
            pt.setSelected(true);
            return true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void unselectAllPoints() {
        this.beginUpdate();
        try {
            List<Anchor2D> list = this.controlPoints;
            synchronized (list) {
                for (Anchor2D pt : this.controlPoints) {
                    pt.setSelected(false);
                }
            }
        }
        finally {
            this.endUpdate();
        }
    }

    protected double getTotalDistance(List<Point2D> points, double factorX, double factorY) {
        return Point2DUtil.getTotalDistance(points, factorX, factorY, true);
    }

    @Override
    public double computeNumberOfContourPoints() {
        return this.getTotalDistance(this.getPointsInternal(), 1.0, 1.0);
    }

    @Override
    public double getLength(Sequence sequence) throws UnsupportedOperationException {
        return this.getTotalDistance(this.getPointsInternal(), sequence.getPixelSizeX(), sequence.getPixelSizeY());
    }

    protected int getInsertPointPosition(Point2D pos) {
        int size;
        ArrayList<Point2D> points = this.getPointsInternal();
        int result = size = points.size();
        double minDistance = Double.MAX_VALUE;
        int i = size;
        while (i >= 0) {
            points.add(i, pos);
            double d = this.getTotalDistance(points, 1.0, 1.0);
            if (d < minDistance) {
                minDistance = d;
                result = i;
            }
            points.remove(i);
            --i;
        }
        return result;
    }

    @Override
    public boolean isOverEdge(IcyCanvas canvas, double x, double y) {
        double strk = this.painter.getAdjustedStroke(canvas) * 3.0;
        Rectangle2D.Double rect = new Rectangle2D.Double(x - strk * 0.5, y - strk * 0.5, strk, strk);
        Rectangle2D roiBounds = this.getBounds2D();
        if (roiBounds.isEmpty()) {
            return rect.intersectsLine(roiBounds.getMinX(), roiBounds.getMinY(), roiBounds.getMaxX(), roiBounds.getMaxY());
        }
        if (roiBounds.intersects(rect)) {
            return ShapeUtil.pathIntersects(this.getPathIterator(null, 0.1), rect);
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<Anchor2D> getControlPoints() {
        List<Anchor2D> list = this.controlPoints;
        synchronized (list) {
            return new ArrayList<Anchor2D>(this.controlPoints);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ArrayList<Point2D> getPoints() {
        ArrayList<Point2D> result = new ArrayList<Point2D>();
        List<Anchor2D> list = this.controlPoints;
        synchronized (list) {
            for (Anchor2D pt : this.controlPoints) {
                result.add(pt.getPosition());
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected ArrayList<Point2D> getPointsInternal() {
        ArrayList<Point2D> result = new ArrayList<Point2D>();
        List<Anchor2D> list = this.controlPoints;
        synchronized (list) {
            for (Anchor2D pt : this.controlPoints) {
                result.add(pt.getPositionInternal());
            }
        }
        return result;
    }

    @Override
    public PathIterator getPathIterator(AffineTransform at) {
        return this.shape.getPathIterator(at);
    }

    @Override
    public PathIterator getPathIterator(AffineTransform at, double flatness) {
        return this.shape.getPathIterator(at, flatness);
    }

    @Override
    public boolean[] getBooleanMask(int x, int y, int width, int height, boolean inclusive) {
        if (width <= 0 || height <= 0) {
            return new boolean[0];
        }
        if (inclusive) {
            Rectangle bounds = this.getBounds();
            int wr = bounds.width;
            int hr = bounds.height;
            if (wr == 1 || hr == 1) {
                boolean[] result = new boolean[width * height];
                Rectangle r = new Rectangle(x, y, width, height);
                int xr = bounds.x;
                int yr = bounds.y;
                if (r.intersects(xr, yr, wr, hr)) {
                    int ind = 0;
                    int j = 0;
                    while (j < height) {
                        int i = 0;
                        while (i < width) {
                            result[ind++] = bounds.contains(x + i, y + j);
                            ++i;
                        }
                        ++j;
                    }
                }
                return result;
            }
        }
        BufferedImage img = new BufferedImage(width, height, 10);
        byte[] buffer = ((DataBufferByte)img.getRaster().getDataBuffer()).getData();
        Graphics2D g = img.createGraphics();
        g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_OFF);
        g.setRenderingHint(RenderingHints.KEY_STROKE_CONTROL, RenderingHints.VALUE_STROKE_PURE);
        g.translate(-((double)x - 0.5), -((double)y - 0.5));
        g.setColor(Color.white);
        g.fill(ShapeUtil.getClosedPath(this.shape));
        if (inclusive) {
            g.draw(this.shape);
        } else {
            g.setColor(Color.black);
            g.draw(this.shape);
        }
        g.dispose();
        boolean[] result = new boolean[width * height];
        int i = 0;
        while (i < result.length) {
            result[i] = buffer[i] != 0;
            ++i;
        }
        return result;
    }

    @Override
    public boolean contains(Point2D p) {
        return this.shape.contains(p);
    }

    @Override
    public boolean contains(Rectangle2D r) {
        return this.shape.contains(r);
    }

    @Override
    public boolean contains(double x, double y) {
        return this.shape.contains(x, y);
    }

    @Override
    public boolean contains(double x, double y, double w, double h) {
        return this.shape.contains(x, y, w, h);
    }

    @Override
    public boolean intersects(Rectangle2D r) {
        return this.shape.intersects(r);
    }

    @Override
    public boolean intersects(double x, double y, double w, double h) {
        return this.shape.intersects(x, y, w, h);
    }

    @Override
    public Rectangle2D computeBounds2D() {
        Rectangle2D result = this.shape.getBounds2D();
        if (result.isEmpty()) {
            result.setFrame(result.getX(), result.getY(), Math.max(result.getWidth(), 0.001), Math.max(result.getHeight(), 0.001));
        }
        return result;
    }

    @Override
    public ROI getUnion(ROI roi) throws UnsupportedOperationException, InterruptedException {
        if (roi instanceof ROI2DShape) {
            ROI2DShape roiShape = (ROI2DShape)roi;
            if (this.getZ() == roiShape.getZ() && this.getT() == roiShape.getT() && this.getC() == roiShape.getC()) {
                ROI2DPath result = new ROI2DPath(ShapeUtil.union(this, roiShape));
                result.setZ(this.getZ());
                result.setT(this.getT());
                result.setC(this.getC());
                return result;
            }
        }
        return super.getUnion(roi);
    }

    @Override
    public ROI getIntersection(ROI roi) throws UnsupportedOperationException, InterruptedException {
        if (roi instanceof ROI2DShape) {
            ROI2DShape roiShape = (ROI2DShape)roi;
            if (this.getZ() == roiShape.getZ() && this.getT() == roiShape.getT() && this.getC() == roiShape.getC()) {
                ROI2DPath result = new ROI2DPath(ShapeUtil.intersect(this, roiShape));
                result.setZ(this.getZ());
                result.setT(this.getT());
                result.setC(this.getC());
                return result;
            }
        }
        return super.getIntersection(roi);
    }

    @Override
    public ROI getExclusiveUnion(ROI roi) throws UnsupportedOperationException, InterruptedException {
        if (roi instanceof ROI2DShape) {
            ROI2DShape roiShape = (ROI2DShape)roi;
            if (this.getZ() == roiShape.getZ() && this.getT() == roiShape.getT() && this.getC() == roiShape.getC()) {
                ROI2DPath result = new ROI2DPath(ShapeUtil.exclusiveUnion(this, roiShape));
                result.setZ(this.getZ());
                result.setT(this.getT());
                result.setC(this.getC());
                return result;
            }
        }
        return super.getExclusiveUnion(roi);
    }

    @Override
    public ROI getSubtraction(ROI roi) throws UnsupportedOperationException, InterruptedException {
        if (roi instanceof ROI2DShape) {
            ROI2DShape roiShape = (ROI2DShape)roi;
            if (this.getZ() == roiShape.getZ() && this.getT() == roiShape.getT() && this.getC() == roiShape.getC()) {
                ROI2DPath result = new ROI2DPath(ShapeUtil.subtract(this, roiShape));
                result.setZ(this.getZ());
                result.setT(this.getT());
                result.setC(this.getC());
                return result;
            }
        }
        return super.getSubtraction(roi);
    }

    @Override
    public boolean canTranslate() {
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void translate(double dx, double dy) {
        this.beginUpdate();
        try {
            List<Anchor2D> list = this.controlPoints;
            synchronized (list) {
                for (Anchor2D pt : this.controlPoints) {
                    pt.translate(dx, dy);
                }
            }
        }
        finally {
            this.endUpdate();
        }
    }

    public void controlPointPositionChanged(Anchor2D source) {
        this.roiChanged(true);
    }

    public void controlPointOverlayChanged(OverlayEvent event) {
        if (event.getType() == OverlayEvent.OverlayEventType.PAINTER_CHANGED) {
            if (this.hasSelectedPoint()) {
                this.setFocused(false);
            }
            this.getOverlay().painterChanged();
        }
    }

    public void painterChanged(PainterEvent event) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onChanged(CollapsibleEvent object) {
        ROIEvent event = (ROIEvent)object;
        switch (event.getType()) {
            case ROI_CHANGED: {
                this.updateShape();
                break;
            }
            case FOCUS_CHANGED: {
                ((ROI2DShapePainter)this.getOverlay()).updateVtkDisplayProperties();
                break;
            }
            case SELECTION_CHANGED: {
                boolean s = this.isSelected();
                this.beginUpdate();
                try {
                    List<Anchor2D> list = this.controlPoints;
                    synchronized (list) {
                        for (Anchor2D pt : this.controlPoints) {
                            pt.setVisible(s);
                        }
                    }
                    if (!s) {
                        this.unselectAllPoints();
                    }
                }
                finally {
                    this.endUpdate();
                }
                ((ROI2DShapePainter)this.getOverlay()).updateVtkDisplayProperties();
                break;
            }
            case PROPERTY_CHANGED: {
                String property = event.getPropertyName();
                if (!StringUtil.equals(property, "stroke") && !StringUtil.equals(property, "color") && !StringUtil.equals(property, "opacity")) break;
                ((ROI2DShapePainter)this.getOverlay()).updateVtkDisplayProperties();
                break;
            }
        }
        super.onChanged(object);
    }

    @Override
    public boolean loadFromXML(Node node) {
        this.beginUpdate();
        try {
            if (!super.loadFromXML(node)) {
                return false;
            }
            this.firstMove = false;
            this.unselectAllPoints();
        }
        finally {
            this.endUpdate();
        }
        return true;
    }

    public class ROI2DShapePainter
    extends ROI2D.ROI2DPainter
    implements Runnable {
        protected vtkPolyData outline = null;
        protected vtkPolyDataMapper outlineMapper = null;
        protected vtkActor outlineActor = null;
        protected vtkInformation vtkInfo = null;
        protected vtkCellArray vCells = null;
        protected vtkPoints vPoints = null;
        protected vtkPolyData polyData = null;
        protected vtkPolyDataMapper polyMapper = null;
        protected vtkActor actor = null;
        protected boolean needRebuild;
        protected double[] scaling = new double[3];
        protected WeakReference<VtkCanvas> canvas3d;
        protected Set<Anchor2D> actorsToAdd;
        protected Set<Anchor2D> actorsToRemove;

        public ROI2DShapePainter() {
            Arrays.fill(this.scaling, 1.0);
            this.actorsToAdd = new HashSet<Anchor2D>();
            this.actorsToRemove = new HashSet<Anchor2D>();
            this.needRebuild = true;
            this.canvas3d = new WeakReference<Object>(null);
        }

        protected void finalize() throws Throwable {
            super.finalize();
            if (this.actor != null) {
                this.actor.Delete();
            }
            if (this.polyMapper != null) {
                this.polyMapper.Delete();
            }
            if (this.polyData != null) {
                this.polyData.Delete();
            }
            if (this.vPoints != null) {
                this.vPoints.Delete();
            }
            if (this.vCells != null) {
                this.vCells.Delete();
            }
            if (this.outlineActor != null) {
                this.outlineActor.SetPropertyKeys(null);
                this.outlineActor.Delete();
            }
            if (this.vtkInfo != null) {
                this.vtkInfo.Remove(VtkCanvas.visibilityKey);
                this.vtkInfo.Delete();
            }
            if (this.outlineMapper != null) {
                this.outlineMapper.Delete();
            }
            if (this.outline != null) {
                this.outline.GetPointData().GetScalars().Delete();
                this.outline.GetPointData().Delete();
                this.outline.Delete();
            }
        }

        protected void initVtkObjects() {
            this.outline = VtkUtil.getOutline(0.0, 1.0, 0.0, 1.0, 0.0, 1.0);
            this.outlineMapper = new vtkPolyDataMapper();
            this.outlineMapper.SetInputData(this.outline);
            this.outlineActor = new vtkActor();
            this.outlineActor.SetMapper((vtkMapper)this.outlineMapper);
            this.outlineActor.SetPickable(0);
            this.outlineActor.GetProperty().SetRepresentationToWireframe();
            this.vtkInfo = new vtkInformation();
            this.vtkInfo.Set(VtkCanvas.visibilityKey, 0);
            this.outlineActor.SetPropertyKeys(this.vtkInfo);
            this.polyData = new vtkPolyData();
            this.polyMapper = new vtkPolyDataMapper();
            this.polyMapper.SetInputData(this.polyData);
            this.actor = new vtkActor();
            this.actor.SetMapper((vtkMapper)this.polyMapper);
            Color col = this.getColor();
            double r = (double)col.getRed() / 255.0;
            double g = (double)col.getGreen() / 255.0;
            double b = (double)col.getBlue() / 255.0;
            this.outlineActor.GetProperty().SetColor(r, g, b);
            vtkProperty property = this.actor.GetProperty();
            property.SetPointSize(this.getStroke());
            property.SetColor(r, g, b);
        }

        protected void rebuildVtkObjects() {
            int ind;
            VtkCanvas canvas = (VtkCanvas)this.canvas3d.get();
            if (canvas == null) {
                return;
            }
            IcyVtkPanel vtkPanel2 = canvas.getVtkPanel();
            if (vtkPanel2 == null) {
                return;
            }
            Sequence seq = canvas.getSequence();
            if (seq == null) {
                return;
            }
            double xs = this.scaling[0];
            double ys = this.scaling[1];
            double zs = this.scaling[2];
            ArrayList<double[]> point3DList = new ArrayList<double[]>();
            ArrayList<int[]> polyList = new ArrayList<int[]>();
            double[] coords = new double[6];
            double z0 = this.getMinZ(seq) * zs;
            double z1 = this.getMaxZ(seq) * zs;
            double xm = 0.0;
            double ym = 0.0;
            double x0 = 0.0;
            double y0 = 0.0;
            double x1 = 0.0;
            double y1 = 0.0;
            PathIterator path = ROI2DShape.this.getPathIterator(null, 0.5);
            Rectangle2D bounds = ROI2DShape.this.getBounds2D();
            while (!path.isDone()) {
                switch (path.currentSegment(coords)) {
                    case 0: {
                        x0 = xm = coords[0] * xs;
                        y0 = ym = coords[1] * ys;
                        break;
                    }
                    case 1: {
                        x1 = coords[0] * xs;
                        y1 = coords[1] * ys;
                        ind = point3DList.size();
                        point3DList.add(new double[]{x0, y0, z0});
                        point3DList.add(new double[]{x1, y1, z0});
                        point3DList.add(new double[]{x0, y0, z1});
                        point3DList.add(new double[]{x1, y1, z1});
                        polyList.add(new int[]{1 + ind, 2 + ind, 0 + ind});
                        polyList.add(new int[]{3 + ind, 2 + ind, 1 + ind});
                        x0 = x1;
                        y0 = y1;
                        break;
                    }
                    case 4: {
                        x1 = xm;
                        y1 = ym;
                        ind = point3DList.size();
                        point3DList.add(new double[]{x0, y0, z0});
                        point3DList.add(new double[]{x1, y1, z0});
                        point3DList.add(new double[]{x0, y0, z1});
                        point3DList.add(new double[]{x1, y1, z1});
                        polyList.add(new int[]{1 + ind, 2 + ind, 0 + ind});
                        polyList.add(new int[]{3 + ind, 2 + ind, 1 + ind});
                        x0 = x1;
                        y0 = y1;
                    }
                }
                path.next();
            }
            double[][] vertices = new double[point3DList.size()][3];
            int[][] indexes = new int[polyList.size()][3];
            ind = 0;
            for (double[] pt3D : point3DList) {
                vertices[ind++] = pt3D;
            }
            ind = 0;
            for (int[] poly : polyList) {
                indexes[ind++] = poly;
            }
            vtkPoints previousPoints = this.vPoints;
            vtkCellArray previousCells = this.vCells;
            vtkPoints newPoints = VtkUtil.getPoints(vertices);
            vtkCellArray newCells = VtkUtil.getCells(polyList.size(), VtkUtil.prepareCells(indexes));
            vtkPanel2.lock();
            try {
                this.vPoints = newPoints;
                this.vCells = newCells;
                VtkUtil.setOutlineBounds(this.outline, bounds.getMinX() * xs, bounds.getMaxX() * xs, bounds.getMinY() * ys, bounds.getMaxY() * ys, z0, z1, canvas);
                this.outlineMapper.Update();
                this.polyData.SetPoints(this.vPoints);
                this.polyData.SetPolys(this.vCells);
                this.polyMapper.Update();
                if (previousCells != null) {
                    previousCells.Delete();
                }
                if (previousPoints != null) {
                    previousPoints.Delete();
                }
            }
            finally {
                vtkPanel2.unlock();
            }
            this.updateVtkDisplayProperties();
        }

        protected void updateVtkDisplayProperties() {
            IcyVtkPanel vtkPanel2;
            if (this.actor == null) {
                return;
            }
            VtkCanvas cnv = (VtkCanvas)this.canvas3d.get();
            vtkProperty vtkProperty2 = this.actor.GetProperty();
            Color col = this.getDisplayColor();
            double r = (double)col.getRed() / 255.0;
            double g = (double)col.getGreen() / 255.0;
            double b = (double)col.getBlue() / 255.0;
            double strk = this.getStroke();
            IcyVtkPanel icyVtkPanel = vtkPanel2 = cnv != null ? cnv.getVtkPanel() : null;
            if (vtkPanel2 != null) {
                vtkPanel2.lock();
            }
            try {
                this.outlineActor.GetProperty().SetColor(r, g, b);
                if (ROI2DShape.this.isSelected()) {
                    this.outlineActor.GetProperty().SetRepresentationToWireframe();
                    this.outlineActor.SetVisibility(1);
                    this.vtkInfo.Set(VtkCanvas.visibilityKey, 1);
                } else {
                    this.outlineActor.GetProperty().SetRepresentationToPoints();
                    this.outlineActor.SetVisibility(0);
                    this.vtkInfo.Set(VtkCanvas.visibilityKey, 0);
                }
                vtkProperty2.SetColor(r, g, b);
                vtkProperty2.SetPointSize(strk);
                this.setVtkObjectsColor(col);
            }
            finally {
                if (vtkPanel2 != null) {
                    vtkPanel2.unlock();
                }
            }
            this.painterChanged();
        }

        protected void setVtkObjectsColor(Color color) {
            if (this.outline != null) {
                VtkUtil.setPolyDataColor(this.outline, color, (VtkCanvas)this.canvas3d.get());
            }
            if (this.polyData != null) {
                VtkUtil.setPolyDataColor(this.polyData, color, (VtkCanvas)this.canvas3d.get());
            }
        }

        protected double getMinZ(Sequence seq) {
            double curZ = ROI2DShape.this.getZ();
            if (curZ == -1.0) {
                return 0.0;
            }
            return curZ;
        }

        protected double getMaxZ(Sequence seq) {
            double curZ = ROI2DShape.this.getZ();
            if (curZ == -1.0) {
                return seq.getSizeZ();
            }
            return curZ + 1.0;
        }

        @Override
        protected boolean updateFocus(InputEvent e, Point5D imagePoint, IcyCanvas canvas) {
            if (canvas instanceof VtkCanvas) {
                boolean focused = this.actor != null && this.actor == ((VtkCanvas)canvas).getPickedObject();
                ROI2DShape.this.setFocused(focused);
                return focused;
            }
            return super.updateFocus(e, imagePoint, canvas);
        }

        /*
         * Unable to fully structure code
         */
        @Override
        public void keyPressed(KeyEvent e, Point5D.Double imagePoint, IcyCanvas canvas) {
            block9: {
                if (ROI2DShape.this.isSelected() && !this.isReadOnly() && ROI2DShape.this.isActiveFor(canvas)) {
                    ROI2DShape.this.beginUpdate();
                    try {
                        controlPoints = ROI2DShape.this.getControlPoints();
                        for (Anchor2D pt : controlPoints) {
                            pt.keyPressed(e, imagePoint, canvas);
                        }
                        if (e.isConsumed()) break block9;
                        sequence = canvas.getSequence();
                        switch (e.getKeyCode()) {
                            case 8: 
                            case 127: {
                                selectedPoint = ROI2DShape.this.getSelectedPoint();
                                if (!ROI2DShape.this.removeSelectedPoint(canvas)) break;
                                e.consume();
                                if (sequence == null) break;
                                sequence.addUndoableEdit(new Point2DRemovedROIEdit(ROI2DShape.this, controlPoints, selectedPoint));
                            }
                            default: {
                                ** break;
                            }
lbl-1000:
                            // 1 sources

                            {
                                break;
                            }
                        }
                    }
                    finally {
                        ROI2DShape.this.endUpdate();
                    }
                }
            }
            super.keyPressed(e, imagePoint, canvas);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void keyReleased(KeyEvent e, Point5D.Double imagePoint, IcyCanvas canvas) {
            if (ROI2DShape.this.isSelected() && !this.isReadOnly() && ROI2DShape.this.isActiveFor(canvas)) {
                ROI2DShape.this.beginUpdate();
                try {
                    List<Anchor2D> list = ROI2DShape.this.controlPoints;
                    synchronized (list) {
                        for (Anchor2D pt : ROI2DShape.this.controlPoints) {
                            pt.keyReleased(e, imagePoint, canvas);
                        }
                    }
                }
                finally {
                    ROI2DShape.this.endUpdate();
                }
            }
            super.keyReleased(e, imagePoint, canvas);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void mousePressed(MouseEvent e, Point5D.Double imagePoint, IcyCanvas canvas) {
            if (ROI2DShape.this.isActiveFor(canvas) && ROI2DShape.this.isSelected() && !this.isReadOnly()) {
                ROI2DShape.this.beginUpdate();
                try {
                    List<Anchor2D> list = ROI2DShape.this.controlPoints;
                    synchronized (list) {
                        for (Anchor2D pt : ROI2DShape.this.controlPoints) {
                            pt.mousePressed(e, imagePoint, canvas);
                        }
                    }
                    if (!e.isConsumed()) {
                        Anchor2D point;
                        boolean insertMode;
                        if (canvas instanceof VtkCanvas) {
                            return;
                        }
                        if (imagePoint == null) {
                            return;
                        }
                        if (EventUtil.isLeftMouseButton(e) && !ROI2DShape.this.isFocused() && ((insertMode = EventUtil.isControlDown(e)) || ROI2DShape.this.isCreating()) && (point = ROI2DShape.this.addNewPoint(imagePoint.toPoint2D(), insertMode)) != null) {
                            e.consume();
                            Sequence sequence = canvas.getSequence();
                            if (sequence != null) {
                                sequence.addUndoableEdit(new Point2DAddedROIEdit(ROI2DShape.this, point));
                            }
                        }
                    }
                }
                finally {
                    ROI2DShape.this.endUpdate();
                }
            }
            super.mousePressed(e, imagePoint, canvas);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void mouseReleased(MouseEvent e, Point5D.Double imagePoint, IcyCanvas canvas) {
            ROI2DShape.this.firstMove = false;
            if (ROI2DShape.this.isSelected() && !this.isReadOnly() && ROI2DShape.this.isActiveFor(canvas)) {
                Sequence sequence = canvas.getSequence();
                ROI2DShape.this.beginUpdate();
                try {
                    List<Anchor2D> list = ROI2DShape.this.controlPoints;
                    synchronized (list) {
                        for (Anchor2D pt : ROI2DShape.this.controlPoints) {
                            pt.mouseReleased(e, imagePoint, canvas);
                        }
                    }
                }
                finally {
                    ROI2DShape.this.endUpdate();
                }
                if (sequence != null) {
                    sequence.getUndoManager().noMergeForNextEdit();
                }
            }
            super.mouseReleased(e, imagePoint, canvas);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void mouseClick(MouseEvent e, Point5D.Double imagePoint, IcyCanvas canvas) {
            if (ROI2DShape.this.isSelected() && !this.isReadOnly() && ROI2DShape.this.isActiveFor(canvas)) {
                ROI2DShape.this.beginUpdate();
                try {
                    List<Anchor2D> list = ROI2DShape.this.controlPoints;
                    synchronized (list) {
                        for (Anchor2D pt : ROI2DShape.this.controlPoints) {
                            pt.mouseClick(e, imagePoint, canvas);
                        }
                    }
                }
                finally {
                    ROI2DShape.this.endUpdate();
                }
            }
            super.mouseClick(e, imagePoint, canvas);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void mouseDrag(MouseEvent e, Point5D.Double imagePoint, IcyCanvas canvas) {
            if (ROI2DShape.this.isActiveFor(canvas) && ROI2DShape.this.isSelected() && !this.isReadOnly()) {
                Sequence sequence = canvas.getSequence();
                ROI2DShape.this.beginUpdate();
                try {
                    List<Anchor2D> list = ROI2DShape.this.controlPoints;
                    synchronized (list) {
                        for (Anchor2D pt : ROI2DShape.this.controlPoints) {
                            Point2D savedPosition = sequence != null && (!ROI2DShape.this.isCreating() || !ROI2DShape.this.firstMove) ? pt.getPosition() : null;
                            pt.mouseDrag(e, imagePoint, canvas);
                            if (sequence == null || savedPosition == null || savedPosition.equals(pt.getPosition())) continue;
                            sequence.addUndoableEdit(new Point2DMovedROIEdit(ROI2DShape.this, pt, savedPosition));
                        }
                    }
                }
                finally {
                    ROI2DShape.this.endUpdate();
                }
            }
            super.mouseDrag(e, imagePoint, canvas);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void mouseMove(MouseEvent e, Point5D.Double imagePoint, IcyCanvas canvas) {
            if (ROI2DShape.this.isActiveFor(canvas) && ROI2DShape.this.isSelected() && !this.isReadOnly()) {
                ROI2DShape.this.beginUpdate();
                try {
                    List<Anchor2D> list = ROI2DShape.this.controlPoints;
                    synchronized (list) {
                        for (Anchor2D pt : ROI2DShape.this.controlPoints) {
                            pt.mouseMove(e, imagePoint, canvas);
                        }
                    }
                }
                finally {
                    ROI2DShape.this.endUpdate();
                }
            }
            super.mouseMove(e, imagePoint, canvas);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void drawROI(Graphics2D g, Sequence sequence, IcyCanvas canvas) {
            if (canvas instanceof IcyCanvas2D) {
                if (g == null) {
                    return;
                }
                Rectangle2D bounds = ROI2DShape.this.shape.getBounds2D();
                double over = this.getAdjustedStroke(canvas) * 2.0;
                ShapeUtil.enlarge(bounds, over, over, true);
                boolean shapeVisible = this.isVisible(bounds, g, canvas);
                if (shapeVisible) {
                    boolean small = this.isSmall(bounds, g, canvas);
                    boolean tiny = this.isTiny(bounds, g, canvas);
                    this.drawShape(g, sequence, canvas, small);
                    if (!tiny && ROI2DShape.this.isSelected() && !this.isReadOnly()) {
                        List<Anchor2D> list = ROI2DShape.this.controlPoints;
                        synchronized (list) {
                            for (Anchor2D pt : ROI2DShape.this.controlPoints) {
                                pt.paint(g, sequence, canvas, small);
                            }
                        }
                    }
                }
            }
            if (canvas instanceof VtkCanvas) {
                vtkProp prop;
                vtkProp[] vtkPropArray;
                double[] s;
                VtkCanvas cnv = (VtkCanvas)canvas;
                if (this.canvas3d.get() != cnv) {
                    this.canvas3d = new WeakReference<VtkCanvas>(cnv);
                }
                if (this.actor == null) {
                    this.initVtkObjects();
                }
                if (!Arrays.equals(this.scaling, s = cnv.getVolumeScale())) {
                    this.scaling = s;
                    this.needRebuild = true;
                }
                if (this.needRebuild) {
                    ThreadUtil.runSingle(this);
                    this.needRebuild = false;
                }
                vtkRenderer renderer = cnv.getRenderer();
                Collection<Anchor2D> collection = this.actorsToRemove;
                synchronized (collection) {
                    for (Anchor2D anchor : this.actorsToRemove) {
                        vtkPropArray = anchor.getProps();
                        int n = vtkPropArray.length;
                        int n2 = 0;
                        while (n2 < n) {
                            prop = vtkPropArray[n2];
                            VtkUtil.removeProp(renderer, prop);
                            ++n2;
                        }
                    }
                    this.actorsToRemove.clear();
                }
                collection = this.actorsToAdd;
                synchronized (collection) {
                    for (Anchor2D anchor : this.actorsToAdd) {
                        vtkPropArray = anchor.getProps();
                        int n = vtkPropArray.length;
                        int n3 = 0;
                        while (n3 < n) {
                            prop = vtkPropArray[n3];
                            VtkUtil.addProp(renderer, prop);
                            ++n3;
                        }
                    }
                    this.actorsToAdd.clear();
                }
                collection = ROI2DShape.this.controlPoints;
                synchronized (collection) {
                    for (Anchor2D pt : ROI2DShape.this.controlPoints) {
                        pt.paint(null, sequence, canvas);
                    }
                }
            }
        }

        protected void drawShape(Graphics2D g, Sequence sequence, IcyCanvas canvas, boolean simplified) {
            this.drawShape(g, sequence, canvas, ROI2DShape.this.shape, simplified);
        }

        protected void drawShape(Graphics2D g, Sequence sequence, IcyCanvas canvas, Shape shape, boolean simplified) {
            Graphics2D g2 = (Graphics2D)g.create();
            if (simplified) {
                g2.setColor(this.getDisplayColor());
                if (ROI2DShape.this.isSelected()) {
                    g2.fill(shape);
                }
                g2.setStroke(new BasicStroke((float)ROI.getAdjustedStroke(canvas, this.stroke)));
                g2.draw(shape);
            } else if (ROI2DShape.this.isSelected()) {
                AlphaComposite prevAlpha = (AlphaComposite)g2.getComposite();
                float newAlpha = prevAlpha.getAlpha() * this.getOpacity();
                newAlpha = Math.min(1.0f, newAlpha);
                newAlpha = Math.max(0.0f, newAlpha);
                g2.setComposite(prevAlpha.derive(newAlpha));
                g2.setColor(this.getDisplayColor());
                g2.fill(ShapeUtil.getClosedPath(shape));
                g2.setComposite(prevAlpha);
                g2.setStroke(new BasicStroke((float)ROI.getAdjustedStroke(canvas, this.stroke + 1.0)));
                g2.draw(shape);
            } else {
                g2.setStroke(new BasicStroke((float)ROI.getAdjustedStroke(canvas, this.stroke + 1.0)));
                g2.setColor(Color.black);
                g2.draw(shape);
                g2.setStroke(new BasicStroke((float)ROI.getAdjustedStroke(canvas, this.stroke)));
                g2.setColor(this.getDisplayColor());
                g2.draw(shape);
            }
            g2.dispose();
        }

        protected boolean isVisible(Rectangle2D bounds, Graphics2D g, IcyCanvas canvas) {
            return GraphicsUtil.isVisible((Graphics)g, bounds);
        }

        protected boolean isSmall(Rectangle2D bounds, Graphics2D g, IcyCanvas canvas) {
            if (ROI2DShape.this.isCreating()) {
                return false;
            }
            double scale = Math.max(Math.abs(canvas.getScaleX()), Math.abs(canvas.getScaleY()));
            double size = Math.max(scale * bounds.getWidth(), scale * bounds.getHeight());
            return size < 10.0;
        }

        protected boolean isTiny(Rectangle2D bounds, Graphics2D g, IcyCanvas canvas) {
            if (ROI2DShape.this.isCreating()) {
                return false;
            }
            double scale = Math.max(Math.abs(canvas.getScaleX()), Math.abs(canvas.getScaleY()));
            double size = Math.max(scale * bounds.getWidth(), scale * bounds.getHeight());
            return size < 4.0;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void setColor(Color value) {
            this.beginUpdate();
            try {
                super.setColor(value);
                Color focusedColor = this.getFocusedColor();
                List<Anchor2D> list = ROI2DShape.this.controlPoints;
                synchronized (list) {
                    for (Anchor2D anchor : ROI2DShape.this.controlPoints) {
                        anchor.setColor(value);
                        anchor.setSelectedColor(focusedColor);
                    }
                }
            }
            finally {
                this.endUpdate();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public vtkProp[] getProps() {
            if (this.actor == null) {
                this.initVtkObjects();
            }
            ArrayList<Object> result = new ArrayList<Object>();
            result.add(this.actor);
            result.add(this.outlineActor);
            List<Anchor2D> list = ROI2DShape.this.controlPoints;
            synchronized (list) {
                for (Anchor2D pt : ROI2DShape.this.controlPoints) {
                    vtkProp[] vtkPropArray = pt.getProps();
                    int n = vtkPropArray.length;
                    int n2 = 0;
                    while (n2 < n) {
                        vtkProp prop = vtkPropArray[n2];
                        result.add(prop);
                        ++n2;
                    }
                }
            }
            return result.toArray(new vtkProp[result.size()]);
        }

        @Override
        public void run() {
            this.rebuildVtkObjects();
        }
    }
}

