/*
 * Decompiled with CFR 0.152.
 */
package mitiv.cost;

import mitiv.cost.PseudoL1Norm;
import mitiv.exception.IncorrectSpaceException;
import mitiv.linalg.Vector;
import mitiv.linalg.shaped.DoubleShapedVector;
import mitiv.linalg.shaped.DoubleShapedVectorSpace;

public class PseudoL1NormOfDoubleVector
extends PseudoL1Norm {
    public PseudoL1NormOfDoubleVector(DoubleShapedVectorSpace space) {
        super(space);
    }

    @Override
    public void applyProx(Vector out, double alpha, Vector inp, double tol) {
        if (alpha == 0.0) {
            out.copy(inp);
        } else if (alpha > 0.0) {
            if (!inp.belongsTo(this.inputSpace) || !out.belongsTo(this.inputSpace)) {
                throw new IncorrectSpaceException();
            }
            double[] x = ((DoubleShapedVector)inp).getData();
            double[] y = ((DoubleShapedVector)inp).getData();
            double tmin = -alpha;
            double tmax = alpha;
            for (double t : x) {
                y[j] = t <= tmin ? t - tmin : (t >= tmax ? t - tmax : 0.0);
            }
        }
    }
}

