/*
 * Decompiled with CFR 0.152.
 */
package mitiv.linalg.shaped;

import mitiv.exception.IllegalTypeException;
import mitiv.exception.NotImplementedException;
import mitiv.linalg.LinearOperator;
import mitiv.linalg.Vector;
import mitiv.linalg.shaped.DoubleShapedVector;
import mitiv.linalg.shaped.FloatShapedVector;
import mitiv.linalg.shaped.FloatShapedVectorSpace;
import mitiv.linalg.shaped.ShapedVector;
import mitiv.linalg.shaped.ShapedVectorSpace;

public class DenseOperator
extends LinearOperator {
    private final Object data;
    private final boolean single;

    public DenseOperator(ShapedVector vec, int n) {
        super(DenseOperator.splitSpace(vec, n, true), DenseOperator.splitSpace(vec, n, false));
        if (vec.getType() == 4) {
            this.single = true;
            this.data = ((FloatShapedVector)vec).getData();
        } else {
            this.single = false;
            this.data = ((DoubleShapedVector)vec).getData();
        }
    }

    @Override
    protected void _apply(Vector dst, Vector src, int job) throws NotImplementedException {
        block14: {
            double[] x;
            double[] a;
            int ncols;
            int nrows;
            block15: {
                block13: {
                    if (job != DIRECT && job != ADJOINT) {
                        throw new NotImplementedException("Only direct and adjoint operators are implemented");
                    }
                    nrows = this.getOutputSpace().getNumber();
                    ncols = this.getInputSpace().getNumber();
                    if (!this.single) break block13;
                    float[] a2 = (float[])this.data;
                    float[] x2 = ((FloatShapedVector)src).getData();
                    float[] y = ((FloatShapedVector)dst).getData();
                    if (job == DIRECT) {
                        for (int i = 0; i < nrows; ++i) {
                            y[i] = 0.0f;
                        }
                        for (int j = 0; j < ncols; ++j) {
                            float xj = x2[j];
                            int off = nrows * j;
                            for (int i = 0; i < nrows; ++i) {
                                int n = i;
                                y[n] = y[n] + a2[i + off] * xj;
                            }
                        }
                    } else {
                        for (int j = 0; j < ncols; ++j) {
                            float sum = 0.0f;
                            int off = nrows * j;
                            for (int i = 0; i < nrows; ++i) {
                                sum += a2[i + off] * x2[i];
                            }
                            y[j] = sum;
                        }
                    }
                    break block14;
                }
                a = (double[])this.data;
                x = ((DoubleShapedVector)src).getData();
                double[] y = ((DoubleShapedVector)dst).getData();
                if (job != DIRECT) break block15;
                for (int i = 0; i < nrows; ++i) {
                    y[i] = 0.0;
                }
                for (int j = 0; j < ncols; ++j) {
                    double xj = x[j];
                    int off = nrows * j;
                    for (int i = 0; i < nrows; ++i) {
                        int n = i;
                        y[n] = y[n] + a[i + off] * xj;
                    }
                }
                break block14;
            }
            if (job != ADJOINT) break block14;
            for (int j = 0; j < ncols; ++j) {
                double sum = 0.0;
                int off = nrows * j;
                for (int i = 0; i < nrows; ++i) {
                    sum += a[i + off] * x[i];
                }
                y[j] = sum;
            }
        }
    }

    private static ShapedVectorSpace splitSpace(ShapedVector vec, int n, boolean input) {
        int[] dims;
        int type = vec.getType();
        int rank = vec.getRank();
        if (n < 1 || n >= rank) {
            throw new IndexOutOfBoundsException("Output rank is out of bounds");
        }
        if (input) {
            dims = new int[rank - n];
            for (int k = 0; k < rank - n; ++k) {
                dims[k] = vec.getDimension(n + k);
            }
        } else {
            dims = new int[n];
            for (int k = 0; k < n; ++k) {
                dims[k] = vec.getDimension(k);
            }
        }
        if (type == 4) {
            return new FloatShapedVectorSpace(dims);
        }
        if (type == 4) {
            return new FloatShapedVectorSpace(dims);
        }
        throw new IllegalTypeException("Only generic floating-point types are supported");
    }
}

