/*
 * Decompiled with CFR 0.152.
 */
package net.phys2d.math;

import java.io.Serializable;
import net.phys2d.math.ROVector2f;

public strictfp class Vector2f
implements ROVector2f,
Serializable {
    public float x;
    public float y;

    public Vector2f() {
    }

    @Override
    public float getX() {
        return this.x;
    }

    @Override
    public float getY() {
        return this.y;
    }

    public Vector2f(ROVector2f other) {
        this(other.getX(), other.getY());
    }

    public Vector2f(float x, float y) {
        this.x = x;
        this.y = y;
    }

    public void set(ROVector2f other) {
        this.set(other.getX(), other.getY());
    }

    @Override
    public float dot(ROVector2f other) {
        return this.x * other.getX() + this.y * other.getY();
    }

    public void set(float x, float y) {
        this.x = x;
        this.y = y;
    }

    public Vector2f negate() {
        return new Vector2f(-this.x, -this.y);
    }

    public void add(ROVector2f v) {
        this.x += v.getX();
        this.y += v.getY();
    }

    public void sub(ROVector2f v) {
        this.x -= v.getX();
        this.y -= v.getY();
    }

    public void scale(float a) {
        this.x *= a;
        this.y *= a;
    }

    public void normalise() {
        float l = this.length();
        if (l == 0.0f) {
            return;
        }
        this.x /= l;
        this.y /= l;
    }

    @Override
    public float lengthSquared() {
        return this.x * this.x + this.y * this.y;
    }

    @Override
    public float length() {
        return (float)Math.sqrt(this.lengthSquared());
    }

    @Override
    public void projectOntoUnit(ROVector2f b, Vector2f result) {
        float dp = b.dot(this);
        result.x = dp * b.getX();
        result.y = dp * b.getY();
    }

    public String toString() {
        return "[Vec " + this.x + "," + this.y + " (" + this.length() + ")]";
    }

    @Override
    public float distance(ROVector2f other) {
        return (float)Math.sqrt(this.distanceSquared(other));
    }

    @Override
    public float distanceSquared(ROVector2f other) {
        float dx = other.getX() - this.getX();
        float dy = other.getY() - this.getY();
        return dx * dx + dy * dy;
    }

    public boolean equalsDelta(ROVector2f other, float delta) {
        return other.getX() - delta < this.x && other.getX() + delta > this.x && other.getY() - delta < this.y && other.getY() + delta > this.y;
    }
}

