/*
 * Decompiled with CFR 0.152.
 */
package net.phys2d.raw.shapes;

import java.util.ArrayList;
import net.phys2d.math.ROVector2f;
import net.phys2d.math.Vector2f;
import net.phys2d.raw.shapes.AABox;
import net.phys2d.raw.shapes.AbstractShape;
import net.phys2d.raw.shapes.DynamicShape;
import net.phys2d.raw.shapes.Line;

public class Polygon
extends AbstractShape
implements DynamicShape {
    protected Vector2f[] vertices;
    protected float area;
    protected float trueArea;
    protected Vector2f centroid;

    public Polygon(ROVector2f[] vertices) {
        if (vertices.length < 3) {
            throw new IllegalArgumentException("A polygon can not have fewer than 3 edges!");
        }
        this.vertices = new Vector2f[vertices.length];
        for (int i = 0; i < vertices.length; ++i) {
            this.vertices[i] = new Vector2f(vertices[i]);
        }
        float r = this.computeBoundingCircleRadius();
        this.bounds = new AABox(r * 2.0f, r * 2.0f);
        this.area = this.computeArea();
        this.centroid = this.computeCentroid();
    }

    protected Polygon() {
    }

    protected float computeArea() {
        this.area = 0.0f;
        for (int i = 0; i < this.vertices.length; ++i) {
            Vector2f v1 = this.vertices[i];
            Vector2f v2 = this.vertices[(i + 1) % this.vertices.length];
            this.area += v1.x * v2.y;
            this.area -= v2.x * v1.y;
        }
        this.trueArea = this.area;
        return Math.abs(this.area);
    }

    public float getTrueArea() {
        return this.trueArea;
    }

    protected Vector2f computeCentroid() {
        float x = 0.0f;
        float y = 0.0f;
        for (int i = 0; i < this.vertices.length; ++i) {
            Vector2f v1 = this.vertices[i];
            Vector2f v2 = this.vertices[(i + 1) % this.vertices.length];
            x += (v1.x + v2.x) * (v1.x * v2.y - v2.x * v1.y);
            y += (v1.y + v2.y) * (v1.x * v2.y - v2.x * v1.y);
        }
        return new Vector2f(x / (6.0f * this.getArea()), y / (6.0f * this.getArea()));
    }

    protected float computeBoundingCircleRadius() {
        float r = 0.0f;
        for (int i = 0; i < this.vertices.length; ++i) {
            float l = this.vertices[i].x * this.vertices[i].x + this.vertices[i].y * this.vertices[i].y;
            r = l > r ? l : r;
        }
        return (float)Math.sqrt(r);
    }

    public float getArea() {
        return Math.abs(this.area);
    }

    public Vector2f getCentroid() {
        return this.centroid;
    }

    public ROVector2f[] getVertices() {
        ROVector2f[] roVertices = new ROVector2f[this.vertices.length];
        for (int i = 0; i < this.vertices.length; ++i) {
            roVertices[i] = this.vertices[i];
        }
        return roVertices;
    }

    public boolean isConvex() {
        int l = this.vertices.length;
        for (int i = 0; i < this.vertices.length; ++i) {
            Vector2f x = this.vertices[i];
            Vector2f y = this.vertices[(i + 1) % l];
            Vector2f z = this.vertices[(i + 2) % l];
            if (!((z.x - x.x) * (y.y - x.y) - (y.x - x.x) * (z.y - x.y) >= 0.0f)) continue;
            return false;
        }
        return true;
    }

    public Vector2f[] getVertices(ROVector2f displacement, float rotation) {
        Vector2f[] retVertices = new Vector2f[this.vertices.length];
        float cos = (float)Math.cos(rotation);
        float sin = (float)Math.sin(rotation);
        for (int i = 0; i < this.vertices.length; ++i) {
            float x = this.vertices[i].x * cos - this.vertices[i].y * sin;
            float y = this.vertices[i].y * cos + this.vertices[i].x * sin;
            retVertices[i] = new Vector2f(x += displacement.getX(), y += displacement.getY());
        }
        return retVertices;
    }

    public Vector2f getCentroid(ROVector2f displacement, float rotation) {
        float cos = (float)Math.cos(rotation);
        float sin = (float)Math.sin(rotation);
        return new Vector2f(this.centroid.x * cos - this.centroid.y * sin + displacement.getX(), this.centroid.y * cos + this.centroid.x * sin + displacement.getY());
    }

    public ROVector2f getNearestPoint(ROVector2f p) {
        return null;
    }

    @Override
    public float getSurfaceFactor() {
        return this.getArea();
    }

    @Override
    public boolean contains(Vector2f p, ROVector2f displacement, float rotation) {
        Vector2f[] correctedVertices = this.getVertices(displacement, rotation);
        ArrayList<Line> edges = new ArrayList<Line>();
        float xMin = correctedVertices[0].x;
        float yMin = correctedVertices[0].y;
        float xMax = correctedVertices[0].x;
        float yMax = correctedVertices[0].y;
        int l = correctedVertices.length;
        for (int i = 0; i < correctedVertices.length; ++i) {
            Vector2f vec1 = correctedVertices[i];
            Vector2f vec2 = correctedVertices[(i + 1) % l];
            xMin = Math.min(xMin, vec1.x);
            xMax = Math.max(xMax, vec1.x);
            yMin = Math.min(yMin, vec1.y);
            yMax = Math.max(yMax, vec1.y);
            Line line = new Line(vec1, vec2);
            edges.add(line);
        }
        if (p.x < xMin || p.x > xMax || p.y < yMin || p.y > yMax) {
            return false;
        }
        boolean oddNumberOfLines = false;
        float epsilon = (xMax - xMin) / 100.0f;
        Line ray = new Line(new Vector2f(xMin - epsilon, p.y), p);
        for (Line edge : edges) {
            Vector2f intersection;
            if (edge.getStart().getY() > p.y && edge.getEnd().getY() > p.y || edge.getStart().getY() < p.y && edge.getEnd().getY() < p.y || (intersection = ray.intersect(edge)) == null || !(intersection.x >= ray.getStart().getX()) || !(intersection.x <= ray.getEnd().getX())) continue;
            oddNumberOfLines = !oddNumberOfLines;
        }
        return oddNumberOfLines;
    }
}

