/*
 * Decompiled with CFR 0.152.
 */
package plugins.fab.MiceProfiler;

import icy.canvas.Canvas2D;
import icy.gui.viewer.Viewer;
import icy.sequence.Sequence;
import icy.system.thread.ThreadUtil;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.text.DateFormat;
import java.util.ArrayList;
import java.util.GregorianCalendar;
import javax.media.Buffer;
import javax.media.CannotRealizeException;
import javax.media.Manager;
import javax.media.MediaLocator;
import javax.media.NoPlayerException;
import javax.media.Player;
import javax.media.Time;
import javax.media.control.FrameGrabbingControl;
import javax.media.control.FramePositioningControl;
import javax.media.format.VideoFormat;
import javax.media.util.BufferToImage;

class AviOldFile {
    final FramePositioningControl fpc;
    final FrameGrabbingControl fg;
    final Player p;
    final VideoFormat vf;
    final BufferToImage bufferToImage;

    public AviOldFile(String path) throws NoPlayerException, CannotRealizeException, IOException, InterruptedException {
        MediaLocator mediaLocator = new MediaLocator("file:" + path);
        this.p = Manager.createRealizedPlayer((MediaLocator)mediaLocator);
        System.out.println("Player : " + this.p);
        System.out.println("Duration : " + this.p.getDuration().getSeconds());
        this.fpc = (FramePositioningControl)this.p.getControl("javax.media.control.FramePositioningControl");
        if (this.fpc == null) {
            System.out.println("ERROR : Can't use a frame positioning control on this file.");
        }
        this.fg = (FrameGrabbingControl)this.p.getControl("javax.media.control.FrameGrabbingControl");
        if (this.fg == null) {
            System.out.println("ERROR : Can't use a frame grabbing control on this file.");
        }
        this.p.prefetch();
        Thread.sleep(3000L);
        this.fpc.seek(0);
        Buffer buf = this.fg.grabFrame();
        this.vf = (VideoFormat)buf.getFormat();
        this.bufferToImage = new BufferToImage(this.vf);
    }

    public int getCurrentFrame() {
        return this.fpc.mapTimeToFrame(this.p.getMediaTime());
    }

    public int getTotalNumberOfFrame() {
        int result = (int)(this.p.getDuration().getSeconds() * (double)this.vf.getFrameRate());
        return result;
    }

    public BufferedImage getImageAt(Time time) {
        return this.getImageAt(this.fpc.mapTimeToFrame(time));
    }

    public void seek(int frame) {
        this.fpc.seek(frame);
    }

    public BufferedImage getImageAt(int frameNumber) {
        this.seek(frameNumber);
        return this.getImage();
    }

    public BufferedImage getImage() {
        Buffer buf = this.fg.grabFrame();
        Image image = this.bufferToImage.createImage(buf);
        BufferedImage result = new BufferedImage(image.getWidth(null), image.getHeight(null), 1);
        Graphics2D g = result.createGraphics();
        g.drawImage(image, 0, 0, null);
        g.dispose();
        return result;
    }

    public ArrayList<BufferedImage> getImages(Sequence sequence, int index, int num, boolean firstFrameLoadedToCenter) {
        ArrayList<BufferedImage> result = new ArrayList<BufferedImage>();
        int frameEnd = index + num;
        if (num == 0) {
            return result;
        }
        this.safeSeek(index);
        this.p.start();
        int frame = this.getCurrentFrame();
        while (frame < frameEnd) {
            sequence.setImage(frame, 0, this.getImage());
            if (firstFrameLoadedToCenter && frame == 0) {
                for (Viewer viewer : sequence.getViewers()) {
                    if (!(viewer.getCanvas() instanceof Canvas2D)) continue;
                    ((Canvas2D)viewer.getCanvas()).centerImage();
                }
            }
            while (frame == this.getCurrentFrame()) {
                ThreadUtil.sleep((int)5);
            }
            int newFrame = this.getCurrentFrame();
            this.safeSeek(frame + 1);
            frame = this.getCurrentFrame();
        }
        this.p.stop();
        return result;
    }

    public void safeSeek(int targetFrame) {
        int newFrame = this.getCurrentFrame();
        while (newFrame != targetFrame) {
            this.seek(targetFrame);
            newFrame = this.getCurrentFrame();
            if (newFrame == targetFrame) continue;
            System.out.println("Expected: " + targetFrame + " Current: " + newFrame + " Dif: " + (newFrame - targetFrame));
        }
    }

    public ArrayList<BufferedImage> getImages(int index, int num) {
        ArrayList<BufferedImage> result = new ArrayList<BufferedImage>();
        int frameEnd = index + num;
        this.seek(index);
        this.p.start();
        int frame = this.getCurrentFrame();
        while (frame < frameEnd) {
            result.add(this.getImage());
            while (frame == this.getCurrentFrame()) {
            }
            int newFrame = this.getCurrentFrame();
            if (newFrame != frame + 1) {
                this.seek(frame + 1);
            }
            frame = this.getCurrentFrame();
        }
        this.p.stop();
        return result;
    }

    public String getTimeForFrame(int frameNumber) {
        GregorianCalendar cal = new GregorianCalendar();
        cal.set(11, 0);
        cal.set(12, 0);
        cal.set(13, (int)((float)frameNumber / this.vf.getFrameRate()));
        cal.set(14, 0);
        String returnValue = "" + DateFormat.getTimeInstance().format(cal.getTime());
        return returnValue;
    }
}

