/*
 * Decompiled with CFR 0.152.
 */
package plugins.fab.MiceProfiler;

import icy.canvas.IcyCanvas;
import icy.painter.Anchor2D;
import icy.painter.Overlay;
import icy.painter.PainterEvent;
import icy.sequence.Sequence;
import icy.type.point.Point5D;
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.event.MouseEvent;
import java.awt.geom.Line2D;

public class MouseGuidePainter
extends Overlay
implements Anchor2D.Anchor2DListener {
    private Font font;
    Anchor2D M1h;
    Anchor2D M1b;
    Anchor2D M2h;
    Anchor2D M2b;
    private boolean visible;
    boolean trackOneMiceOnly;

    public MouseGuidePainter(Sequence sequence, boolean trackOneMiceOnly) {
        super("Mouse Guide", Overlay.OverlayPriority.SHAPE_NORMAL);
        sequence.addOverlay((Overlay)this);
        this.trackOneMiceOnly = trackOneMiceOnly;
        this.font = new Font("Arial", 0, 5);
        this.M1h = new Anchor2D(100.0, 100.0);
        this.M1b = new Anchor2D(100.0, 200.0);
        this.M1h.addAnchorListener((Anchor2D.Anchor2DListener)this);
        this.M1b.addAnchorListener((Anchor2D.Anchor2DListener)this);
        this.M2h = new Anchor2D(200.0, 100.0);
        this.M2b = new Anchor2D(200.0, 200.0);
        this.M2h.addAnchorListener((Anchor2D.Anchor2DListener)this);
        this.M2b.addAnchorListener((Anchor2D.Anchor2DListener)this);
        if (trackOneMiceOnly) {
            this.M2h.setVisible(false);
            this.M2b.setVisible(false);
            this.M2h.removeAnchorListener((Anchor2D.Anchor2DListener)this);
            this.M2b.removeAnchorListener((Anchor2D.Anchor2DListener)this);
        }
        this.visible = true;
    }

    public boolean isVisible() {
        return this.visible;
    }

    public void setVisible(boolean visible) {
        this.visible = visible;
    }

    public void mousePressed(MouseEvent e, Point5D.Double imagePoint, IcyCanvas canvas) {
        if (this.M1h.isSelected() || this.M1b.isSelected() || this.M2h.isSelected() || this.M2b.isSelected()) {
            e.consume();
        }
    }

    public void mouseDrag(MouseEvent e, Point5D.Double imagePoint, IcyCanvas canvas) {
        if (!this.visible) {
            return;
        }
        this.M1h.mouseDrag(e, imagePoint, canvas);
        this.M1b.mouseDrag(e, imagePoint, canvas);
        if (!this.trackOneMiceOnly) {
            this.M2h.mouseDrag(e, imagePoint, canvas);
            this.M2b.mouseDrag(e, imagePoint, canvas);
        }
    }

    public void mouseMove(MouseEvent e, Point5D.Double imagePoint, IcyCanvas canvas) {
        if (!this.visible) {
            return;
        }
        this.M1h.mouseMove(e, imagePoint, canvas);
        this.M1b.mouseMove(e, imagePoint, canvas);
        if (!this.trackOneMiceOnly) {
            this.M2h.mouseMove(e, imagePoint, canvas);
            this.M2b.mouseMove(e, imagePoint, canvas);
        }
    }

    public void paint(Graphics2D g, Sequence sequence, IcyCanvas canvas) {
        int fontSize;
        if (!this.visible) {
            return;
        }
        g.setColor(Color.RED);
        Line2D.Double line = new Line2D.Double(this.M1h.getX(), this.M1h.getY(), this.M1b.getX(), this.M1b.getY());
        g.draw(line);
        if (!this.trackOneMiceOnly) {
            g.setColor(Color.GREEN);
            line = new Line2D.Double(this.M2h.getX(), this.M2h.getY(), this.M2b.getX(), this.M2b.getY());
            g.draw(line);
        }
        if ((fontSize = (int)canvas.canvasToImageDeltaX(18)) < 1) {
            fontSize = 1;
        }
        Font font = new Font("Arial", 1, fontSize);
        g.setFont(font);
        g.setFont(font);
        g.setColor(Color.RED);
        g.drawString("h", (float)this.M1h.getX(), (float)this.M1h.getY());
        g.drawString("", (float)this.M1b.getX(), (float)this.M1b.getY());
        if (!this.trackOneMiceOnly) {
            g.setColor(Color.GREEN);
            g.drawString("h", (float)this.M2h.getX(), (float)this.M2h.getY());
            g.drawString("", (float)this.M2b.getX(), (float)this.M2b.getY());
        }
        this.M1h.paint(g, sequence, canvas);
        this.M1b.paint(g, sequence, canvas);
        if (!this.trackOneMiceOnly) {
            this.M2h.paint(g, sequence, canvas);
            this.M2b.paint(g, sequence, canvas);
        }
    }

    public void positionChanged(Anchor2D source) {
        this.painterChanged();
    }

    public void painterChanged(PainterEvent event) {
    }
}

