/*
 * Decompiled with CFR 0.152.
 */
package plugins.nchenouard.kymographtracker;

import icy.canvas.IcyCanvas;
import icy.image.IcyBufferedImage;
import icy.main.Icy;
import icy.painter.Overlay;
import icy.roi.ROI;
import icy.roi.ROI2D;
import icy.sequence.Sequence;
import icy.swimmingPool.SwimmingObject;
import icy.type.DataType;
import icy.type.collection.array.ArrayUtil;
import java.awt.BasicStroke;
import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics2D;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.geom.Line2D;
import java.awt.image.BufferedImage;
import java.text.NumberFormat;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Arrays;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JEditorPane;
import javax.swing.JFormattedTextField;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.border.TitledBorder;
import javax.swing.tree.DefaultMutableTreeNode;
import plugins.kernel.roi.roi2d.ROI2DShape;
import plugins.nchenouard.isotropicwavelets.IsotropicWaveletType;
import plugins.nchenouard.kymographtracker.ActionPanel;
import plugins.nchenouard.kymographtracker.KymographExtractionResult;
import plugins.nchenouard.kymographtracker.ROItoKymograph;
import plugins.nchenouard.kymographtracker.Util;
import plugins.nchenouard.kymographtracker.spline.CubicSmoothingSpline;
import plugins.nchenouard.pathtracing.InteractiveMultipleDjikstraTracingESC;
import plugins.nchenouard.pathtracing.PathEvent;
import plugins.nchenouard.rieszwavelets.HarmonicTypes;
import plugins.nchenouard.rieszwavelets.RieszConfig;
import plugins.nchenouard.rieszwavelets.RieszGeneralization;
import plugins.nchenouard.rieszwavelets.RieszWaveletCoefficients;
import plugins.nchenouard.rieszwavelets.RieszWaveletConfig;
import plugins.nchenouard.rieszwavelets.StandardRieszFrames;

class KymographExtractorPanel
extends ActionPanel
implements InteractiveMultipleDjikstraTracingESC.PathListener {
    private static final long serialVersionUID = 3741312080376160439L;
    JLabel tracingChoiceLabel;
    JRadioButton useOriginalSequenceButton;
    JRadioButton useOriginalSequenceROIButton;
    JRadioButton traceInMaxProjectionButton;
    JRadioButton traceInFilteredProjectionButton;
    ButtonGroup buttonGroup = new ButtonGroup();
    JPanel descriptionPanel;
    JPanel originalTracingPanel;
    JEditorPane originalTracingDescription;
    JPanel maxTracingPanel;
    JEditorPane maxTracingDescription;
    JPanel roiTracingPanel;
    JEditorPane roiTrackingDescription;
    JCheckBox separateAnteroRetroBox;
    JButton extractKymographsButton;
    JButton startTrackingButton;
    NumberFormat diskFormat = NumberFormat.getNumberInstance();
    JFormattedTextField diskRadiusField = new JFormattedTextField(this.diskFormat);
    Sequence selectedSequence = null;
    Sequence maxProjectionSequence = null;
    Sequence filteredProjectionSequence;
    double alpha = 0.01;
    boolean isEnabled = true;

    public KymographExtractorPanel(boolean isEnabled) {
        this.description = "Kymograph Extraction";
        this.node = new DefaultMutableTreeNode(this.description);
        this.setBorder(new TitledBorder(this.description));
        this.setLayout(new BorderLayout());
        JPanel northPanel = new JPanel(new GridBagLayout());
        this.add((Component)northPanel, "North");
        GridBagConstraints c = new GridBagConstraints();
        c.gridheight = 1;
        c.gridwidth = 1;
        c.gridx = 0;
        c.gridy = 0;
        c.fill = 2;
        c.weightx = 1.0;
        c.weighty = 0.0;
        c.insets = new Insets(2, 2, 2, 2);
        this.tracingChoiceLabel = new JLabel("Kymograph extraction path:");
        northPanel.add((Component)this.tracingChoiceLabel, c);
        ++c.gridy;
        this.useOriginalSequenceROIButton = new JRadioButton("use ROIs in the original sequence,", true);
        this.useOriginalSequenceROIButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                if (KymographExtractorPanel.this.useOriginalSequenceROIButton.isSelected()) {
                    KymographExtractorPanel.this.selectedButtonChanged(KymographExtractorPanel.this.useOriginalSequenceROIButton);
                }
            }
        });
        northPanel.add((Component)this.useOriginalSequenceROIButton, c);
        ++c.gridy;
        northPanel.add((Component)new JLabel("or trace a path:"), c);
        ++c.gridy;
        this.useOriginalSequenceButton = new JRadioButton("in the original sequence,", false);
        this.useOriginalSequenceButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                if (KymographExtractorPanel.this.useOriginalSequenceButton.isSelected()) {
                    KymographExtractorPanel.this.selectedButtonChanged(KymographExtractorPanel.this.useOriginalSequenceButton);
                }
            }
        });
        northPanel.add((Component)this.useOriginalSequenceButton, c);
        ++c.gridy;
        this.traceInFilteredProjectionButton = new JRadioButton("in an enhanced projection of the sequence.", false);
        this.traceInFilteredProjectionButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                if (KymographExtractorPanel.this.traceInFilteredProjectionButton.isSelected()) {
                    KymographExtractorPanel.this.selectedButtonChanged(KymographExtractorPanel.this.traceInFilteredProjectionButton);
                }
            }
        });
        northPanel.add((Component)this.traceInFilteredProjectionButton, c);
        ++c.gridy;
        this.buttonGroup.add(this.useOriginalSequenceButton);
        this.buttonGroup.add(this.traceInMaxProjectionButton);
        this.buttonGroup.add(this.traceInFilteredProjectionButton);
        this.buttonGroup.add(this.useOriginalSequenceROIButton);
        this.useOriginalSequenceROIButton.setSelected(true);
        this.roiTracingPanel = new JPanel(new BorderLayout());
        this.roiTrackingDescription = new JEditorPane();
        this.roiTrackingDescription.setContentType("text/html");
        this.roiTrackingDescription.setEditable(false);
        this.roiTrackingDescription.setText("Use the <strong>ROIs in the current sequence</strong> as the paths along which to extract the kymographs.");
        this.roiTrackingDescription.setBorder(BorderFactory.createLineBorder(Color.GRAY));
        this.roiTrackingDescription.setEditable(false);
        this.roiTracingPanel.add((Component)this.roiTrackingDescription, "Center");
        this.originalTracingPanel = new JPanel(new BorderLayout());
        this.originalTracingDescription = new JEditorPane();
        this.originalTracingDescription.setContentType("text/html");
        this.originalTracingDescription.setEditable(false);
        this.originalTracingDescription.setText("<strong>Trace extraction paths</strong> in the sequence to analyze. Multiple paths can be traced.");
        this.originalTracingDescription.setBorder(BorderFactory.createLineBorder(Color.GRAY));
        this.originalTracingDescription.setEditable(false);
        this.originalTracingPanel.add((Component)this.originalTracingDescription, "Center");
        this.maxTracingPanel = new JPanel(new BorderLayout());
        this.maxTracingDescription = new JEditorPane();
        this.maxTracingDescription.setEditable(false);
        this.maxTracingDescription.setContentType("text/html");
        this.maxTracingDescription.setEditable(false);
        this.maxTracingDescription.setBorder(BorderFactory.createLineBorder(Color.GRAY));
        this.maxTracingDescription.setText("<strong>Trace extraction paths</strong> in an enhanced projection of the sequence. Multiple paths can be traced.");
        this.maxTracingPanel.add((Component)this.maxTracingDescription, "Center");
        this.descriptionPanel = new JPanel();
        northPanel.add((Component)this.descriptionPanel, c);
        ++c.gridy;
        this.descriptionPanel.setLayout(new CardLayout());
        this.descriptionPanel.add((Component)this.originalTracingPanel, this.useOriginalSequenceButton.getText());
        this.descriptionPanel.add((Component)this.maxTracingPanel, this.traceInFilteredProjectionButton.getText());
        this.descriptionPanel.add((Component)this.roiTracingPanel, this.useOriginalSequenceROIButton.getText());
        this.separateAnteroRetroBox = new JCheckBox("Split anterograde and retrograde");
        this.separateAnteroRetroBox.setToolTipText("Separate anterograde and retrograde moving particles in distinct kymographs");
        northPanel.add((Component)this.separateAnteroRetroBox, c);
        ++c.gridy;
        northPanel.add((Component)new JLabel("Radius of the averaging area:"), c);
        ++c.gridy;
        this.diskRadiusField.setValue(2);
        northPanel.add((Component)this.diskRadiusField, c);
        ++c.gridy;
        JPanel southPanel = new JPanel(new GridLayout(2, 1));
        this.extractKymographsButton = new JButton("Extract kymographs");
        southPanel.add(this.extractKymographsButton);
        ++c.gridy;
        this.extractKymographsButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                KymographExtractorPanel.this.extractKymographs();
            }
        });
        this.startTrackingButton = new JButton("Trace tracks in kymographs");
        southPanel.add((Component)this.startTrackingButton, "Center");
        this.add((Component)southPanel, "South");
        this.selectedButtonChanged(this.useOriginalSequenceROIButton);
        this.enableGUI(isEnabled);
    }

    private void selectedButtonChanged(JRadioButton selectedButton) {
        ((CardLayout)this.descriptionPanel.getLayout()).show(this.descriptionPanel, selectedButton.getText());
        this.stopTracers();
        this.startTracers();
    }

    public void enableGUI(boolean enable) {
        if (enable != this.isEnabled) {
            this.isEnabled = enable;
            if (!enable) {
                this.stopTracers();
            } else {
                this.startTracers();
            }
        }
    }

    private void stopTracers() {
        if (this.selectedSequence != null) {
            for (Overlay painter : this.selectedSequence.getOverlays(InteractiveMultipleDjikstraTracingESC.class)) {
                ((InteractiveMultipleDjikstraTracingESC)painter).removePathLister(this);
                ((InteractiveMultipleDjikstraTracingESC)painter).stopTracing();
                this.selectedSequence.removeOverlay(painter);
            }
        }
        if (this.maxProjectionSequence != null) {
            for (Overlay painter : this.maxProjectionSequence.getOverlays(InteractiveMultipleDjikstraTracingESC.class)) {
                ((InteractiveMultipleDjikstraTracingESC)painter).removePathLister(this);
                ((InteractiveMultipleDjikstraTracingESC)painter).stopTracing();
                this.maxProjectionSequence.removeOverlay(painter);
            }
        }
        if (this.filteredProjectionSequence != null) {
            for (Overlay painter : this.filteredProjectionSequence.getOverlays(InteractiveMultipleDjikstraTracingESC.class)) {
                ((InteractiveMultipleDjikstraTracingESC)painter).removePathLister(this);
                ((InteractiveMultipleDjikstraTracingESC)painter).stopTracing();
                this.filteredProjectionSequence.removeOverlay(painter);
            }
        }
    }

    private void startTracers() {
        if (this.selectedSequence != null) {
            InteractiveMultipleDjikstraTracingESC tracer;
            if (this.useOriginalSequenceButton.isSelected()) {
                tracer = new InteractiveMultipleDjikstraTracingESC(this.selectedSequence, this.alpha, false);
                this.selectedSequence.addOverlay((Overlay)tracer);
                tracer.addPathLister(this);
            }
            this.maxProjectionSequence = null;
            this.filteredProjectionSequence = null;
            if (this.traceInFilteredProjectionButton.isSelected()) {
                this.filteredProjectionSequence = this.getMaxMinDiffProjectionSequence(this.selectedSequence);
                Icy.getMainInterface().addSequence(this.filteredProjectionSequence);
                tracer = new InteractiveMultipleDjikstraTracingESC(this.filteredProjectionSequence, this.alpha, false);
                this.filteredProjectionSequence.addOverlay((Overlay)tracer);
                tracer.addPathLister(this);
            }
        }
    }

    @Override
    protected void changeSelectedSequence(Sequence sequence) {
        this.stopTracers();
        this.selectedSequence = sequence;
        this.startTracers();
    }

    Sequence getMaxProjectionSequence(Sequence seq) {
        Sequence projectionSequence = null;
        if (seq != null) {
            projectionSequence = new Sequence("Projection_" + seq.getName());
            projectionSequence.setImage(0, 0, (BufferedImage)new IcyBufferedImage(seq.getSizeX(), seq.getSizeY(), 1, DataType.DOUBLE));
            double[] tabValues = projectionSequence.getImage(0, 0, 0).getDataXYAsDouble(0);
            for (int t = 0; t < seq.getSizeT(); ++t) {
                double[] image = (double[])ArrayUtil.arrayToDoubleArray((Object)seq.getImage(t, 0, 0).getDataXY(0), (boolean)seq.isSignedDataType());
                for (int i = 0; i < tabValues.length; ++i) {
                    if (!(image[i] > tabValues[i])) continue;
                    tabValues[i] = image[i];
                }
            }
            projectionSequence.dataChanged();
        }
        return projectionSequence;
    }

    Sequence getMaxMinDiffProjectionSequence(Sequence seq) {
        Sequence projectionSequence = null;
        if (seq != null) {
            projectionSequence = new Sequence("Projection_" + seq.getName());
            projectionSequence.setImage(0, 0, (BufferedImage)new IcyBufferedImage(seq.getSizeX(), seq.getSizeY(), 1, DataType.DOUBLE));
            double[] tabValues = projectionSequence.getImage(0, 0, 0).getDataXYAsDouble(0);
            double[] minValues = (double[])tabValues.clone();
            for (int t = 0; t < seq.getSizeT(); ++t) {
                double[] image = (double[])ArrayUtil.arrayToDoubleArray((Object)seq.getImage(t, 0, 0).getDataXY(0), (boolean)seq.isSignedDataType());
                for (int i = 0; i < tabValues.length; ++i) {
                    if (image[i] > tabValues[i]) {
                        tabValues[i] = image[i];
                        continue;
                    }
                    if (!(image[i] < minValues[i])) continue;
                    minValues[i] = image[i];
                }
            }
            int i = 0;
            while ((double)i < tabValues[i]) {
                int n = i;
                tabValues[n] = tabValues[n] - minValues[i];
                ++i;
            }
            projectionSequence.dataChanged();
        }
        return projectionSequence;
    }

    Sequence getFilteredProjectionSequenceWithRiesz(Sequence seq) {
        int i;
        int height = seq.getSizeY();
        int width = seq.getSizeX();
        boolean isRealImage = true;
        int numScales = 4;
        int tmpNumScales = 0;
        int i2 = 0;
        while (i2 < numScales && !((double)height < Math.pow(2.0, i2)) && !((double)width < Math.pow(2.0, i2))) {
            tmpNumScales = i2++;
        }
        numScales = tmpNumScales;
        boolean prefilter = false;
        IsotropicWaveletType waveletType = IsotropicWaveletType.Simoncelli;
        int order = 8;
        HarmonicTypes harmonicType = HarmonicTypes.even;
        boolean prepareRieszFilters = true;
        RieszWaveletConfig config = new RieszWaveletConfig(width, height, isRealImage, numScales, waveletType, prefilter, prepareRieszFilters, order, harmonicType, false);
        ArrayList<RieszConfig> rieszConfigList = config.getRieszConfigurations();
        ArrayList<RieszGeneralization> generalizationList = new ArrayList<RieszGeneralization>();
        for (int i3 = 0; i3 < numScales; ++i3) {
            RieszGeneralization rieszGeneralization = new RieszGeneralization(StandardRieszFrames.Simoncelli, rieszConfigList.get(i3));
            generalizationList.add(rieszGeneralization);
        }
        double[] tabValues = (double[])ArrayUtil.arrayToDoubleArray((Object)seq.getImage(0, 0, 0).getDataXY(0), (boolean)seq.isSignedDataType());
        for (int t = 1; t < seq.getSizeT(); ++t) {
            double[] image = (double[])ArrayUtil.arrayToDoubleArray((Object)seq.getImage(t, 0, 0).getDataXY(0), (boolean)seq.isSignedDataType());
            for (int i4 = 0; i4 < tabValues.length; ++i4) {
                if (!(image[i4] > tabValues[i4])) continue;
                tabValues[i4] = image[i4];
            }
        }
        RieszWaveletCoefficients coefficients = config.multiscaleRieszAnalysisInFourier(tabValues, width, height, generalizationList);
        double[] hpR = coefficients.getHPResidual();
        if (hpR != null) {
            double[] tmp = (double[])hpR.clone();
            for (int i5 = 0; i5 < tmp.length; ++i5) {
                tmp[i5] = tmp[i5] * tmp[i5];
            }
            Arrays.sort(tmp);
            double threshold = tmp[(int)((double)tmp.length * 0.75)];
            for (int i6 = 0; i6 < tmp.length; ++i6) {
                if (!(hpR[i6] * hpR[i6] < threshold)) continue;
                hpR[i6] = 0.0;
            }
        }
        double[] lpR = coefficients.getLPResidual();
        for (int i7 = 0; i7 < lpR.length; ++i7) {
            lpR[i7] = 0.0;
        }
        for (int scale = 0; scale < coefficients.getNumScales(); ++scale) {
            double[][] c = coefficients.getRieszBandsAtScale(scale);
            for (int b = 0; b < c.length; ++b) {
                double[] tmp = (double[])c[b].clone();
                for (int i8 = 0; i8 < tmp.length; ++i8) {
                    tmp[i8] = tmp[i8] * tmp[i8];
                }
                Arrays.sort(tmp);
                double threshold = tmp[(int)((double)tmp.length * 0.75)];
                for (int i9 = 0; i9 < tmp.length; ++i9) {
                    if (!(c[b][i9] * c[b][i9] < threshold)) continue;
                    c[b][i9] = 0.0;
                }
            }
        }
        Sequence recSeq = new Sequence();
        double[] reconstructedImage = config.multiscaleRieszSynthesisInFourier(coefficients, width, height);
        double minV = reconstructedImage[0];
        for (i = 0; i < reconstructedImage.length; ++i) {
            if (!(reconstructedImage[i] < minV)) continue;
            minV = reconstructedImage[i];
        }
        i = 0;
        while (i < reconstructedImage.length) {
            int n = i++;
            reconstructedImage[n] = reconstructedImage[n] - minV;
        }
        recSeq.addImage(0, (BufferedImage)new IcyBufferedImage(width, height, (Object)reconstructedImage));
        return recSeq;
    }

    Sequence getFilteredProjectionSequence(Sequence seq) {
        Sequence projectionSequence = null;
        if (seq != null) {
            double[] maxVar = new double[seq.getSizeX() * seq.getSizeY()];
            double[] sum = new double[seq.getSizeX() * seq.getSizeY()];
            double[] sumSq = new double[seq.getSizeX() * seq.getSizeY()];
            int windowLength = 20;
            for (int t1 = 0; t1 < seq.getSizeT(); t1 += windowLength / 2) {
                for (int i = 0; i < sum.length; ++i) {
                    sum[i] = 0.0;
                    sumSq[i] = 0.0;
                }
                int t2 = t1 + windowLength;
                if (t2 > seq.getSizeT()) {
                    t2 = seq.getSizeT();
                }
                for (int t = t1; t < t2; ++t) {
                    double[] image = (double[])ArrayUtil.arrayToDoubleArray((Object)seq.getImage(t, 0, 0).getDataXY(0), (boolean)seq.isSignedDataType());
                    for (int i = 0; i < image.length; ++i) {
                        int n = i;
                        sum[n] = sum[n] + image[i];
                        int n2 = i;
                        sumSq[n2] = sumSq[n2] + image[i] * image[i];
                    }
                }
                for (int i = 0; i < sum.length; ++i) {
                    double var = sumSq[i] / (double)(t2 - t1) - sum[i] * sum[i] / (double)((t2 - t1) * (t2 - t1));
                    if (!(var > maxVar[i])) continue;
                    maxVar[i] = var;
                }
            }
            for (int i = 0; i < maxVar.length; ++i) {
                maxVar[i] = Math.sqrt(maxVar[i]);
            }
            projectionSequence = new Sequence("Filtered projection_" + seq.getName());
            projectionSequence.addImage(0, (BufferedImage)new IcyBufferedImage(seq.getSizeX(), seq.getSizeY(), (Object)maxVar));
        }
        return projectionSequence;
    }

    @Override
    public void refreshPath(PathEvent event, InteractiveMultipleDjikstraTracingESC source, double[][] path) {
        if (event == PathEvent.FINAL_PATH) {
            ArrayList<double[][]> paths = source.getOptimalPathCopy();
            ROI roi = Util.convertPathToROI(this.selectedSequence, paths);
            int cntROI = 1;
            boolean notFound = false;
            String name = "Path_" + cntROI;
            while (!notFound) {
                notFound = true;
                name = "Path_" + cntROI;
                for (ROI r : this.selectedSequence.getROIs()) {
                    if (!r.getName().equals(name)) continue;
                    notFound = false;
                }
                ++cntROI;
            }
            roi.setName(name);
            this.selectedSequence.addROI(roi);
        }
    }

    protected void extractKymographs() {
        if (this.selectedSequence != null) {
            double diskRadius = 2.0;
            try {
                diskRadius = this.diskFormat.parse(this.diskRadiusField.getText()).doubleValue();
            }
            catch (ParseException e) {
                e.printStackTrace();
                return;
            }
            diskRadius = Math.max(1.0E-6, diskRadius);
            ROItoKymograph extractor = new ROItoKymograph(diskRadius, 1.0);
            for (ROI2D roi : this.selectedSequence.getROI2Ds()) {
                double length;
                CubicSmoothingSpline ySpline;
                CubicSmoothingSpline xSpline;
                if (!(roi instanceof ROI2DShape)) continue;
                if (this.separateAnteroRetroBox.isSelected()) {
                    Sequence[] kymographs = null;
                    xSpline = Util.getXsplineFromROI((ROI2DShape)roi);
                    ySpline = Util.getYsplineFromROI((ROI2DShape)roi);
                    length = Util.getSplineLength((ROI2DShape)roi);
                    kymographs = extractor.getAnteroRetroKymographSequence(this.selectedSequence, length, xSpline, ySpline);
                    Sequence kymo = kymographs[0];
                    kymo.setName(roi.getName() + "_kymograph");
                    Icy.getMainInterface().addSequence(kymo);
                    Sequence anteroKymo = kymographs[1];
                    anteroKymo.setName(roi.getName() + "_anteroKymograph");
                    Icy.getMainInterface().addSequence(anteroKymo);
                    Sequence retroKymo = kymographs[2];
                    retroKymo.setName(roi.getName() + "_retroKymograph");
                    Icy.getMainInterface().addSequence(retroKymo);
                    KymographExtractionResult result = new KymographExtractionResult();
                    result.roi = roi;
                    result.setKymograph(kymo);
                    result.anterogradeRetrogradeSeparation = true;
                    result.sourceSequence = this.selectedSequence;
                    result.setAnterogradeKymograph(anteroKymo);
                    result.setRetrogradeKymograph(retroKymo);
                    result.samplingPositions = extractor.samplingPositions;
                    Icy.getMainInterface().getSwimmingPool().add(new SwimmingObject((Object)result));
                    continue;
                }
                Sequence kymograph = null;
                xSpline = Util.getXsplineFromROI((ROI2DShape)roi);
                ySpline = Util.getYsplineFromROI((ROI2DShape)roi);
                length = Util.getSplineLength((ROI2DShape)roi);
                kymograph = extractor.getKymographSequence(this.selectedSequence, length, xSpline, ySpline);
                kymograph.setName(roi.getName() + "_kymograph");
                Icy.getMainInterface().addSequence(kymograph);
                KymographExtractionResult result = new KymographExtractionResult();
                result.roi = roi;
                result.setKymograph(kymograph);
                result.anterogradeRetrogradeSeparation = false;
                result.sourceSequence = this.selectedSequence;
                result.samplingPositions = extractor.samplingPositions;
                Icy.getMainInterface().getSwimmingPool().add(new SwimmingObject((Object)result));
            }
        }
    }

    class ControlPointPainter
    extends Overlay {
        ArrayList<double[]> points;

        public ControlPointPainter(ArrayList<double[]> points) {
            super("Control point painter");
            this.points = points;
        }

        public void paint(Graphics2D g, Sequence sequence, IcyCanvas canvas) {
            if (this.points != null) {
                for (double[] p : this.points) {
                    g.setColor(Color.red);
                    g.setStroke(new BasicStroke(1.0f));
                    g.draw(new Line2D.Double(p[0] - 2.0 + 0.5, p[1] + 0.5, p[0] + 2.0 + 0.5, p[1] + 0.5));
                    g.draw(new Line2D.Double(p[0] + 0.5, p[1] - 2.0 + 0.5, p[0] + 0.5, p[1] + 2.0 + 0.5));
                }
            }
        }
    }
}

