/*
 * Decompiled with CFR 0.152.
 */
package mitiv.array;

import mitiv.array.ArrayFactory;
import mitiv.array.Scalar;
import mitiv.array.ShapedArray;
import mitiv.base.Shape;
import mitiv.base.indexing.Range;

public abstract class Array1D
implements ShapedArray {
    protected final Shape shape;
    protected final int number;
    protected final int dim1;

    protected Array1D(int dim1) {
        this.shape = new Shape(dim1);
        if (this.shape.number() > Integer.MAX_VALUE) {
            throw new IllegalArgumentException("Total number of elements is too large");
        }
        this.number = (int)this.shape.number();
        this.dim1 = dim1;
    }

    protected Array1D(int[] dims) {
        this(new Shape(dims));
    }

    protected Array1D(Shape shape) {
        if (shape.rank() != 1) {
            throw new IllegalArgumentException("Bad number of dimensions for 1-D array");
        }
        if (shape.number() > Integer.MAX_VALUE) {
            throw new IllegalArgumentException("Total number of elements is too large");
        }
        this.number = (int)shape.number();
        this.shape = shape;
        this.dim1 = shape.dimension(0);
    }

    @Override
    public final int getRank() {
        return 1;
    }

    @Override
    public final Shape getShape() {
        return this.shape;
    }

    @Override
    public final int getNumber() {
        return this.number;
    }

    @Override
    public final int getDimension(int k) {
        return this.shape.dimension(k);
    }

    public final Array1D reshape(Shape shape) {
        if (this.number == (int)shape.number()) {
            return (Array1D)ArrayFactory.wrap(this.getData(), shape);
        }
        throw new IllegalArgumentException("The new shape is not commensurate with the old shape");
    }

    @Override
    public final Array1D movedims(int initpos, int finalpos) {
        int k;
        if (finalpos > 0 || initpos > 0) {
            throw new IllegalArgumentException("The permutation should not change the rank");
        }
        if (initpos == finalpos) {
            return this.copy();
        }
        int[] newdims = new int[1];
        if (initpos < finalpos) {
            for (k = 0; k < initpos; ++k) {
                newdims[k] = this.shape.dimension(k);
            }
            for (k = initpos; k < finalpos; ++k) {
                newdims[k] = this.shape.dimension(k + 1);
            }
            newdims[finalpos] = this.shape.dimension(initpos);
            for (k = finalpos + 1; k < 1; ++k) {
                newdims[k] = this.shape.dimension(k);
            }
        } else {
            for (k = 0; k < finalpos; ++k) {
                newdims[k] = this.shape.dimension(k);
            }
            newdims[finalpos] = this.shape.dimension(initpos);
            for (k = finalpos + 1; k < initpos + 1; ++k) {
                newdims[k] = this.shape.dimension(k - 1);
            }
            for (k = initpos + 1; k < 1; ++k) {
                newdims[k] = this.shape.dimension(k);
            }
        }
        Array1D newArray = (Array1D)ArrayFactory.create(this.getType(), newdims);
        for (int n = 0; n < this.shape.dimension(initpos); ++n) {
            newArray.slice(n, finalpos).assign(this.slice(n, initpos));
        }
        return newArray;
    }

    @Override
    public abstract Array1D copy();

    public abstract Scalar slice(int var1);

    public abstract Scalar slice(int var1, int var2);

    public abstract Array1D view(Range var1);

    public abstract Array1D view(int[] var1);

    @Override
    public abstract Array1D as1D();

    public static int checkViewStrides(int number, int offset, int stride1, int dim1) {
        int imax;
        int imin;
        int itmp = (dim1 - 1) * stride1;
        if (itmp >= 0) {
            imin = offset;
            imax = offset + itmp;
        } else {
            imin = offset + itmp;
            imax = offset;
        }
        if (imin < 0 || imax >= number) {
            throw new IndexOutOfBoundsException("1D view is not within available space");
        }
        return 1;
    }
}

