/*
 * Decompiled with CFR 0.152.
 */
package plugins.adufour.activecontours;

import icy.canvas.IcyCanvas;
import icy.painter.Overlay;
import icy.sequence.Sequence;
import icy.sequence.SequenceEvent;
import icy.sequence.SequenceListener;
import java.awt.Graphics2D;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.ConcurrentModificationException;
import plugins.adufour.activecontours.ActiveContour;
import plugins.fab.trackmanager.TrackGroup;
import plugins.fab.trackmanager.TrackSegment;
import plugins.nchenouard.spot.Detection;

public class ActiveContoursOverlay
extends Overlay
implements SequenceListener {
    private TrackGroup trackGroup;

    public ActiveContoursOverlay(TrackGroup trackGroup) {
        super("Active contours");
        this.trackGroup = trackGroup;
    }

    public void paint(Graphics2D g, Sequence sequence, IcyCanvas canvas) {
        if (!Arrays.asList(sequence.getListeners()).contains((Object)this)) {
            sequence.addListener((SequenceListener)this);
        }
        int currentPositionT = canvas.getPositionT();
        ArrayList segments = new ArrayList(this.trackGroup.getTrackSegmentList());
        for (int i = 1; i <= segments.size(); ++i) {
            TrackSegment segment = (TrackSegment)segments.get(i - 1);
            if (segment == null) continue;
            for (int d = 0; d < segment.getDetectionList().size(); ++d) {
                ActiveContour contour = (ActiveContour)segment.getDetectionList().get(d);
                if (contour == null || contour.getT() != currentPositionT) continue;
                contour.paint(g, sequence, canvas);
                if (g == null) continue;
                float f = (float)canvas.canvasToImageLogDeltaX(18);
                float x = (float)contour.getX();
                float y = (float)contour.getY();
                g.drawString("" + i, x -= i < 10 ? f / 2.0f : f, y += f / 2.0f);
            }
        }
    }

    public void remove() {
        ArrayList segments = new ArrayList(this.trackGroup.getTrackSegmentList());
        for (int i = 1; i <= segments.size(); ++i) {
            TrackSegment segment = (TrackSegment)segments.get(i - 1);
            if (segment == null) continue;
            try {
                ArrayList detections = segment.getDetectionList();
                if (detections == null) continue;
                for (Detection detection : detections) {
                    ((ActiveContour)detection).clean();
                }
                continue;
            }
            catch (ConcurrentModificationException concurrentModificationException) {
                // empty catch block
            }
        }
        super.remove();
        this.trackGroup.getSequence().removeOverlay((Overlay)this);
    }

    public void sequenceChanged(SequenceEvent sequenceEvent) {
        if (sequenceEvent.getSourceType() != SequenceEvent.SequenceEventSourceType.SEQUENCE_OVERLAY) {
            return;
        }
        if (sequenceEvent.getSource() == this && sequenceEvent.getType() == SequenceEvent.SequenceEventType.REMOVED) {
            sequenceEvent.getSequence().removeListener((SequenceListener)this);
            this.remove();
        }
    }

    public void sequenceClosed(Sequence sequence) {
        sequence.removeListener((SequenceListener)this);
        this.remove();
    }
}

