/*
 * Decompiled with CFR 0.152.
 */
package plugins.adufour.roi.intensitycenter;

import icy.roi.ROI;
import icy.roi.ROIDescriptor;
import icy.sequence.Sequence;
import icy.sequence.SequenceEvent;
import icy.type.point.Point3D;
import plugins.adufour.roi.intensitycenter.ROIIntensityCenterDescriptorsPlugin;

public class ROIIntensityCenterXDescriptor
extends ROIDescriptor {
    public static final String ID = "Intensity center X";

    public ROIIntensityCenterXDescriptor() {
        super(ID, ID, Double.class);
    }

    public String getDescription() {
        return ID;
    }

    public String getUnit(Sequence sequence) {
        return "px";
    }

    public boolean separateChannel() {
        return true;
    }

    public boolean needRecompute(SequenceEvent change) {
        return change.getSourceType() == SequenceEvent.SequenceEventSourceType.SEQUENCE_DATA;
    }

    public Object compute(ROI roi, Sequence sequence) throws UnsupportedOperationException, InterruptedException {
        return ROIIntensityCenterXDescriptor.getIntensityCenterX(ROIIntensityCenterDescriptorsPlugin.computeIntensityCenter(roi, sequence));
    }

    public static double getIntensityCenterX(Point3D point) {
        if (point == null) {
            return Double.NaN;
        }
        return point.getX();
    }
}

