/*
 * Decompiled with CFR 0.152.
 */
package plugins.adufour.protocols.gui;

import icy.common.listener.AcceptListener;
import icy.file.Loader;
import icy.gui.component.CloseableTabbedPane;
import icy.gui.frame.IcyFrame;
import icy.gui.frame.IcyFrameEvent;
import icy.gui.frame.IcyFrameListener;
import icy.gui.frame.progress.AnnounceFrame;
import icy.main.Icy;
import icy.plugin.PluginDescriptor;
import icy.plugin.PluginInstaller;
import icy.plugin.PluginLoader;
import icy.resource.ResourceUtil;
import icy.resource.icon.IcyIcon;
import icy.system.FileDrop;
import icy.system.IcyExceptionHandler;
import icy.system.IcyHandledException;
import icy.system.thread.ThreadUtil;
import icy.util.XMLUtil;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JOptionPane;
import javax.swing.JSplitPane;
import javax.swing.JToolBar;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.plaf.SplitPaneUI;
import javax.swing.plaf.basic.BasicSplitPaneDivider;
import org.pushingpixels.substance.internal.ui.SubstanceSplitPaneUI;
import org.pushingpixels.substance.internal.utils.SubstanceSplitPaneDivider;
import org.w3c.dom.Document;
import plugins.adufour.blocks.lang.Block;
import plugins.adufour.blocks.lang.BlockDescriptor;
import plugins.adufour.blocks.lang.Link;
import plugins.adufour.blocks.lang.WorkFlow;
import plugins.adufour.blocks.util.BlockListener;
import plugins.adufour.blocks.util.BlocksException;
import plugins.adufour.blocks.util.BlocksML;
import plugins.adufour.blocks.util.BlocksReloadedException;
import plugins.adufour.blocks.util.LinkCutException;
import plugins.adufour.blocks.util.NoSuchVariableException;
import plugins.adufour.protocols.Protocols;
import plugins.adufour.protocols.gui.BlockSearchPanel;
import plugins.adufour.protocols.gui.ProtocolPanel;
import plugins.adufour.protocols.gui.block.WorkFlowContainer;
import plugins.adufour.vars.lang.Var;

public class MainFrame
extends IcyFrame
implements IcyFrameListener,
ActionListener,
CloseableTabbedPane.CloseableTabbedPaneListener,
AcceptListener,
ChangeListener,
BlockListener,
FileDrop.FileDropListener {
    private static final String UNTITLED = "untitled";
    private final JToolBar toolBar;
    private final JButton bNew = new JButton("New", (Icon)new IcyIcon(ResourceUtil.ICON_DOC_NEW));
    private final JButton bLoad = new JButton("Load", (Icon)new IcyIcon(ResourceUtil.ICON_OPEN));
    private final JButton bSave = new JButton("Save", (Icon)new IcyIcon(ResourceUtil.ICON_SAVE));
    private final JButton bSaveAs = new JButton("Save as", (Icon)new IcyIcon(ResourceUtil.ICON_DOC_EXPORT));
    private final JButton bEmbed = new JButton("Embed", (Icon)new IcyIcon(ResourceUtil.ICON_WINDOW_COLLAPSE));
    private final JButton bRun = new JButton("Run", (Icon)new IcyIcon(ResourceUtil.ICON_PLAY));
    private final JButton bClean = new JButton("Reset", (Icon)new IcyIcon(ResourceUtil.ICON_TRASH));
    private final CloseableTabbedPane closeableTabbedPane = new CloseableTabbedPane(1, 0);
    private final ArrayList<ProtocolPanel> protocolPanels = new ArrayList();
    private BlockSearchPanel blockSearchPanel = new BlockSearchPanel();
    private JSplitPane splitPane;
    private static final HashMap<BlockDescriptor, BlockDescriptor> blocksClipBoard = new HashMap();
    private static final HashMap<BlockDescriptor, BlockDescriptor> blocksClipBoardBackup = new HashMap();
    private static final ArrayList<Link<?>> linksClipBoard = new ArrayList();
    private static final ArrayList<Link<?>> linksClipBoardBackup = new ArrayList();
    private static final String LINKS_CUT_MSG = "Some links will not be copied. Continue?";
    private final Protocols pluginInstance;
    private boolean isFrameClosing = false;

    public MainFrame(Protocols pluginInstance) {
        super("Protocols editor (" + pluginInstance.getFriendlyVersion() + ")", true, true, true, true, true);
        this.pluginInstance = pluginInstance;
        this.setDefaultCloseOperation(0);
        this.addFrameListener(this);
        this.setPreferredSize(new Dimension(800, 640));
        this.toolBar = new JToolBar("Blocks toolbar", 0);
        this.getContentPane().add((Component)this.toolBar, "North");
        for (JButton button : new JButton[]{this.bNew, this.bLoad, this.bSave, this.bSaveAs, this.bEmbed, this.bRun, this.bClean}) {
            button.setFocusPainted(false);
            button.setBorderPainted(true);
            button.addActionListener(this);
            button.setBorder(null);
        }
        this.bNew.setToolTipText("<html><h4>Create a new empty protocol</h4></html>");
        this.bLoad.setToolTipText("<html><h4>Load a protocol from a file</h4></html>");
        this.bSave.setToolTipText("<html><h4>Save the current protocol</h4></html>");
        this.bSaveAs.setToolTipText("<html><h4>Save the protocol to a new file</h4></html>");
        this.bEmbed.setToolTipText("<html><h4>Embed the current selection into a new work flow or a batch</h4></html>");
        this.bRun.setToolTipText("<html><h4>Run the current protocol</h4></html>");
        this.bClean.setToolTipText("<html><h4>Clear all intermediate results (may help saving memory)</h4></html>");
        this.toolBar.add(this.bNew);
        this.toolBar.add(this.bLoad);
        this.toolBar.add(this.bSave);
        this.toolBar.add(this.bSaveAs);
        this.toolBar.add(new JToolBar.Separator());
        this.toolBar.add(this.bEmbed);
        this.toolBar.add(new JToolBar.Separator());
        this.toolBar.add(this.bRun);
        this.toolBar.add(this.bClean);
        this.closeableTabbedPane.addCloseableTabbedPaneListener((CloseableTabbedPane.CloseableTabbedPaneListener)this);
        this.splitPane = new JSplitPane(1, this.blockSearchPanel, (Component)this.closeableTabbedPane);
        this.splitPane.setOneTouchExpandable(true);
        this.splitPane.setContinuousLayout(true);
        this.splitPane.setUI((SplitPaneUI)((Object)new MySplitPaneUI()));
        this.getContentPane().add((Component)this.splitPane, "Center");
        this.getContentPane().addKeyListener(new KeyListener(){

            @Override
            public void keyPressed(KeyEvent key) {
                if ((key.getModifiers() & Protocols.MENU_SHORTCUT_KEY) == Protocols.MENU_SHORTCUT_KEY && key.getComponent() instanceof WorkFlowContainer) {
                    WorkFlow wf = ((WorkFlowContainer)key.getComponent()).getWorkFlow();
                    switch (key.getKeyCode()) {
                        case 67: {
                            MainFrame.copySelection(wf, false);
                            break;
                        }
                        case 86: {
                            MainFrame.pasteSelection(wf, false);
                            break;
                        }
                        case 88: {
                            MainFrame.copySelection(wf, false);
                            MainFrame.deleteSelection(wf);
                            break;
                        }
                        case 8: 
                        case 127: {
                            MainFrame.deleteSelection(wf);
                        }
                    }
                    key.getComponent().requestFocus();
                }
            }

            @Override
            public void keyTyped(KeyEvent arg0) {
            }

            @Override
            public void keyReleased(KeyEvent arg0) {
            }
        });
        Icy.getMainInterface().addCanExitListener((AcceptListener)this);
        this.pack();
    }

    public static void copySelection(WorkFlow wf, boolean embedding) throws LinkCutException {
        if (embedding) {
            blocksClipBoardBackup.clear();
            blocksClipBoardBackup.putAll(blocksClipBoard);
            linksClipBoardBackup.clear();
            linksClipBoardBackup.addAll(linksClipBoard);
        }
        blocksClipBoard.clear();
        linksClipBoard.clear();
        if (wf.getBlockSelection().isEmpty()) {
            for (BlockDescriptor blockDescriptor : wf) {
                blocksClipBoard.put(blockDescriptor, blockDescriptor.clone(embedding));
            }
            for (Link link : wf.getLinksIterator()) {
                linksClipBoard.add(link);
            }
        } else {
            for (BlockDescriptor blockDescriptor : wf.getBlockSelection()) {
                blocksClipBoard.put(blockDescriptor, blockDescriptor.clone(embedding));
            }
            for (Link link : wf.getLinkSelection()) {
                linksClipBoard.add(link);
            }
        }
        if (embedding && MainFrame.linkCut(wf.getLinksIterator())) {
            throw new LinkCutException(LINKS_CUT_MSG);
        }
    }

    public static void pasteSelection(WorkFlow wf, boolean embedding) {
        for (BlockDescriptor blockDescriptor : blocksClipBoard.keySet()) {
            if (blockDescriptor.getBlock() instanceof WorkFlow) {
                ((WorkFlow)blocksClipBoard.get(blockDescriptor).getBlock()).newSelection();
            }
            wf.addBlock(blocksClipBoard.get(blockDescriptor));
        }
        for (Link link : linksClipBoard) {
            Link<?> clone = MainFrame.linkClone(wf, link);
            if (clone == null) {
                System.err.println("Warning: cannot copy a link to an exposed variable");
                continue;
            }
            wf.addLink(clone.srcBlock, clone.srcVar, clone.dstBlock, clone.dstVar);
        }
        for (BlockDescriptor blockDescriptor : blocksClipBoard.keySet()) {
            blocksClipBoard.put(blockDescriptor, blocksClipBoard.get(blockDescriptor).clone(embedding));
        }
        if (embedding) {
            blocksClipBoard.clear();
            blocksClipBoard.putAll(blocksClipBoardBackup);
            linksClipBoard.clear();
            linksClipBoard.addAll(linksClipBoardBackup);
        }
    }

    private static void deleteSelection(WorkFlow wf) {
        if (wf.getBlockSelection().isEmpty()) {
            ArrayList tmp = new ArrayList();
            for (Link<Object> l : wf.getLinksIterator()) {
                tmp.add(l);
            }
            for (Link<Object> l : tmp) {
                wf.removeLink(l.dstVar);
            }
            int i = 0;
            while (i < wf.size()) {
                wf.removeBlock(wf.getBlock(i), false);
            }
        } else {
            for (Link<?> l : wf.getLinkSelection()) {
                wf.removeLink(l.dstVar);
            }
            ArrayList<BlockDescriptor> tmp = new ArrayList<BlockDescriptor>(wf.getBlockSelection());
            Iterator iterator = tmp.iterator();
            while (iterator.hasNext()) {
                BlockDescriptor bd = (BlockDescriptor)iterator.next();
                wf.removeBlock(bd, false);
            }
        }
    }

    private static boolean linkCut(Iterable<Link<?>> links) {
        for (Link<?> l : links) {
            if (!(blocksClipBoard.keySet().contains(l.dstBlock) ^ blocksClipBoard.keySet().contains(l.srcBlock))) continue;
            return true;
        }
        return false;
    }

    private static Link<?> linkClone(WorkFlow wf, Link<?> l) {
        Var newSrc = null;
        Var newDst = null;
        try {
            newSrc = MainFrame.blocksClipBoard.get((Object)l.srcBlock).inputVars.get(l.srcBlock.inputVars.getID(l.srcVar));
            newDst = MainFrame.blocksClipBoard.get((Object)l.dstBlock).inputVars.get(l.dstBlock.inputVars.getID(l.dstVar));
        }
        catch (NoSuchVariableException nsve) {
            newSrc = MainFrame.blocksClipBoard.get((Object)l.srcBlock).outputVars.get(l.srcBlock.outputVars.getID(l.srcVar));
            newDst = MainFrame.blocksClipBoard.get((Object)l.dstBlock).inputVars.get(l.dstBlock.inputVars.getID(l.dstVar));
        }
        if (newSrc == null || newDst == null) {
            return null;
        }
        return new Link(wf, blocksClipBoard.get(l.srcBlock), newSrc, blocksClipBoard.get(l.dstBlock), newDst);
    }

    public void addProtocolPane(ProtocolPanel protocol) {
        this.getProtocolPanels().add(protocol);
        protocol.addPropertyChangeListener("WORKFLOW_MODIFIED", (PropertyChangeListener)((Object)this));
        protocol.addBlockListener(this);
        new FileDrop((Component)protocol, false, (FileDrop.FileDropListener)this);
        if (protocol.getFile() != null) {
            File f = protocol.getFile();
            protocol.setName(f.getName());
            this.closeableTabbedPane.addTab(f.getName(), (Component)protocol);
            this.closeableTabbedPane.setToolTipTextAt(this.getProtocolPanels().size() - 1, f.getAbsolutePath());
        } else {
            protocol.setName(UNTITLED);
            this.closeableTabbedPane.addTab(UNTITLED, (Component)protocol);
        }
        this.closeableTabbedPane.setSelectedIndex(this.getProtocolPanels().size() - 1);
    }

    public ProtocolPanel getActiveProtocol() {
        int index = this.closeableTabbedPane.getSelectedIndex();
        return index == -1 ? null : this.getProtocolPanels().get(index);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.bNew) {
            this.addProtocolPane(new ProtocolPanel(this));
        } else if (e.getSource() == this.bLoad) {
            this.loadWorkFlow(null);
        } else if (e.getSource() == this.bSave) {
            this.saveWorkFlow(this.getActiveProtocol(), true);
        } else if (e.getSource() == this.bSaveAs) {
            ProtocolPanel protocol = this.getActiveProtocol();
            if (protocol == null) {
                return;
            }
            File oldFile = protocol.getFile();
            protocol.setFile(null);
            if (!this.saveWorkFlow(protocol, true)) {
                protocol.setFile(oldFile);
            }
        } else if (e.getSource() == this.bRun) {
            ProtocolPanel protocol = this.getActiveProtocol();
            if (protocol == null) {
                return;
            }
            WorkFlow wf = protocol.getWorkFlow();
            if (wf.getBlockDescriptor().getStatus() == BlockDescriptor.BlockStatus.RUNNING) {
                wf.interrupt();
            } else {
                wf.runWorkFlow();
            }
        } else if (e.getSource() == this.bEmbed) {
            ProtocolPanel panel = this.getActiveProtocol();
            if (panel != null) {
                panel.showBlocksEmbedMenu(this.bEmbed);
            }
        } else if (e.getSource() == this.bClean) {
            ProtocolPanel protocol = this.getActiveProtocol();
            if (protocol == null) {
                return;
            }
            WorkFlow wf = protocol.getWorkFlow();
            wf.reset();
        }
    }

    public void propertyChange(PropertyChangeEvent evt) {
        if (evt.getPropertyName() == "WORKFLOW_MODIFIED" && !this.isFrameClosing) {
            ProtocolPanel protocolPanel = (ProtocolPanel)evt.getSource();
            int index = this.getProtocolPanels().indexOf(protocolPanel);
            if (index == -1) {
                String message = "in method \"icy.adufour.protocols.Protocols.propertyChange(PropertyChangeEvent)\":\n";
                message = message + "A protocol was modified, but its panel is already closed (index = -1)";
                IcyExceptionHandler.handleException((PluginDescriptor)this.pluginInstance.getDescriptor(), (Throwable)new ArrayIndexOutOfBoundsException(message), (boolean)true);
                return;
            }
            if (this.closeableTabbedPane.getTabCount() <= index) {
                return;
            }
            if (((Boolean)evt.getNewValue()).booleanValue()) {
                this.closeableTabbedPane.setTitleAt(index, "* " + this.closeableTabbedPane.getTitleAt(index));
            } else if (protocolPanel.getFile() != null) {
                this.closeableTabbedPane.setTitleAt(index, protocolPanel.getFile().getName());
            }
        } else {
            super.propertyChange(evt);
        }
    }

    public void tabClosed(int index, String title) {
    }

    public boolean tabClosing(int index, String title) {
        ProtocolPanel protocol = this.getProtocolPanels().get(index);
        if (protocol.isDirty() && !protocol.isEmpty()) {
            MainFrame mainFrame = this;
            if (!mainFrame.pluginInstance.isReloading()) {
                String name = protocol.getFile() == null ? UNTITLED : protocol.getFile().getName();
                int option = JOptionPane.showConfirmDialog(protocol, name + " has not been saved.\nSave workflow before closing ?", "Confirmation", 1);
                if (option == 2) {
                    return false;
                }
                if (option == 0 && !this.saveWorkFlow(protocol, false)) {
                    return false;
                }
            }
        }
        protocol.removePropertyChangeListener((PropertyChangeListener)((Object)this));
        protocol.removeBlockListener(this);
        protocol.dispose();
        FileDrop.remove((Component)protocol);
        this.getProtocolPanels().remove(protocol);
        return true;
    }

    private boolean saveWorkFlow(ProtocolPanel protocol, boolean updateTabName) throws BlocksException {
        if (protocol == null) {
            return false;
        }
        boolean success = protocol.saveToDisk();
        if (!success) {
            return false;
        }
        File savedFile = protocol.getFile();
        if (updateTabName) {
            this.closeableTabbedPane.setTitleAt(this.closeableTabbedPane.getSelectedIndex(), savedFile.getName());
        }
        return true;
    }

    private File getFile() {
        JFileChooser jfc = new JFileChooser(Protocols.getDefaultProtocolFolder());
        jfc.setFileFilter(BlocksML.XML_FILE_FILTER);
        jfc.setDialogTitle("Load an Icy protocol...");
        if (jfc.showOpenDialog(this.getFrame()) != 0) {
            return null;
        }
        return jfc.getSelectedFile();
    }

    public ArrayList<ProtocolPanel> getProtocolPanels() {
        return this.protocolPanels;
    }

    public void loadWorkFlow(File file) throws IllegalArgumentException {
        if (file == null) {
            file = this.getFile();
        }
        if (file == null) {
            return;
        }
        final File workingFile = file;
        Protocols.setDefaultProtocolFolder(file.getParent());
        for (ProtocolPanel protocol : this.getProtocolPanels()) {
            if (!file.equals(protocol.getFile())) continue;
            return;
        }
        final Document xml = XMLUtil.loadDocument((File)file);
        boolean isFileValid = false;
        if (xml != null) {
            String rootName = XMLUtil.getRootElement((Document)xml).getNodeName();
            boolean bl = isFileValid = rootName.equalsIgnoreCase("protocol") || rootName.equalsIgnoreCase("workspace");
        }
        if (!isFileValid) {
            throw new IcyHandledException("Error while loading \"" + file.getPath() + "\":\nThe selected file is not an Icy protocol.");
        }
        final ProtocolPanel panel = new ProtocolPanel(this);
        panel.setFile(file);
        this.addProtocolPane(panel);
        ThreadUtil.bgRun((Runnable)new Runnable(){

            @Override
            public void run() {
                try (AnnounceFrame announce = new AnnounceFrame("Loading protocol " + workingFile.getName() + "...");){
                    PluginInstaller.waitInstall();
                    PluginLoader.waitWhileLoading();
                    ArrayList plugins = PluginLoader.getPlugins(Block.class, (boolean)true, (boolean)false, (boolean)false);
                    if (plugins.size() == 0) {
                        throw new BlocksReloadedException();
                    }
                    panel.loadWorkFlow(xml, false);
                }
            }
        });
    }

    public void icyFrameOpened(IcyFrameEvent e) {
    }

    public void icyFrameClosing(IcyFrameEvent e) {
        if (e.getFrame() == this) {
            this.isFrameClosing = true;
            if (!this.accept(this)) {
                this.isFrameClosing = false;
            }
        }
    }

    public void icyFrameClosed(IcyFrameEvent e) {
        Protocols.setReloading(false);
    }

    public void icyFrameIconified(IcyFrameEvent e) {
    }

    public void icyFrameDeiconified(IcyFrameEvent e) {
    }

    public void icyFrameActivated(IcyFrameEvent e) {
    }

    public void icyFrameDeactivated(IcyFrameEvent e) {
    }

    public void icyFrameInternalized(IcyFrameEvent e) {
    }

    public void icyFrameExternalized(IcyFrameEvent e) {
    }

    public void filesDropped(File[] files) {
        for (File file : files) {
            try {
                this.loadWorkFlow(file);
            }
            catch (IllegalArgumentException e) {
                if (!Loader.isSupportedImageFile((String)file.getPath())) continue;
                Loader.load((String)file.getPath(), (boolean)true);
            }
        }
    }

    public boolean accept(Object source) {
        block0: while (this.closeableTabbedPane.getTabCount() > 0) {
            int tabCount = this.closeableTabbedPane.getTabCount();
            for (int i = 0; i < tabCount; ++i) {
                if (this.closeableTabbedPane.getSelectedIndex() != i) continue;
                boolean closeAccepted = this.tabClosing(i, null);
                if (!closeAccepted) {
                    return false;
                }
                if (this.closeableTabbedPane.getTabCount() <= i) continue block0;
                this.closeableTabbedPane.removeTabAt(i);
                continue block0;
            }
        }
        for (Component component : this.toolBar.getComponents()) {
            if (component instanceof JButton) {
                ((JButton)component).removeActionListener(this);
            }
            this.toolBar.remove(component);
        }
        this.getContentPane().removeAll();
        this.removeFrameListener(this);
        this.setVisible(false);
        this.close();
        Icy.getMainInterface().removeCanExitListener((AcceptListener)this);
        Protocols.close();
        return true;
    }

    @Override
    public void stateChanged(ChangeEvent e) {
        ProtocolPanel panel = this.getActiveProtocol();
        if (e.getSource() == this.closeableTabbedPane && panel != null) {
            this.updateRunButton(this.getActiveProtocol().getWorkFlow().getBlockDescriptor().getStatus());
        }
    }

    private void updateRunButton(BlockDescriptor.BlockStatus status) {
        switch (status) {
            case RUNNING: {
                this.bRun.setIcon((Icon)new IcyIcon(ResourceUtil.ICON_STOP));
                break;
            }
            default: {
                this.bRun.setIcon((Icon)new IcyIcon(ResourceUtil.ICON_PLAY));
            }
        }
    }

    @Override
    public void blockCollapsed(BlockDescriptor block, boolean collapsed) {
    }

    @Override
    public void blockDimensionChanged(BlockDescriptor block, int newWidth, int newHeight) {
    }

    @Override
    public void blockLocationChanged(BlockDescriptor block, int newX, int newY) {
    }

    @Override
    public void blockStatusChanged(BlockDescriptor block, BlockDescriptor.BlockStatus status) {
        this.updateRunButton(status);
    }

    @Override
    public void blockVariableAdded(BlockDescriptor block, Var<?> variable) {
    }

    @Override
    public <T> void blockVariableChanged(BlockDescriptor block, Var<T> variable, T newValue) {
    }

    private class MySplitPaneUI
    extends SubstanceSplitPaneUI {
        private MySplitPaneUI() {
        }

        public BasicSplitPaneDivider createDefaultDivider() {
            return new MySplitPaneDivider(this);
        }

        private class MySplitPaneDivider
        extends SubstanceSplitPaneDivider {
            public MySplitPaneDivider(SubstanceSplitPaneUI ui) {
                super(ui);
            }

            protected JButton createLeftOneTouchButton() {
                JButton button = super.createLeftOneTouchButton();
                button.setPreferredSize(new Dimension(20, 40));
                return button;
            }

            protected JButton createRightOneTouchButton() {
                JButton button = super.createRightOneTouchButton();
                button.setPreferredSize(new Dimension(20, 40));
                return button;
            }
        }
    }
}

