/*
 * Decompiled with CFR 0.152.
 */
package plugins.adufour.vars.lang;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import javax.annotation.processing.FilerException;
import org.apache.poi.openxml4j.exceptions.InvalidFormatException;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.ss.usermodel.WorkbookFactory;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;
import plugins.adufour.vars.gui.VarEditor;
import plugins.adufour.vars.gui.swing.WorkbookEditor;
import plugins.adufour.vars.lang.Var;
import plugins.adufour.vars.util.VarException;
import plugins.adufour.workbooks.Workbooks;

public class VarWorkbook
extends Var<Workbook> {
    public VarWorkbook(String name, Workbook workbook) {
        super(name, Workbook.class, (Object)workbook, null);
    }

    public VarWorkbook(String name, File file) throws InvalidFormatException, IOException {
        this(name, WorkbookFactory.create((File)file));
    }

    public VarWorkbook(String name, String firstSheetName) {
        this(name, Workbooks.createEmptyWorkbook());
        ((Workbook)this.getValue()).createSheet(firstSheetName);
    }

    public VarEditor<Workbook> createVarEditor() {
        WorkbookEditor editor = new WorkbookEditor(this);
        return editor;
    }

    public VarEditor<Workbook> createVarViewer() {
        WorkbookEditor editor = new WorkbookEditor(this);
        editor.setReadOnly(true);
        editor.setOpenButtonVisible(false);
        return editor;
    }

    public void saveToDisk(File folder, String workbookName) throws VarException, IOException {
        if (!folder.isDirectory()) {
            throw new FilerException(folder + "is not a valid folder");
        }
        Workbook wb = (Workbook)this.getValue(true);
        String filename = folder.getPath() + File.separator + workbookName + ".xls";
        if (wb instanceof XSSFWorkbook) {
            filename = filename + "x";
        }
        FileOutputStream out = new FileOutputStream(filename);
        wb.write((OutputStream)out);
        out.close();
    }
}

