/*
 * Decompiled with CFR 0.152.
 */
package mcib3d.image3d.processing;

import ij.IJ;
import mcib3d.image3d.ImageFloat;
import mcib3d.image3d.ImageHandler;
import mcib3d.image3d.processing.CannyDeriche1D;

public class CannyEdge3D {
    ImageHandler input;
    double alpha;
    ImageFloat[] grads = null;
    ImageFloat edge = null;

    public CannyEdge3D(ImageHandler input, double alpha) {
        this.input = input;
        this.alpha = alpha;
    }

    public ImageHandler getInput() {
        return this.input;
    }

    public void setInput(ImageHandler input) {
        this.input = input;
        this.grads = null;
        this.edge = null;
    }

    public double getAlpha() {
        return this.alpha;
    }

    public void setAlpha(double alpha) {
        this.alpha = alpha;
        this.grads = null;
        this.edge = null;
    }

    private void computeGradient() {
        double[] res;
        CannyDeriche1D canny;
        double[] line;
        int y;
        int z;
        if (this.grads == null) {
            this.grads = new ImageFloat[3];
        }
        this.grads[0] = new ImageFloat("EdgeX", this.input.sizeX, this.input.sizeY, this.input.sizeZ);
        for (z = 0; z < this.input.sizeZ; ++z) {
            IJ.showStatus((String)("Edge X " + z + "/" + this.input.sizeZ));
            for (y = 0; y < this.input.sizeY; ++y) {
                line = this.input.getLineX(0, y, z, this.input.sizeX);
                canny = new CannyDeriche1D(line, this.alpha);
                res = canny.getCannyDeriche();
                this.grads[0].setLineX(0, y, z, res);
            }
        }
        this.grads[1] = new ImageFloat("EdgeY", this.input.sizeX, this.input.sizeY, this.input.sizeZ);
        for (z = 0; z < this.input.sizeZ; ++z) {
            IJ.showStatus((String)("Edge Y " + z + "/" + this.input.sizeZ));
            for (int x = 0; x < this.input.sizeX; ++x) {
                line = this.input.getLineY(x, 0, z, this.input.sizeY);
                canny = new CannyDeriche1D(line, this.alpha);
                res = canny.getCannyDeriche();
                this.grads[1].setLineY(x, 0, z, res);
            }
        }
        this.grads[2] = new ImageFloat("EdgeZ", this.input.sizeX, this.input.sizeY, this.input.sizeZ);
        for (int x = 0; x < this.input.sizeX; ++x) {
            IJ.showStatus((String)("Edge Z " + x + "/" + this.input.sizeX));
            for (y = 0; y < this.input.sizeY; ++y) {
                line = this.input.getLineZ(x, y, 0, this.input.sizeZ);
                canny = new CannyDeriche1D(line, this.alpha);
                res = canny.getCannyDeriche();
                this.grads[2].setLineZ(x, y, 0, res);
            }
        }
    }

    public ImageHandler[] getGradientsXYZ() {
        if (this.grads == null) {
            this.computeGradient();
        }
        return this.grads;
    }

    private void computeEdge() {
        if (this.grads == null) {
            this.computeGradient();
        }
        this.edge = new ImageFloat("Edge", this.input.sizeX, this.input.sizeY, this.input.sizeZ);
        for (int z = 0; z < this.input.sizeZ; ++z) {
            IJ.showStatus((String)("Edge " + z + "/" + this.input.sizeZ));
            for (int x = 0; x < this.input.sizeX; ++x) {
                for (int y = 0; y < this.input.sizeY; ++y) {
                    float ex = this.grads[0].getPixel(x, y, z);
                    float ey = this.grads[1].getPixel(x, y, z);
                    float ez = this.grads[2].getPixel(x, y, z);
                    float ee = (float)Math.sqrt(ex * ex + ey * ey + ez * ez);
                    this.edge.setPixel(x, y, z, ee);
                }
            }
        }
    }

    public ImageHandler getEdge() {
        if (this.edge == null) {
            this.computeEdge();
        }
        return this.edge;
    }
}

