/*
 * Decompiled with CFR 0.152.
 */
package io.minio;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import io.minio.DateFormat;
import io.minio.http.Header;
import java.util.Date;
import org.joda.time.DateTime;

@SuppressFBWarnings(value={"UwF"}, justification="Everything in this class is initialized with reflections.")
public class ResponseHeader {
    @Header(value="Content-Length")
    private long contentLength;
    @Header(value="Content-Type")
    private String contentType;
    @Header(value="Date")
    private DateTime date;
    @Header(value="ETag")
    private String etag;
    @Header(value="Last-Modified")
    private DateTime lastModified;
    @Header(value="Server")
    private String server;
    @Header(value="Status Code")
    private String statusCode;
    @Header(value="Transfer-Encoding")
    private String transferEncoding;
    @Header(value="x-amz-bucket-region")
    private String xamzBucketRegion;
    @Header(value="x-amz-id-2")
    private String xamzId2;
    @Header(value="x-amz-request-id")
    private String xamzRequestId;

    public void setContentLength(String contentLength) {
        this.contentLength = Long.parseLong(contentLength);
    }

    public long contentLength() {
        return this.contentLength;
    }

    public void setContentType(String contentType) {
        this.contentType = contentType;
    }

    public String contentType() {
        return this.contentType;
    }

    public void setDate(String date) {
        this.date = DateFormat.HTTP_HEADER_DATE_FORMAT.parseDateTime(date);
    }

    public Date date() {
        return this.date.toDate();
    }

    public void setEtag(String etag) {
        this.etag = etag.replaceAll("\"", "");
    }

    public String etag() {
        return this.etag;
    }

    public void setLastModified(String lastModified) {
        this.lastModified = DateFormat.HTTP_HEADER_DATE_FORMAT.parseDateTime(lastModified);
    }

    public Date lastModified() {
        return this.lastModified.toDate();
    }

    public void setServer(String server) {
        this.server = server;
    }

    public String server() {
        return this.server;
    }

    public void setStatusCode(String statusCode) {
        this.statusCode = statusCode;
    }

    public String statusCode() {
        return this.statusCode;
    }

    public void setTransferEncoding(String transferEncoding) {
        this.transferEncoding = transferEncoding;
    }

    public String transferEncoding() {
        return this.transferEncoding;
    }

    public void setXamzBucketRegion(String xamzBucketRegion) {
        this.xamzBucketRegion = xamzBucketRegion;
    }

    public String xamzBucketRegion() {
        return this.xamzBucketRegion;
    }

    public void setXamzId2(String xamzId2) {
        this.xamzId2 = xamzId2;
    }

    public String xamzId2() {
        return this.xamzId2;
    }

    public void setXamzRequestId(String xamzRequestId) {
        this.xamzRequestId = xamzRequestId;
    }

    public String xamzRequestId() {
        return this.xamzRequestId;
    }
}

