/*
 * Decompiled with CFR 0.152.
 */
package ome.xml.model.enums.handlers;

import java.util.Hashtable;
import ome.xml.model.enums.Correction;
import ome.xml.model.enums.Enumeration;
import ome.xml.model.enums.EnumerationException;
import ome.xml.model.enums.handlers.IEnumerationHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CorrectionEnumHandler
implements IEnumerationHandler {
    private static final Logger LOGGER = LoggerFactory.getLogger(CorrectionEnumHandler.class);
    private static final Hashtable<String, String> patterns = CorrectionEnumHandler.makePatterns();

    private static Hashtable<String, String> makePatterns() {
        Hashtable<String, String> p = new Hashtable<String, String>();
        p.put("^\\s*UV\\s*", "UV");
        p.put("^\\s*PlanApo\\s*", "PlanApo");
        p.put("^\\s*PlanFluor\\s*", "PlanFluor");
        p.put("^\\s*SuperFluor\\s*", "SuperFluor");
        p.put("^\\s*VioletCorrected\\s*", "VioletCorrected");
        p.put("^\\s*Achro\\s*", "Achro");
        p.put("^\\s*Achromat\\s*", "Achromat");
        p.put("^\\s*Fluor\\s*", "Fluor");
        p.put("^\\s*Fl\\s*", "Fl");
        p.put("^\\s*Fluar\\s*", "Fluar");
        p.put("^\\s*Neofluar\\s*", "Neofluar");
        p.put("^\\s*Fluotar\\s*", "Fluotar");
        p.put("^\\s*Apo\\s*", "Apo");
        p.put("^\\s*PlanNeofluar\\s*", "PlanNeofluar");
        p.put("^\\s*Other\\s*", "Other");
        p.put(".*Pl.*Apo.*", "PlanApo");
        p.put(".*Pl.*Flu.*", "PlanFluor");
        p.put("^\\s*Vio.*Corr.*", "VioletCorrected");
        p.put(".*S.*Flu.*", "SuperFluor");
        p.put(".*Neo.*flu.*", "Neofluar");
        p.put(".*Flu.*tar.*", "Fluotar");
        p.put(".*Fluo.*", "Fluor");
        p.put(".*Flua.*", "Fluar");
        p.put("^\\s*Apo.*", "Apo");
        return p;
    }

    @Override
    public Enumeration getEnumeration(String value) throws EnumerationException {
        if (value != null) {
            for (String pattern : patterns.keySet()) {
                if (!value.toLowerCase().matches(pattern.toLowerCase())) continue;
                String v = patterns.get(pattern);
                return Correction.fromString(v);
            }
        }
        LOGGER.warn("Unknown {} value '{}' will be stored as \"Other\"", (Object)"Correction", (Object)value);
        return Correction.OTHER;
    }

    @Override
    public Class<? extends Enumeration> getEntity() {
        return Correction.class;
    }
}

