/*
 * Decompiled with CFR 0.152.
 */
package plugins.nchenouard.particletracking.MHTracker;

import Jama.Matrix;
import java.util.LinkedList;
import plugins.nchenouard.particletracking.MHTracker.Association;
import plugins.nchenouard.particletracking.MHTracker.Family;
import plugins.nchenouard.particletracking.MHTracker.HMMMHTracker;
import plugins.nchenouard.particletracking.MHTracker.Hypothesis;
import plugins.nchenouard.particletracking.VirtualSpot;
import plugins.nchenouard.particletracking.filtering.Predictor;
import plugins.nchenouard.spot.Spot;

public class MHTrack2s {
    Predictor predictor;
    double likelihood;
    double associationLikelihood;
    double score;
    double bestScore = -1.7976931348623157E308;
    Family family = null;
    Association association;
    LinkedList<MHTrack2s> followingSegments = new LinkedList();
    MHTrack2s precedingSegment = null;
    HMMMHTracker tracker;
    Hypothesis hypothesis = null;
    double p00 = 1.0;
    double p01 = 0.0;
    public static final double QUIA_P10 = 0.025;
    public static final double QUIA_P11 = 0.975;
    public static final double QUIA_Pc = 0.8;
    public static final double QUIA_Pt = 0.05;
    public static final double PAMI_P10 = 0.15;
    public static final double PAMI_P11 = 0.85;
    public static final double PAMI_Pc = 0.8;
    public static final double PAMI_Pt = 0.05;
    public static double INIT_P10 = 0.15;
    public static double INIT_P11 = 0.85;
    public static double INIT_Pc = 0.8;
    public static double INIT_Pt = 0.05;
    protected double p10 = INIT_P10;
    protected double p11 = INIT_P11;
    protected double pc = INIT_Pc;
    protected double pt = INIT_Pt;
    protected boolean confirmed = false;
    protected boolean terminated = false;
    protected double pObs;
    protected double pPredObs;
    boolean verbose = false;

    public void println(String str) {
        if (this.verbose) {
            System.out.println(str);
        }
    }

    public MHTrack2s(double p1_0, HMMMHTracker tracker, Predictor predictor, Association association, Family family) {
        this.pObs = p1_0;
        this.pPredObs = this.p11 * this.pObs + this.p01 * (1.0 - this.pObs);
        if (this.pObs > this.pc) {
            this.confirmed = true;
        } else if (this.pObs < this.pt) {
            this.terminated = true;
        }
        this.predictor = predictor;
        this.association = association;
        predictor.initWithFirstElement(association.spot, association.t);
        this.precedingSegment = null;
        this.family = family;
        this.tracker = tracker;
        this.associationLikelihood = this.likelihood = 1.0 / tracker.volume;
        this.score = Math.log(this.likelihood);
        association.setNewScore(this.score);
    }

    protected MHTrack2s() {
    }

    public MHTrack2s copy() {
        MHTrack2s mtrack = new MHTrack2s();
        mtrack.predictor = this.predictor.copy();
        mtrack.likelihood = this.likelihood;
        mtrack.associationLikelihood = this.associationLikelihood;
        mtrack.score = this.score;
        mtrack.family = this.family;
        mtrack.association = this.association;
        mtrack.precedingSegment = this.precedingSegment;
        mtrack.tracker = this.tracker;
        mtrack.hypothesis = this.hypothesis;
        mtrack.confirmed = this.confirmed;
        mtrack.terminated = this.terminated;
        mtrack.pObs = this.pObs;
        mtrack.pPredObs = this.pPredObs;
        mtrack.p00 = this.p00;
        mtrack.p10 = this.p10;
        mtrack.p01 = this.p01;
        mtrack.p11 = this.p11;
        return mtrack;
    }

    public MHTrack2s createPotentialTrackWithPrediction(int t) {
        MHTrack2s trk = this.copy();
        trk.precedingSegment = this;
        trk.followingSegments.clear();
        trk.hypothesis = null;
        this.followingSegments.add(trk);
        trk.prolongate(t);
        return trk;
    }

    public MHTrack2s createPotentialTrack(Association a, int t) {
        MHTrack2s trk = this.copy();
        trk.precedingSegment = this;
        trk.followingSegments.clear();
        trk.hypothesis = null;
        this.followingSegments.add(trk);
        trk.associate(a, t);
        return trk;
    }

    public void applyLastAssociation() {
        if (!this.association.isPrediction) {
            this.predictor.update(this.association.state, this.association.t);
        } else {
            this.predictor.update((Matrix)null, this.association.t);
        }
    }

    public boolean inGate(Association a) {
        double dist = this.predictor.normalizedInnovation(a.state);
        return dist <= this.tracker.gateFactor;
    }

    public double kineticLikelihood(Spot s, boolean gated, double gateFactor) {
        double kineticL = this.predictor.likelihood(s, gated, gateFactor);
        return kineticL;
    }

    public double falseAlarmLikelihood() {
        return this.tracker.pFA;
    }

    public void associate(Association a, int t) {
        this.association = a;
        double kL = this.tracker.pDpG * this.kineticLikelihood(a.spot, true, this.tracker.gateFactor);
        double faL = this.falseAlarmLikelihood();
        this.associationLikelihood = kL * this.pPredObs + faL * (1.0 - this.pPredObs);
        this.likelihood *= this.associationLikelihood;
        double s = Math.log(this.associationLikelihood);
        this.score += s;
        a.setNewScore(s);
        this.println("associate pobs " + this.pObs + " | " + kL * this.pPredObs / this.associationLikelihood);
        this.pObs = kL * this.pPredObs / this.associationLikelihood;
        this.pPredObs = this.p11 * this.pObs + this.p01 * (1.0 - this.pObs);
        if (this.pObs > this.pc) {
            this.confirmed = true;
        }
        if (this.pObs < this.pt) {
            this.terminated = true;
        }
    }

    public void prolongate(int t) {
        VirtualSpot pred = this.predictor.getCurrentPredictedStateAsSpot();
        this.association = new Association(null, pred, true, t, 0.0);
        double kL = 1.0 - this.tracker.pDpG;
        double faL = 1.0;
        this.associationLikelihood = kL * this.pPredObs + faL * (1.0 - this.pPredObs);
        this.likelihood *= this.associationLikelihood;
        this.score += Math.log(this.associationLikelihood);
        this.println("prolongate pobs " + this.pObs + " | " + kL * this.pPredObs / this.associationLikelihood);
        this.pObs = kL * this.pPredObs / this.associationLikelihood;
        this.pPredObs = this.p11 * this.pObs + this.p01 * (1.0 - this.pObs);
        if (this.pObs > this.pc) {
            this.confirmed = true;
        }
        if (this.pObs < this.pt) {
            this.terminated = true;
        }
    }

    public void resetBestScore() {
        this.bestScore = -1.7976931348623157E308;
    }
}

