/*
 * Decompiled with CFR 0.152.
 */
package plugins.nchenouard.particletracking.filtering;

import Jama.EigenvalueDecomposition;
import Jama.Matrix;
import java.awt.geom.AffineTransform;
import java.awt.geom.Area;
import java.awt.geom.Ellipse2D;
import java.util.ArrayList;
import plugins.nchenouard.particletracking.VirtualSpot;
import plugins.nchenouard.particletracking.filtering.KF3dDirected;
import plugins.nchenouard.particletracking.filtering.KF3dRandomWalk;
import plugins.nchenouard.particletracking.filtering.LikelihoodMap;
import plugins.nchenouard.particletracking.filtering.Predictor;
import plugins.nchenouard.particletracking.filtering.Predictor2D;
import plugins.nchenouard.spot.Spot;

public abstract class KalmanFilter
implements Predictor {
    protected static final double _2PI = Math.PI * 2;
    protected Matrix x_pre;
    protected Matrix x_est;
    protected Matrix P_pre;
    protected Matrix P_est;
    protected Matrix z_pre;
    protected Matrix z_err;
    protected Matrix F;
    protected Matrix H;
    protected Matrix Q;
    protected Matrix R;
    protected Matrix S;
    protected Matrix S_1;
    protected Matrix W;
    protected Matrix Q0;
    boolean updateCovariances = true;
    protected int t0 = 0;
    protected int t = 0;

    public KalmanFilter() {
    }

    public KalmanFilter(Matrix F, Matrix H, Matrix Q, Matrix R) {
        if (F.getRowDimension() != F.getColumnDimension()) {
            throw new IllegalArgumentException("F (transition) is not square");
        }
        if (Q.getRowDimension() != Q.getColumnDimension()) {
            throw new IllegalArgumentException("Q (transition noise covariance) is not square");
        }
        if (R.getRowDimension() != R.getColumnDimension()) {
            throw new IllegalArgumentException("R (measurement noise covariance) is not square");
        }
        if (F.getRowDimension() != Q.getRowDimension()) {
            throw new IllegalArgumentException("row dimension of F is not the same as row dimension of Q");
        }
        if (F.getColumnDimension() != Q.getColumnDimension()) {
            throw new IllegalArgumentException("column dimension of F is not the same as column dimension of Q");
        }
        if (F.getRowDimension() != H.getColumnDimension()) {
            throw new IllegalArgumentException("row dimension of F is not the same as column dimension of H");
        }
        if (H.getRowDimension() != R.getRowDimension()) {
            throw new IllegalArgumentException("column dimension of H is not the same as column dimension of R");
        }
        this.F = F;
        this.H = H;
        this.Q = Q;
        this.R = R;
    }

    @Override
    public abstract Matrix buildMeasurementMatrix(Spot var1);

    public Matrix buildPredCovMatrix(int t) {
        if (t > this.t) {
            Matrix P = this.F.times(this.P_est).times(this.F.transpose()).plus(this.Q);
            for (int i = this.t + 1; i < t; ++i) {
                P = this.F.times(P).times(this.F.transpose()).plus(this.Q);
            }
            return P;
        }
        if (t == this.t) {
            return this.P_pre;
        }
        throw new IllegalArgumentException("cannot get past prediction in Kalman Filter");
    }

    private Area builtEllipse(Matrix z_pre, Matrix S, double gateFactor) {
        S = S.getMatrix(0, 1, 0, 1);
        EigenvalueDecomposition evd = S.eig();
        Matrix D = evd.getD();
        Matrix V = evd.getV();
        double norm1 = Math.sqrt(Math.pow(V.get(0, 0), 2.0) + Math.pow(V.get(1, 0), 2.0));
        double norm2 = Math.sqrt(Math.pow(V.get(0, 1), 2.0) + Math.pow(V.get(1, 1), 2.0));
        double cos = V.get(0, 0) / norm1;
        double sin = V.get(1, 0) / norm2;
        double alpha = sin >= 0.0 ? Math.acos(cos) : -Math.acos(cos);
        int zx = (int)z_pre.get(0, 0);
        int zy = (int)z_pre.get(1, 0);
        int l1 = (int)(gateFactor * Math.sqrt(D.get(0, 0)));
        int l2 = (int)(gateFactor * Math.sqrt(D.get(1, 1)));
        AffineTransform atx = new AffineTransform();
        atx.rotate(alpha, zx, zy);
        atx.translate(-l1, -l2);
        Area gate = new Area(new Ellipse2D.Double(zx, zy, l1 * 2, l2 * 2)).createTransformedArea(atx);
        return gate;
    }

    @Override
    public Object clone() {
        KalmanFilter newKf = (KalmanFilter)this.copyInit();
        if (this.x_pre != null) {
            newKf.x_pre = (Matrix)this.x_pre.clone();
        }
        if (this.x_est != null) {
            newKf.x_est = (Matrix)this.x_est.clone();
        }
        if (this.P_pre != null) {
            newKf.P_pre = (Matrix)this.P_pre.clone();
        }
        if (this.P_est != null) {
            newKf.P_est = (Matrix)this.P_est.clone();
        }
        if (this.z_pre != null) {
            newKf.z_pre = (Matrix)this.z_pre.clone();
        }
        if (this.z_err != null) {
            newKf.z_err = (Matrix)this.z_err.clone();
        }
        if (this.F != null) {
            newKf.F = (Matrix)this.F.clone();
        }
        if (this.H != null) {
            newKf.H = (Matrix)this.H.clone();
        }
        if (this.Q != null) {
            newKf.Q = (Matrix)this.Q.clone();
        }
        if (this.R != null) {
            newKf.R = (Matrix)this.R.clone();
        }
        if (this.S != null) {
            newKf.S = (Matrix)this.S.clone();
        }
        if (this.S_1 != null) {
            newKf.S_1 = (Matrix)this.S_1.clone();
        }
        if (this.W != null) {
            newKf.W = (Matrix)this.W.clone();
        }
        if (this.Q0 != null) {
            newKf.Q0 = (Matrix)this.Q0.clone();
        }
        return newKf;
    }

    protected void copyMyDataInKF(KalmanFilter kf) {
        kf.setTrackingCovariances(this.Q0.copy());
        if (this.x_pre != null) {
            kf.x_pre = this.x_pre.copy();
        }
        if (this.x_est != null) {
            kf.x_est = this.x_est.copy();
        }
        if (this.P_pre != null) {
            kf.P_pre = this.P_pre.copy();
        }
        if (this.P_est != null) {
            kf.P_est = this.P_est.copy();
        }
        if (this.z_pre != null) {
            kf.z_pre = this.z_pre.copy();
        }
        if (this.z_err != null) {
            kf.z_err = this.z_err.copy();
        }
        if (this.F != null) {
            kf.F = this.F.copy();
        }
        if (this.H != null) {
            kf.H = this.H.copy();
        }
        if (this.Q != null) {
            kf.Q = this.Q.copy();
        }
        if (this.R != null) {
            kf.R = this.R.copy();
        }
        if (this.S != null) {
            kf.S = this.S.copy();
        }
        if (this.S_1 != null) {
            kf.S_1 = this.S_1.copy();
        }
        if (this.W != null) {
            kf.W = this.W.copy();
        }
        if (this.Q0 != null) {
            kf.Q0 = this.Q0.copy();
        }
        kf.setUpdateCovariances(this.updateCovariances);
        kf.t = this.t;
    }

    @Override
    public void correct(Matrix z) {
        if (z.getRowDimension() != this.H.getRowDimension()) {
            throw new IllegalArgumentException("row dimension of z (is " + z.getRowDimension() + " should be " + this.H.getRowDimension() + ") is not the same as row dimension of H");
        }
        if (z.getColumnDimension() != 1) {
            throw new IllegalArgumentException("z is not a vector");
        }
        this.z_err = z.minus(this.z_pre);
        this.x_est = this.x_pre.plus(this.W.times(this.z_err));
        this.P_est = this.P_pre.minus(this.W.times(this.S).times(this.W.transpose()));
        this.covupdate();
    }

    protected void covupdate() {
        if (this.updateCovariances) {
            double a = 0.15;
            double b = 0.75;
            double c = 0.1;
            try {
                if (this.x_est.minus(this.x_pre).normF() != 0.0) {
                    this.Q = this.Q.times(b).plus(this.x_est.minus(this.x_pre).times(this.x_est.minus(this.x_pre).transpose()).times(a)).plus(this.Q0.times(c));
                }
                double maxIncrease = 2.0;
                double maxDecrease = 0.5;
                for (int i = 0; i < this.Q.getColumnDimension(); ++i) {
                    for (int j = 0; j < this.Q.getRowDimension(); ++j) {
                        this.Q.set(i, j, Math.min(this.Q0.get(i, j) * maxIncrease, Math.max(this.Q0.get(i, j) * maxDecrease, this.Q.get(i, j))));
                    }
                }
            }
            catch (RuntimeException e) {
                System.out.println("error in KalmanFiter.covupdate:");
                if (this.x_est == null) {
                    System.out.println("xest null");
                }
                if (this.x_pre == null) {
                    System.out.println("xpre null");
                }
                if (this.Q == null) {
                    System.out.println("Q null");
                }
                if (this.Q0 == null) {
                    System.out.println("Q0 null");
                }
                e.printStackTrace();
            }
        }
    }

    @Override
    public double[][] getCurrentCubicGate(double gateFactor) {
        double[][] bounds = new double[2][2];
        bounds[0][0] = this.z_pre.get(0, 0) - gateFactor * Math.sqrt(this.S.get(0, 0));
        bounds[0][1] = this.z_pre.get(0, 0) + gateFactor * Math.sqrt(this.S.get(0, 0));
        bounds[1][0] = this.z_pre.get(1, 0) - gateFactor * Math.sqrt(this.S.get(1, 1));
        bounds[1][1] = this.z_pre.get(1, 0) + gateFactor * Math.sqrt(this.S.get(1, 1));
        return bounds;
    }

    @Override
    public Matrix getCurrentEstimatedState() {
        return this.x_est;
    }

    @Override
    public ArrayList<Area> getCurrentGate(double gateFactor) {
        ArrayList<Area> gates = new ArrayList<Area>();
        gates.add(this.builtEllipse(this.z_pre, this.S, gateFactor));
        return gates;
    }

    @Override
    public Matrix getCurrentPredictedMeasurement() {
        return this.z_pre;
    }

    @Override
    public Matrix getCurrentPredictedState() {
        return this.x_pre;
    }

    @Override
    public Matrix getCurrentStateErrorCovariance() {
        return this.P_est;
    }

    public Matrix getMeasurementErrorCovariance(int t) {
        return this.H.times(this.getStateErrorCovariance(t)).times(this.H.transpose()).plus(this.R);
    }

    public LikelihoodMap getLikelihoodMap(boolean gated, double gateFactor, int t, int width, int height, int depth) {
        if (t <= this.t) {
            throw new IllegalArgumentException("cannot get past prediction in Kalman Filter");
        }
        if (this instanceof Predictor2D) {
            Predictor2D p2D = (Predictor2D)((Object)this);
            double xPred = p2D.getXCoordPredicted();
            double yPred = p2D.getYCoordPredicted();
            Matrix covMeas = this.getMeasurementErrorCovariance(t);
            int minX = 0;
            int maxX = width - 1;
            int minY = 0;
            int maxY = height - 1;
            if (gated) {
                minX = (int)Math.max(xPred - gateFactor * Math.sqrt(covMeas.get(0, 0)), (double)minX);
                maxX = (int)Math.min(Math.floor(xPred + gateFactor * Math.sqrt(covMeas.get(0, 0))) + 1.0, (double)maxX);
                minY = (int)Math.max(yPred - gateFactor * Math.sqrt(covMeas.get(1, 1)), (double)minY);
                maxY = (int)Math.min(Math.floor(yPred + gateFactor * Math.sqrt(covMeas.get(1, 1))) + 1.0, (double)maxY);
            }
            LikelihoodMap map = new LikelihoodMap(width, height);
            for (int y = minY; y <= maxY; ++y) {
                for (int x = minX; x <= maxX; ++x) {
                    Spot s = new Spot((double)x, (double)y, 0.0);
                    double l = this.likelihood(s, false, 4.0);
                    map.setLikelihood(x, y, l);
                }
            }
            return map;
        }
        if (this instanceof KF3dRandomWalk || this instanceof KF3dDirected) {
            return null;
        }
        throw new IllegalArgumentException("invalid KalmanFilter type to invoke getLikelihoodMap");
    }

    public LikelihoodMap getLikelihoodMap(double gateFactor, int t) {
        if (t <= this.t) {
            throw new IllegalArgumentException("cannot get past prediction in Kalman Filter");
        }
        if (this instanceof Predictor2D) {
            Predictor2D p2D = (Predictor2D)((Object)this);
            double xPred = p2D.getXCoordPredicted();
            double yPred = p2D.getYCoordPredicted();
            Matrix covMeas = this.getMeasurementErrorCovariance(t);
            int minX = (int)(xPred - gateFactor * Math.sqrt(covMeas.get(0, 0)));
            int maxX = (int)Math.floor(xPred + gateFactor * Math.sqrt(covMeas.get(0, 0)));
            int minY = (int)(yPred - gateFactor * Math.sqrt(covMeas.get(1, 1)));
            int maxY = (int)(Math.floor(yPred + gateFactor * Math.sqrt(covMeas.get(1, 1))) + 1.0);
            LikelihoodMap map = new LikelihoodMap(maxX - minX + 1, maxY - minY + 1, minX, minY);
            for (int y = minY; y <= maxY; ++y) {
                for (int x = minX; x <= maxX; ++x) {
                    Spot s = new Spot((double)x, (double)y, 0.0);
                    double l = this.likelihood(s, false, 4.0);
                    map.setLikelihood(x, y, l);
                }
            }
            return map;
        }
        if (this instanceof KF3dRandomWalk || this instanceof KF3dDirected) {
            return null;
        }
        throw new IllegalArgumentException("invalid KalmanFilter type to invoke getLikelihoodMap");
    }

    @Override
    public Matrix getPredictedState(int t) {
        if (t > this.t) {
            Matrix pred = this.F.times(this.x_est);
            for (int i = this.t + 1; i < t; ++i) {
                pred = this.F.times(pred);
            }
            return pred;
        }
        if (t == this.t) {
            return this.x_pre;
        }
        throw new IllegalArgumentException("cannot get past prediction in Kalman Filter");
    }

    @Override
    public double getTotalGateLikelihood(boolean gated, double gateFactor) {
        if (gated) {
            if (gateFactor < 1.0) {
                return 0.5;
            }
            if (gateFactor < 2.0) {
                return 0.7;
            }
            if (gateFactor < 3.0) {
                return 0.85;
            }
            if (gateFactor < 4.0) {
                return 0.95;
            }
            if (gateFactor < 5.0) {
                return 0.99;
            }
            if (gateFactor < 8.0) {
                return 0.999;
            }
            return 1.0;
        }
        return 1.0;
    }

    @Override
    public void init(Matrix x0, Matrix P0) {
        if (x0.getColumnDimension() != 1) {
            throw new IllegalArgumentException("x0 is not a vector");
        }
        if (x0.getRowDimension() != this.F.getRowDimension()) {
            throw new IllegalArgumentException("row dimension of x0 (is " + x0.getRowDimension() + " should be " + this.F.getRowDimension() + ") is not the same as row dimension of F");
        }
        if (P0.getRowDimension() != this.F.getColumnDimension()) {
            throw new IllegalArgumentException("row dimension of P0 (is " + P0.getRowDimension() + " should be " + this.F.getColumnDimension() + ") is not the same as column dimension of F");
        }
        this.x_est = x0;
        this.P_est = P0;
        this.predict();
    }

    public boolean initialized() {
        return this.x_est != null && this.P_est != null;
    }

    abstract Matrix buildX0(Matrix var1);

    abstract Matrix getP0();

    @Override
    public void initWithFirstElement(Matrix firstElement, int t) {
        this.t = t;
        this.t0 = t;
        Matrix x0 = this.buildX0(firstElement);
        Matrix P0 = this.getP0();
        this.init(x0, P0);
    }

    @Override
    public void initWithFirstElement(Spot spot, int t) {
        this.initWithFirstElement(this.buildMeasurementMatrix(spot), t);
    }

    @Override
    public double likelihood(Matrix z, boolean gated, double gateFactor) {
        Matrix z_err = z.minus(this.z_pre);
        if (gated) {
            for (int i = 0; i < z_err.getRowDimension(); ++i) {
                if (!(Math.abs(z_err.get(i, 0)) > gateFactor * Math.sqrt(this.S.get(i, i)))) continue;
                return 0.0;
            }
        }
        double d2 = this.mahalanobis(z);
        if (gated && d2 > Math.pow(gateFactor, 2.0)) {
            return 0.0;
        }
        double d1 = 1.0 / Math.sqrt(this.S.times(Math.PI * 2).det());
        return d1 * Math.exp(-0.5 * d2);
    }

    @Override
    public double likelihood(Spot s, boolean gated, double gateFactor) {
        Matrix z = this.buildMeasurementMatrix(s);
        return this.likelihood(z, gated, gateFactor);
    }

    public double likelihood(Spot s, boolean gated, double gateFactor, int t) {
        if (t >= this.t) {
            Matrix z = this.buildMeasurementMatrix(s);
            Matrix predState = this.getPredictedState(t);
            Matrix predMeasurement = this.H.times(predState);
            Matrix z_err = z.minus(predMeasurement);
            Matrix covPred = this.buildPredCovMatrix(t);
            Matrix covMeas = this.H.times(covPred).times(this.H.transpose()).plus(this.R);
            if (gated) {
                for (int i = 0; i < z_err.getRowDimension(); ++i) {
                    if (!(Math.abs(z_err.get(i, 0)) > gateFactor * Math.sqrt(covMeas.get(i, i)))) continue;
                    return 0.0;
                }
            }
            double d2 = z_err.transpose().times(covMeas.inverse()).times(z_err).get(0, 0);
            if (gated && d2 > Math.pow(gateFactor, 2.0)) {
                return 0.0;
            }
            double d1 = 1.0 / Math.sqrt(covMeas.times(Math.PI * 2).det());
            return d1 * Math.exp(-0.5 * d2);
        }
        throw new IllegalArgumentException("cannot get past prediction in Kalman Filter");
    }

    @Override
    public double loglikelihood(Matrix z) {
        Matrix z_err = z.minus(this.z_pre);
        return -(Math.log(this.S.times(Math.PI * 2).det()) + z_err.transpose().times(this.S_1).times(z_err).get(0, 0)) * 0.5;
    }

    @Override
    public double loglikelihood(Spot ds) {
        Matrix z = this.buildMeasurementMatrix(ds);
        return this.loglikelihood(z);
    }

    @Override
    public double loglikelihoodOfState(Matrix x) {
        Matrix x_err = x.minus(this.x_pre);
        Matrix P_1 = this.P_pre.inverse();
        return -(Math.log(this.P_pre.times(Math.PI * 2).det()) + x_err.transpose().times(P_1).times(x_err).get(0, 0)) * 0.5;
    }

    @Override
    public double likelihoodOfState(Matrix x) {
        Matrix x_err = x.minus(this.x_pre);
        Matrix P_1 = this.P_pre.inverse();
        return Math.exp(x_err.transpose().times(P_1).times(x_err).get(0, 0) / 2.0) / Math.sqrt(this.P_pre.times(Math.PI * 2).det());
    }

    @Override
    public double likelihoodOfPredictedState() {
        return 1.0 / Math.sqrt(this.P_pre.times(Math.PI * 2).det());
    }

    protected double mahalanobis(Matrix z) {
        Matrix z_err = z.minus(this.z_pre);
        return z_err.transpose().times(this.S_1).times(z_err).get(0, 0);
    }

    protected double mahalanobis(Spot s) {
        Matrix z = this.buildMeasurementMatrix(s);
        return this.mahalanobis(z);
    }

    @Override
    public double getMinLikelihoodInGate(double gateFactor, int t) {
        Matrix covPred = this.buildPredCovMatrix(t);
        Matrix covMeas = this.H.times(covPred).times(this.H.transpose()).plus(this.R);
        double d2 = Math.pow(gateFactor, 2.0);
        double d1 = 1.0 / Math.sqrt(covMeas.times(Math.PI * 2).det());
        return d1 * Math.exp(-0.5 * d2);
    }

    @Override
    public double getCurrentMinLikelihoodInGate(double gateFactor) {
        double d2 = Math.pow(gateFactor, 2.0);
        double d1 = 1.0 / Math.sqrt(this.S.times(Math.PI * 2).det());
        return d1 * Math.exp(-0.5 * d2);
    }

    @Override
    public double normalizedInnovation(Matrix m) {
        return this.mahalanobis(m);
    }

    @Override
    public double normalizedInnovation(Spot s) {
        return this.mahalanobis(s);
    }

    @Override
    public void predict() {
        this.x_pre = this.F.times(this.x_est);
        this.z_pre = this.H.times(this.x_pre);
        this.P_pre = this.F.times(this.P_est).times(this.F.transpose()).plus(this.Q);
        this.S = this.H.times(this.P_pre).times(this.H.transpose()).plus(this.R);
        this.S_1 = this.S.inverse();
        this.W = this.P_pre.times(this.H.transpose()).times(this.S_1);
    }

    @Override
    public void predict(int t) {
        if (t == this.t) {
            this.predict();
        } else if (t > this.t) {
            int i;
            this.x_pre = this.F.times(this.x_est);
            for (i = this.t + 1; i < t; ++i) {
                this.x_pre = this.F.times(this.x_pre);
            }
            this.z_pre = this.H.times(this.x_pre);
            this.P_pre = this.F.times(this.P_est).times(this.F.transpose()).plus(this.Q);
            for (i = this.t + 1; i < t; ++i) {
                this.P_pre = this.F.times(this.P_pre).times(this.F.transpose()).plus(this.Q);
            }
            this.S = this.H.times(this.P_pre).times(this.H.transpose()).plus(this.R);
            this.S_1 = this.S.inverse();
            this.W = this.P_pre.times(this.H.transpose()).times(this.S_1);
        } else {
            throw new IllegalArgumentException("cannot predict in the past in Kalman Filter");
        }
    }

    @Override
    public abstract void setTrackingCovariances(double[] var1);

    public void setTrackingCovariances(Matrix Q0) {
        this.Q = Q0;
        this.Q0 = Q0;
    }

    public void setUpdateCovariances(boolean update) {
        this.updateCovariances = update;
    }

    @Override
    public void update(Matrix z, int t) {
        if (z != null) {
            this.correct(z);
            this.t = t;
        }
        this.predict(t);
    }

    @Override
    public void update(Spot s, int t) {
        Matrix z = this.buildMeasurementMatrix(s);
        this.update(z, t);
    }

    @Override
    public Matrix getEstimatedState(int t) {
        return null;
    }

    @Override
    public Matrix getPredictedMeasurement(int t) {
        if (this.t == t) {
            return this.z_pre;
        }
        if (t > this.t) {
            Matrix pred = this.getPredictedState(t);
            return this.H.times(pred);
        }
        throw new IllegalArgumentException("cannot get past predicted measurement in Kalman Filter");
    }

    @Override
    public VirtualSpot getPredictedStateAsSpot(int t) {
        return null;
    }

    @Override
    public Matrix getStateErrorCovariance(int t) {
        Matrix Ppre = this.F.times(this.P_est).times(this.F.transpose()).plus(this.Q);
        for (int i = this.t + 1; i < t; ++i) {
            Ppre = this.F.times(Ppre).times(this.F.transpose()).plus(this.Q);
        }
        return Ppre;
    }

    @Override
    public ArrayList<Area> getGates(double gateFactor, int i) {
        return null;
    }

    @Override
    public void updateTime(int t) {
        this.t = t;
    }
}

