/*
 * Decompiled with CFR 0.152.
 */
package icy.util;

import icy.file.FileUtil;
import icy.network.AuthenticationInfo;
import icy.network.NetworkUtil;
import icy.network.URLUtil;
import icy.system.IcyExceptionHandler;
import icy.type.DataType;
import icy.type.collection.array.ArrayUtil;
import icy.util.StringUtil;
import icy.util.ZipUtil;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringReader;
import java.io.StringWriter;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.ArrayList;
import java.util.zip.DataFormatException;
import java.util.zip.Deflater;
import java.util.zip.Inflater;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.DocumentType;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class XMLUtil {
    public static final String FILE_EXTENSION = "xml";
    public static final String FILE_DOT_EXTENSION = ".xml";
    public static final String NODE_ROOT_NAME = "root";
    private static final String ATTR_NAME_NAME = "name";
    private static final String ATTR_VALUE_NAME = "value";
    private static DocumentBuilderFactory docBuilderFactory = DocumentBuilderFactory.newInstance();
    private static TransformerFactory transformerFactory = TransformerFactory.newInstance();
    private static Deflater deflater = new Deflater(2);
    private static Inflater inflater = new Inflater();

    public static DocumentBuilder createDocumentBuilder() {
        try {
            return docBuilderFactory.newDocumentBuilder();
        }
        catch (ParserConfigurationException e) {
            e.printStackTrace();
            return null;
        }
    }

    public static Transformer createTransformer() {
        Transformer result;
        try {
            result = transformerFactory.newTransformer();
        }
        catch (TransformerConfigurationException e) {
            IcyExceptionHandler.showErrorMessage(e, true, true);
            return null;
        }
        result.setOutputProperty("method", FILE_EXTENSION);
        result.setOutputProperty("encoding", "ISO-8859-1");
        result.setOutputProperty("encoding", "UTF-8");
        result.setOutputProperty("omit-xml-declaration", "yes");
        result.setOutputProperty("indent", "yes");
        return result;
    }

    public static Transformer createTransformerSafe() throws TransformerConfigurationException {
        Transformer result = transformerFactory.newTransformer();
        result.setOutputProperty("method", FILE_EXTENSION);
        result.setOutputProperty("encoding", "ISO-8859-1");
        result.setOutputProperty("encoding", "UTF-8");
        result.setOutputProperty("omit-xml-declaration", "yes");
        result.setOutputProperty("indent", "yes");
        return result;
    }

    public static Document createDocument(boolean createRoot) {
        DocumentBuilder docBuilder = XMLUtil.createDocumentBuilder();
        if (docBuilder == null) {
            return null;
        }
        Document result = docBuilder.newDocument();
        if (createRoot) {
            XMLUtil.createRootElement(result);
        }
        return result;
    }

    public static Document createDocument(String xmlString) throws SAXException, IOException {
        DocumentBuilder docBuilder = XMLUtil.createDocumentBuilder();
        if (docBuilder == null) {
            return null;
        }
        return docBuilder.parse(new InputSource(new StringReader(XMLUtil.filterString(xmlString))));
    }

    @Deprecated
    public static Document getDocument(String xmlString) {
        DocumentBuilder docBuilder = XMLUtil.createDocumentBuilder();
        if (docBuilder == null) {
            return null;
        }
        try {
            return docBuilder.parse(new InputSource(new StringReader(XMLUtil.filterString(xmlString))));
        }
        catch (Exception e) {
            IcyExceptionHandler.showErrorMessage(e, true);
            return XMLUtil.createDocument(false);
        }
    }

    @Deprecated
    public static Document getDocumentSafe(String xmlString) throws SAXException, IOException {
        return XMLUtil.createDocument(xmlString);
    }

    public static Document loadDocument(String path) {
        return XMLUtil.loadDocument(path, null, false);
    }

    public static Document loadDocument(String path, boolean showError) {
        return XMLUtil.loadDocument(path, null, showError);
    }

    public static Document loadDocument(String path, AuthenticationInfo auth, boolean showError) {
        if (StringUtil.isEmpty(path)) {
            if (showError) {
                System.err.println("XMLUtil.loadDocument('" + path + "') error: empty path !");
            }
            return null;
        }
        URL url = URLUtil.getURL(path);
        if (url != null) {
            return XMLUtil.loadDocument(url, auth, showError);
        }
        return XMLUtil.loadDocument(new File(path), showError);
    }

    public static Document loadDocument(File f) {
        return XMLUtil.loadDocument(f, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Document loadDocument(File f, boolean showError) {
        Document document;
        if (f == null || !f.exists()) {
            if (showError) {
                System.err.println("XMLUtil.loadDocument('" + f + "') error: file not found !");
            }
            return null;
        }
        FileInputStream is = new FileInputStream(f);
        try {
            document = XMLUtil.loadDocument(is);
        }
        catch (Throwable throwable) {
            try {
                try {
                    is.close();
                }
                catch (Exception exception) {
                    // empty catch block
                }
                throw throwable;
            }
            catch (Exception e) {
                if (showError) {
                    System.err.println("XMLUtil.loadDocument('" + f.getPath() + "') error:");
                    IcyExceptionHandler.showErrorMessage(e, false);
                }
                return null;
            }
        }
        try {
            is.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
        return document;
    }

    public static Document loadDocument(URL url) {
        return XMLUtil.loadDocument(url, null, false);
    }

    public static Document loadDocument(URL url, boolean showError) {
        return XMLUtil.loadDocument(url, null, showError);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Document loadDocument(URL url, AuthenticationInfo auth, boolean showError) {
        if (URLUtil.isFileURL(url)) {
            File f;
            try {
                f = new File(url.toURI());
            }
            catch (URISyntaxException e) {
                f = new File(url.getPath());
            }
            return XMLUtil.loadDocument(f);
        }
        InputStream is = NetworkUtil.getInputStream(url, auth, true, showError);
        if (is != null) {
            try {
                Document document = XMLUtil.loadDocument(is);
                return document;
            }
            finally {
                try {
                    is.close();
                }
                catch (IOException iOException) {}
            }
        }
        if (showError) {
            System.err.println("XMLUtil.loadDocument('" + url + "') failed.");
        }
        return null;
    }

    public static Document loadDocument(InputStream is) {
        DocumentBuilder builder = XMLUtil.createDocumentBuilder();
        if (builder != null) {
            try {
                return builder.parse(is);
            }
            catch (Exception e) {
                System.err.println("XMLUtil.loadDocument('" + is.toString() + "') error :");
                IcyExceptionHandler.showErrorMessage(e, false);
            }
        }
        return null;
    }

    public static boolean saveDocument(Document doc, String filename) {
        return XMLUtil.saveDocument(doc, FileUtil.createFile(filename));
    }

    public static boolean saveDocument(Document doc, File f) {
        if (doc == null || f == null) {
            System.err.println("XMLUtil.saveDocument(...) error: specified document or file is null !");
            return false;
        }
        Transformer transformer = XMLUtil.createTransformer();
        if (transformer == null) {
            return false;
        }
        doc.normalizeDocument();
        DocumentType doctype = doc.getDoctype();
        DOMSource domSource = new DOMSource(doc);
        StreamResult streamResult = new StreamResult(f.getAbsolutePath());
        try {
            if (doctype != null) {
                transformer.setOutputProperty("doctype-public", doctype.getPublicId());
                transformer.setOutputProperty("doctype-system", doctype.getSystemId());
            }
            transformer.transform(domSource, streamResult);
            return true;
        }
        catch (Exception e) {
            IcyExceptionHandler.showErrorMessage(e, true);
            return false;
        }
    }

    public static String getXMLString(Document document) throws TransformerException {
        if (document == null) {
            return "";
        }
        Transformer transformer = XMLUtil.createTransformerSafe();
        StringWriter writer = new StringWriter();
        transformer.transform(new DOMSource(document), new StreamResult(writer));
        return writer.toString();
    }

    public static Element createRootElement(Document doc) {
        return XMLUtil.createRootElement(doc, NODE_ROOT_NAME);
    }

    public static Element createRootElement(Document doc, String name) {
        return XMLUtil.getRootElement(doc, true, name);
    }

    private static Element getRootElement(Document doc, boolean create, String name) {
        if (doc != null) {
            Element result = doc.getDocumentElement();
            if (result == null && create) {
                result = doc.createElement(name);
                doc.appendChild(result);
            }
            return result;
        }
        return null;
    }

    public static Element getRootElement(Document doc, boolean create) {
        return XMLUtil.getRootElement(doc, create, NODE_ROOT_NAME);
    }

    public static Element getRootElement(Document doc) {
        return XMLUtil.getRootElement(doc, false);
    }

    public static Element getParentElement(Element element) {
        for (Node parent = element.getParentNode(); parent != null; parent = parent.getParentNode()) {
            if (!(parent instanceof Element)) continue;
            return (Element)parent;
        }
        return null;
    }

    public static ArrayList<Node> getChildren(Node node) {
        ArrayList<Node> result = new ArrayList<Node>();
        RuntimeException exception = null;
        for (int tries = 3; tries > 0; --tries) {
            try {
                NodeList nodeList = node.getChildNodes();
                if (nodeList != null) {
                    for (int i = 0; i < nodeList.getLength(); ++i) {
                        Node n = nodeList.item(i);
                        if (n == null) continue;
                        result.add(n);
                    }
                }
                return result;
            }
            catch (RuntimeException e) {
                exception = e;
                continue;
            }
        }
        throw exception;
    }

    public static Node getChild(Node node, String name) {
        RuntimeException exception = null;
        for (int tries = 3; tries > 0; --tries) {
            NodeList nodeList = node.getChildNodes();
            try {
                if (nodeList != null) {
                    for (int i = 0; i < nodeList.getLength(); ++i) {
                        Node n = nodeList.item(i);
                        if (n == null || !n.getNodeName().equals(name)) continue;
                        return n;
                    }
                }
                return null;
            }
            catch (RuntimeException e) {
                exception = e;
                continue;
            }
        }
        throw exception;
    }

    public static ArrayList<Node> getChildren(Node node, String name) {
        ArrayList<Node> result = new ArrayList<Node>();
        RuntimeException exception = null;
        for (int tries = 3; tries > 0; --tries) {
            NodeList nodeList = node.getChildNodes();
            try {
                if (nodeList != null) {
                    for (int i = 0; i < nodeList.getLength(); ++i) {
                        Node n = nodeList.item(i);
                        if (n == null || !n.getNodeName().equals(name)) continue;
                        result.add(n);
                    }
                }
                return result;
            }
            catch (RuntimeException e) {
                exception = e;
                continue;
            }
        }
        throw exception;
    }

    @Deprecated
    public static ArrayList<Node> getSubNodes(Node node) {
        return XMLUtil.getChildren(node);
    }

    @Deprecated
    public static Node getSubNode(Node node, String name) {
        return XMLUtil.getChild(node, name);
    }

    @Deprecated
    public static ArrayList<Node> getSubNodes(Node node, String name) {
        return XMLUtil.getChildren(node, name);
    }

    public static ArrayList<Element> getElements(Node node) {
        ArrayList<Element> result = new ArrayList<Element>();
        RuntimeException exception = null;
        for (int tries = 3; tries > 0; --tries) {
            NodeList nodeList = node.getChildNodes();
            try {
                if (nodeList != null) {
                    for (int i = 0; i < nodeList.getLength(); ++i) {
                        Node n = nodeList.item(i);
                        if (!(n instanceof Element)) continue;
                        result.add((Element)n);
                    }
                }
                return result;
            }
            catch (RuntimeException e) {
                exception = e;
                continue;
            }
        }
        throw exception;
    }

    public static Element getElement(Node node, String name) {
        if (node == null) {
            return null;
        }
        String filteredName = XMLUtil.filterString(name);
        RuntimeException exception = null;
        for (int tries = 3; tries > 0; --tries) {
            try {
                NodeList nodeList = node.getChildNodes();
                if (nodeList != null) {
                    for (int i = 0; i < nodeList.getLength(); ++i) {
                        Node n = nodeList.item(i);
                        if (!(n instanceof Element) || !n.getNodeName().equals(filteredName)) continue;
                        return (Element)n;
                    }
                }
                return null;
            }
            catch (RuntimeException e) {
                exception = e;
                continue;
            }
        }
        throw exception;
    }

    public static ArrayList<Element> getElements(Node node, String name) {
        ArrayList<Element> result = new ArrayList<Element>();
        String filteredName = XMLUtil.filterString(name);
        RuntimeException exception = null;
        for (int tries = 3; tries > 0; --tries) {
            NodeList nodeList = node.getChildNodes();
            try {
                if (nodeList != null) {
                    for (int i = 0; i < nodeList.getLength(); ++i) {
                        Node n = nodeList.item(i);
                        if (!(n instanceof Element) || !n.getNodeName().equals(filteredName)) continue;
                        result.add((Element)n);
                    }
                }
                return result;
            }
            catch (RuntimeException e) {
                exception = e;
                continue;
            }
        }
        throw exception;
    }

    @Deprecated
    public static ArrayList<Element> getSubElements(Node node) {
        return XMLUtil.getElements(node);
    }

    @Deprecated
    public static Element getSubElement(Node node, String name) {
        return XMLUtil.getElement(node, name);
    }

    @Deprecated
    public static ArrayList<Element> getSubElements(Node node, String name) {
        return XMLUtil.getElements(node, name);
    }

    public static ArrayList<Element> getGenericElements(Node node, String type) {
        ArrayList<Element> result = new ArrayList<Element>();
        String filteredType = XMLUtil.filterString(type);
        RuntimeException exception = null;
        for (int tries = 3; tries > 0; --tries) {
            NodeList nodeList = node.getChildNodes();
            try {
                if (nodeList != null) {
                    for (int i = 0; i < nodeList.getLength(); ++i) {
                        Node n = nodeList.item(i);
                        if (!(n instanceof Element) || !n.getNodeName().equals(filteredType)) continue;
                        result.add((Element)n);
                    }
                }
                return result;
            }
            catch (RuntimeException e) {
                exception = e;
                continue;
            }
        }
        throw exception;
    }

    public static ArrayList<Element> getGenericElements(Node node, String type, String name) {
        ArrayList<Element> result = new ArrayList<Element>();
        String filteredName = XMLUtil.filterString(name);
        String filteredType = XMLUtil.filterString(type);
        RuntimeException exception = null;
        for (int tries = 3; tries > 0; --tries) {
            NodeList nodeList = node.getChildNodes();
            try {
                if (nodeList != null) {
                    for (int i = 0; i < nodeList.getLength(); ++i) {
                        Element element;
                        Node n = nodeList.item(i);
                        if (!(n instanceof Element) || !n.getNodeName().equals(filteredType) || !(element = (Element)n).getAttribute(ATTR_NAME_NAME).equals(filteredName)) continue;
                        result.add(element);
                    }
                }
                return result;
            }
            catch (RuntimeException e) {
                exception = e;
                continue;
            }
        }
        throw exception;
    }

    @Deprecated
    public static ArrayList<Element> getSubGenericElements(Node node, String type) {
        return XMLUtil.getGenericElements(node, type);
    }

    @Deprecated
    public static ArrayList<Element> getSubGenericElements(Node node, String type, String name) {
        return XMLUtil.getGenericElements(node, type, name);
    }

    public static Element getGenericElement(Node node, String type, String name) {
        String filteredName = XMLUtil.filterString(name);
        String filteredType = XMLUtil.filterString(type);
        RuntimeException exception = null;
        for (int tries = 3; tries > 0; --tries) {
            NodeList nodeList = node.getChildNodes();
            try {
                if (nodeList != null) {
                    for (int i = 0; i < nodeList.getLength(); ++i) {
                        Element element;
                        Node n = nodeList.item(i);
                        if (!(n instanceof Element) || !n.getNodeName().equals(filteredType) || !(element = (Element)n).getAttribute(ATTR_NAME_NAME).equals(filteredName)) continue;
                        return element;
                    }
                }
                return null;
            }
            catch (RuntimeException e) {
                exception = e;
                continue;
            }
        }
        throw exception;
    }

    public static String getGenericElementName(Element element) {
        if (element != null) {
            return element.getAttribute(ATTR_NAME_NAME);
        }
        return "";
    }

    public static String getGenericElementValue(Element element, String def) {
        return XMLUtil.getAttributeValue(element, ATTR_VALUE_NAME, def);
    }

    public static ArrayList<Attr> getAllAttributes(Element element) {
        NamedNodeMap nodeMap = element.getAttributes();
        ArrayList<Attr> result = new ArrayList<Attr>();
        for (int i = 0; i < nodeMap.getLength(); ++i) {
            result.add((Attr)nodeMap.item(i));
        }
        return result;
    }

    private static boolean getBoolean(String value, boolean def) {
        return StringUtil.parseBoolean(value, def);
    }

    private static int getInt(String value, int def) {
        return StringUtil.parseInt(value, def);
    }

    private static long getLong(String value, long def) {
        return StringUtil.parseLong(value, def);
    }

    private static float getFloat(String value, float def) {
        return StringUtil.parseFloat(value, def);
    }

    private static double getDouble(String value, double def) {
        return StringUtil.parseDouble(value, def);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] getBytes(String value, byte[] def) throws DataFormatException {
        if (value == null) {
            return def;
        }
        byte[] result = (byte[])ArrayUtil.stringToArray1D((String)value, (DataType)DataType.BYTE, (boolean)true, (String)":");
        Inflater inflater = XMLUtil.inflater;
        synchronized (inflater) {
            return ZipUtil.unpack(XMLUtil.inflater, result);
        }
    }

    private static String toString(boolean value) {
        return StringUtil.toString(value);
    }

    private static String toString(int value) {
        return StringUtil.toString(value);
    }

    private static String toString(long value) {
        return StringUtil.toString(value);
    }

    private static String toString(float value) {
        return StringUtil.toString(value);
    }

    private static String toString(double value) {
        return StringUtil.toString(value);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String toString(byte[] value) {
        byte[] packed;
        Deflater deflater = XMLUtil.deflater;
        synchronized (deflater) {
            packed = ZipUtil.pack(XMLUtil.deflater, value, -1);
        }
        return ArrayUtil.array1DToString((Object)packed, (boolean)false, (boolean)true, (String)":", (int)-1);
    }

    public static Attr getAttribute(Element element, String attribute) {
        if (element != null) {
            return element.getAttributeNode(attribute);
        }
        return null;
    }

    public static String getAttributeValue(Element element, String attribute, String def) {
        if (element == null) {
            return def;
        }
        String filteredAttr = XMLUtil.filterString(attribute);
        RuntimeException exception = null;
        for (int tries = 3; tries > 0; --tries) {
            try {
                Attr attr = element.getAttributeNode(filteredAttr);
                if (attr != null) {
                    return attr.getValue();
                }
                return def;
            }
            catch (RuntimeException e) {
                exception = e;
                continue;
            }
        }
        throw exception;
    }

    public static boolean getAttributeBooleanValue(Element element, String attribute, boolean def) {
        return XMLUtil.getBoolean(XMLUtil.getAttributeValue(element, attribute, ""), def);
    }

    public static byte[] getAttributeBytesValue(Element element, String attribute, byte[] def) {
        try {
            return XMLUtil.getBytes(XMLUtil.getAttributeValue(element, attribute, ""), def);
        }
        catch (Exception e) {
            if (e instanceof RuntimeException) {
                throw (RuntimeException)e;
            }
            IcyExceptionHandler.showErrorMessage(e, true);
            return null;
        }
    }

    public static int getAttributeIntValue(Element element, String attribute, int def) {
        return XMLUtil.getInt(XMLUtil.getAttributeValue(element, attribute, ""), def);
    }

    public static long getAttributeLongValue(Element element, String attribute, long def) {
        return XMLUtil.getLong(XMLUtil.getAttributeValue(element, attribute, ""), def);
    }

    public static float getAttributeFloatValue(Element element, String attribute, float def) {
        return XMLUtil.getFloat(XMLUtil.getAttributeValue(element, attribute, ""), def);
    }

    public static double getAttributeDoubleValue(Element element, String attribute, double def) {
        return XMLUtil.getDouble(XMLUtil.getAttributeValue(element, attribute, ""), def);
    }

    public static String getFirstValue(Element element, String def) {
        if (element == null) {
            return def;
        }
        RuntimeException exception = null;
        for (int tries = 3; tries > 0; --tries) {
            try {
                Node child = element.getFirstChild();
                if (child != null) {
                    return child.getNodeValue();
                }
                return def;
            }
            catch (RuntimeException e) {
                exception = e;
                continue;
            }
        }
        throw exception;
    }

    public static String getAllValues(Element element, String def) {
        if (element == null) {
            return def;
        }
        RuntimeException exception = null;
        for (int tries = 3; tries > 0; --tries) {
            try {
                StringBuilder str = new StringBuilder();
                for (Node child = element.getFirstChild(); child != null; child = child.getNextSibling()) {
                    str.append(child.getNodeValue());
                }
                return str.toString();
            }
            catch (RuntimeException e) {
                exception = e;
                continue;
            }
        }
        throw exception;
    }

    public static String getValue(Element element, String def) {
        return XMLUtil.getAllValues(element, def);
    }

    public static boolean getBooleanValue(Element element, boolean def) {
        return XMLUtil.getBoolean(XMLUtil.getFirstValue(element, ""), def);
    }

    public static int getIntValue(Element element, int def) {
        return XMLUtil.getInt(XMLUtil.getFirstValue(element, ""), def);
    }

    public static long getLongValue(Element element, long def) {
        return XMLUtil.getLong(XMLUtil.getFirstValue(element, ""), def);
    }

    public static float getFloatValue(Element element, float def) {
        return XMLUtil.getFloat(XMLUtil.getFirstValue(element, ""), def);
    }

    public static double getDoubleValue(Element element, double def) {
        return XMLUtil.getDouble(XMLUtil.getFirstValue(element, ""), def);
    }

    public static byte[] getBytesValue(Element element, byte[] def) {
        try {
            return XMLUtil.getBytes(XMLUtil.getFirstValue(element, ""), def);
        }
        catch (Exception e) {
            if (e instanceof RuntimeException) {
                throw (RuntimeException)e;
            }
            IcyExceptionHandler.showErrorMessage(e, true);
            return null;
        }
    }

    public static String getElementFirstValue(Node node, String name, String def) {
        return XMLUtil.getFirstValue(XMLUtil.getElement(node, name), def);
    }

    public static String getElementAllValues(Node node, String name, String def) {
        return XMLUtil.getAllValues(XMLUtil.getElement(node, name), def);
    }

    public static String getElementValue(Node node, String name, String def) {
        return XMLUtil.getValue(XMLUtil.getElement(node, name), def);
    }

    public static boolean getElementBooleanValue(Node node, String name, boolean def) {
        return XMLUtil.getBoolean(XMLUtil.getElementValue(node, name, ""), def);
    }

    public static int getElementIntValue(Node node, String name, int def) {
        return XMLUtil.getInt(XMLUtil.getElementValue(node, name, ""), def);
    }

    public static long getElementLongValue(Node node, String name, long def) {
        return XMLUtil.getLong(XMLUtil.getElementValue(node, name, ""), def);
    }

    public static float getElementFloatValue(Node node, String name, float def) {
        return XMLUtil.getFloat(XMLUtil.getElementValue(node, name, ""), def);
    }

    public static double getElementDoubleValue(Node node, String name, double def) {
        return XMLUtil.getDouble(XMLUtil.getElementValue(node, name, ""), def);
    }

    public static byte[] getElementBytesValue(Node node, String name, byte[] def) {
        try {
            return XMLUtil.getBytes(XMLUtil.getElementValue(node, name, ""), def);
        }
        catch (Exception e) {
            if (e instanceof RuntimeException) {
                throw (RuntimeException)e;
            }
            IcyExceptionHandler.showErrorMessage(e, true);
            return null;
        }
    }

    public static String getGenericElementValue(Node node, String type, String name, String def) {
        return XMLUtil.getGenericElementValue(XMLUtil.getGenericElement(node, type, name), def);
    }

    public static boolean getGenericElementBooleanValue(Node node, String type, String name, boolean def) {
        return XMLUtil.getBoolean(XMLUtil.getGenericElementValue(node, type, name, ""), def);
    }

    public static int getGenericElementIntValue(Node node, String type, String name, int def) {
        return XMLUtil.getInt(XMLUtil.getGenericElementValue(node, type, name, ""), def);
    }

    public static long getGenericElementLongValue(Node node, String type, String name, long def) {
        return XMLUtil.getLong(XMLUtil.getGenericElementValue(node, type, name, ""), def);
    }

    public static float getGenericElementFloatValue(Node node, String type, String name, float def) {
        return XMLUtil.getFloat(XMLUtil.getGenericElementValue(node, type, name, ""), def);
    }

    public static double getGenericElementDoubleValue(Node node, String type, String name, double def) {
        return XMLUtil.getDouble(XMLUtil.getGenericElementValue(node, type, name, ""), def);
    }

    public static byte[] getGenericElementBytesValue(Node node, String type, String name, byte[] def) {
        try {
            return XMLUtil.getBytes(XMLUtil.getElementValue(node, name, ""), def);
        }
        catch (Exception e) {
            if (e instanceof RuntimeException) {
                throw (RuntimeException)e;
            }
            IcyExceptionHandler.showErrorMessage(e, true);
            return null;
        }
    }

    public static Node addNode(Node parent, Node node) {
        return parent.appendChild(node);
    }

    public static Node addValue(Node node, String value) {
        String filteredValue = XMLUtil.filterString(value);
        Text newNode = node instanceof Document ? ((Document)node).createTextNode(filteredValue) : node.getOwnerDocument().createTextNode(filteredValue);
        if (newNode != null) {
            node.appendChild(newNode);
        }
        return newNode;
    }

    public static Element addElement(Node node, String name) {
        String filteredName = XMLUtil.filterString(name);
        Element element = node instanceof Document ? ((Document)node).createElement(filteredName) : node.getOwnerDocument().createElement(filteredName);
        node.appendChild(element);
        return element;
    }

    public static Element addElement(Node node, String name, String value) {
        Element element = XMLUtil.addElement(node, name);
        if (!StringUtil.isEmpty(value)) {
            XMLUtil.addValue(element, value);
        }
        return element;
    }

    public static Element addGenericElement(Node node, String type, String name) {
        Element element = XMLUtil.addElement(node, type);
        XMLUtil.setGenericElementName(element, name);
        return element;
    }

    public static Element addGenericElement(Node node, String type, String name, String value) {
        Element element = XMLUtil.addElement(node, type);
        XMLUtil.setGenericElementName(element, name);
        XMLUtil.setGenericElementValue(element, value);
        return element;
    }

    public static void setGenericElementName(Element element, String name) {
        if (element != null) {
            element.setAttribute(ATTR_NAME_NAME, XMLUtil.filterString(name));
        }
    }

    public static void setGenericElementValue(Element element, String value) {
        if (element != null) {
            element.setAttribute(ATTR_VALUE_NAME, XMLUtil.filterString(value));
        }
    }

    public static Node setNode(Node parent, Node node) {
        String name = node.getNodeName();
        XMLUtil.removeNode(parent, name);
        return XMLUtil.addNode(parent, node);
    }

    public static Element setElement(Node node, String name) {
        Element element = XMLUtil.getElement(node, name);
        if (element != null) {
            return element;
        }
        return XMLUtil.addElement(node, name);
    }

    public static Element setGenericElement(Node node, String type, String name) {
        Element element = XMLUtil.getGenericElement(node, type, name);
        if (element != null) {
            return element;
        }
        return XMLUtil.addGenericElement(node, type, name);
    }

    public static void setAttributeValue(Element element, String attribute, String value) {
        element.setAttribute(attribute, XMLUtil.filterString(value));
    }

    public static void setAttributeBooleanValue(Element element, String attribute, boolean value) {
        XMLUtil.setAttributeValue(element, attribute, XMLUtil.toString(value));
    }

    public static void setAttributeIntValue(Element element, String attribute, int value) {
        XMLUtil.setAttributeValue(element, attribute, XMLUtil.toString(value));
    }

    public static void setAttributeLongValue(Element element, String attribute, long value) {
        XMLUtil.setAttributeValue(element, attribute, XMLUtil.toString(value));
    }

    public static void setAttributeFloatValue(Element element, String attribute, float value) {
        XMLUtil.setAttributeValue(element, attribute, XMLUtil.toString(value));
    }

    public static void setAttributeDoubleValue(Element element, String attribute, double value) {
        XMLUtil.setAttributeValue(element, attribute, XMLUtil.toString(value));
    }

    public static void setAttributeBytesValue(Element element, String attribute, byte[] value) {
        XMLUtil.setAttributeValue(element, attribute, XMLUtil.toString(value));
    }

    public static void setValue(Element element, String value) {
        XMLUtil.removeAllChildren(element);
        XMLUtil.addValue(element, value);
    }

    public static String removeXMLMarkups(String s) {
        StringBuffer out = new StringBuffer();
        for (char c : s.toCharArray()) {
            if (c == '\'' || c == '<' || c == '>' || c == '&' || c == '\"') continue;
            out.append(c);
        }
        return out.toString();
    }

    public static String removeInvalidXMLCharacters(String text) {
        if (text == null) {
            return "";
        }
        String xml10pattern = "[^\t\r\n -\ud7ff\ue000-\ufffd\ud800\udc00-\udbff\udfff]";
        return text.replaceAll("[^\t\r\n -\ud7ff\ue000-\ufffd\ud800\udc00-\udbff\udfff]", "").replaceAll("&#", "#");
    }

    public static String filterString(String text) {
        return XMLUtil.removeInvalidXMLCharacters(text);
    }

    public static void setBooleanValue(Element element, boolean value) {
        XMLUtil.setValue(element, XMLUtil.toString(value));
    }

    public static void setIntValue(Element element, int value) {
        XMLUtil.setValue(element, XMLUtil.toString(value));
    }

    public static void setLongValue(Element element, long value) {
        XMLUtil.setValue(element, XMLUtil.toString(value));
    }

    public static void setFloatValue(Element element, float value) {
        XMLUtil.setValue(element, XMLUtil.toString(value));
    }

    public static void setDoubleValue(Element element, double value) {
        XMLUtil.setValue(element, XMLUtil.toString(value));
    }

    public static void setBytesValue(Element element, byte[] value) {
        XMLUtil.setValue(element, XMLUtil.toString(value));
    }

    public static void setElementValue(Node node, String name, String value) {
        Element element = XMLUtil.setElement(node, name);
        XMLUtil.setValue(element, value);
    }

    public static void setElementBooleanValue(Node node, String name, boolean value) {
        XMLUtil.setElementValue(node, name, XMLUtil.toString(value));
    }

    public static void setElementIntValue(Node node, String name, int value) {
        XMLUtil.setElementValue(node, name, XMLUtil.toString(value));
    }

    public static void setElementLongValue(Node node, String name, long value) {
        XMLUtil.setElementValue(node, name, XMLUtil.toString(value));
    }

    public static void setElementFloatValue(Node node, String name, float value) {
        XMLUtil.setElementValue(node, name, XMLUtil.toString(value));
    }

    public static void setElementDoubleValue(Node node, String name, double value) {
        XMLUtil.setElementValue(node, name, XMLUtil.toString(value));
    }

    public static void setElementBytesValue(Node node, String name, byte[] value) {
        XMLUtil.setElementValue(node, name, XMLUtil.toString(value));
    }

    public static void setGenericElementValue(Node node, String type, String name, String value) {
        Element element = XMLUtil.setGenericElement(node, type, name);
        if (element != null) {
            element.setAttribute(ATTR_VALUE_NAME, value);
        }
    }

    public static void setGenericElementBooleanValue(Node node, String type, String name, boolean value) {
        XMLUtil.setGenericElementValue(node, type, name, XMLUtil.toString(value));
    }

    public static void setGenericElementIntValue(Node node, String type, String name, int value) {
        XMLUtil.setGenericElementValue(node, type, name, XMLUtil.toString(value));
    }

    public static void setGenericElementLongValue(Node node, String type, String name, long value) {
        XMLUtil.setGenericElementValue(node, type, name, XMLUtil.toString(value));
    }

    public static void setGenericElementFloatValue(Node node, String type, String name, float value) {
        XMLUtil.setGenericElementValue(node, type, name, XMLUtil.toString(value));
    }

    public static void setGenericElementDoubleValue(Node node, String type, String name, double value) {
        XMLUtil.setGenericElementValue(node, type, name, XMLUtil.toString(value));
    }

    public static void setGenericElementBytesValue(Node node, String type, String name, byte[] value) {
        XMLUtil.setGenericElementValue(node, type, name, XMLUtil.toString(value));
    }

    public static boolean removeNode(Node node, String name) {
        Node subNode = XMLUtil.getSubNode(node, name);
        if (subNode != null) {
            return XMLUtil.removeNode(node, subNode);
        }
        return false;
    }

    public static boolean removeNode(Node parent, Node child) {
        for (int tries = 3; tries > 0; --tries) {
            try {
                parent.removeChild(child);
                return true;
            }
            catch (RuntimeException e) {
                continue;
            }
        }
        return false;
    }

    @Deprecated
    public static void removeAllChilds(Node node) {
        XMLUtil.removeAllChildren(node);
    }

    public static void removeAllChildren(Node node) {
        while (node.hasChildNodes()) {
            node.removeChild(node.getLastChild());
        }
    }

    @Deprecated
    public static void removeChilds(Node node, String name) {
        XMLUtil.removeChildren(node, name);
    }

    public static void removeChildren(Node node, String name) {
        Node currentChild = node.getFirstChild();
        while (currentChild != null) {
            Node nextChild = currentChild.getNextSibling();
            if (currentChild.getNodeName().equals(name)) {
                node.removeChild(currentChild);
            }
            currentChild = nextChild;
        }
    }

    public static void removeAttribute(Element element, String name) {
        element.removeAttribute(name);
    }

    public static void removeAllAttributes(Element element) {
        NamedNodeMap nodeMap = element.getAttributes();
        for (int i = 0; i < nodeMap.getLength(); ++i) {
            element.removeAttribute(nodeMap.item(i).getNodeName());
        }
    }

    static {
        try {
            docBuilderFactory.setNamespaceAware(false);
            docBuilderFactory.setValidating(false);
            docBuilderFactory.setFeature("http://xml.org/sax/features/namespaces", false);
            docBuilderFactory.setFeature("http://xml.org/sax/features/validation", false);
            docBuilderFactory.setFeature("http://apache.org/xml/features/nonvalidating/load-dtd-grammar", false);
            docBuilderFactory.setFeature("http://apache.org/xml/features/nonvalidating/load-external-dtd", false);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

