/*******************************************************************************
 * Copyright (c) 2012-2013 Biomedical Image Group (BIG), EPFL, Switzerland.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the GNU Public License v3.0
 * which accompanies this distribution, and is available at
 * http://www.gnu.org/licenses/gpl.html
 * 
 * Contributors:
 *     Ricard Delgado-Gonzalo (ricard.delgado@gmail.com)
 *     Nicolas Chenouard (nicolas.chenouard@gmail.com)
 *     Philippe Th&#233;venaz (philippe.thevenaz@epfl.ch)
 *     Emrah Bostan (emrah.bostan@gmail.com)
 *     Ulugbek S. Kamilov (kamilov@gmail.com)
 *     Ramtin Madani (ramtin_madani@yahoo.com)
 *     Masih Nilchian (masih_n85@yahoo.com)
 *     C&#233;dric Vonesch (cedric.vonesch@epfl.ch)
 *     Virginie Uhlmann (virginie.uhlmann@epfl.ch)
 *     Cl&#233;ment Marti (clement.marti@epfl.ch)
 *     Julien Jacquemot (julien.jacquemot@epfl.ch)
 ******************************************************************************/
package plugins.big.bigsnakeutils.icy.gui.curve;

import java.awt.geom.Point2D;
import java.util.Vector;

import plugins.adufour.vars.gui.VarEditor;
import plugins.adufour.vars.lang.Var;

/**
 * Var for Curve objects. The String value of a VarCurve is the list of the
 * control points. Each point is separated by a ';' and the point coordinates
 * are separated by a space.
 * 
 * @version May 3, 2014
 * 
 * @author Julien Jacquemot
 */
public class VarCurve extends Var<Curve> {
	/** Default constructor. */
	public VarCurve(String name, Curve defaultValue)
			throws NullPointerException {
		super(name, defaultValue);
	}

	@Override
	public VarEditor<Curve> createVarEditor() {
		return new CurveEditor(this);
	}

	@Override
	public String getValueAsString() {
		Curve curve = getValue();
		String res = "";

		for (int i = 0; i < curve.count(); ++i) {
			if (i > 0) {
				res += ";";
			}
			Point2D point = curve.getControlPoint(i);
			res += point.getX() + " " + point.getY();
		}

		return res;
	}

	@Override
	public Curve parse(String text) {
		Curve curve = getValue().clone();

		text = text.trim();
		String[] pointsValues = text.split(";");
		Vector<Point2D> points = new Vector<Point2D>();

		for (String pointValues : pointsValues) {
			String[] values = pointValues.split(" ");
			points.add(new Point2D.Double(Double.parseDouble(values[0]), Double
					.parseDouble(values[1])));
		}

		curve.setControlPoints(points);

		return curve;
	}
}
