/*
 * Decompiled with CFR 0.152.
 */
package be.cytomine.client;

import be.cytomine.client.CytomineException;
import be.cytomine.client.collections.Collection;
import be.cytomine.client.models.Model;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Set;
import org.reflections.Reflections;
import org.reflections.scanners.Scanner;

public class Test {
    public static void launch() throws NoSuchMethodException {
        Reflections reflections = new Reflections("be.cytomine.client.models", new Scanner[0]);
        Set<Class<Model>> classes = reflections.getSubTypesOf(Model.class);
        StringBuilder err = new StringBuilder();
        Method save = Model.class.getDeclaredMethod("save", new Class[0]);
        Method fetch = Model.class.getDeclaredMethod("fetch", Long.class);
        Method update = Model.class.getDeclaredMethod("update", new Class[0]);
        Method delete = Model.class.getDeclaredMethod("delete", new Class[0]);
        for (Class<Model> c : classes) {
            block3: {
                Test.runMethod(save, c, err);
                Test.runMethod(fetch, c, err);
                try {
                    Collection.fetch(c, 0, 0);
                }
                catch (CytomineException e) {
                    int code = e.getHttpCode();
                    if (code == 403) break block3;
                    err.append("Error " + code + " : Collection<" + c.getSimpleName() + "> : fetch\n");
                }
            }
            Test.runMethod(update, c, err);
            Test.runMethod(delete, c, err);
        }
        System.out.println("\n" + err.toString());
    }

    private static void runMethod(Method m, Class c, StringBuilder err) {
        ArrayList<Integer> toleratedCodes = new ArrayList<Integer>();
        toleratedCodes.add(403);
        toleratedCodes.add(404);
        if (m.getName().equals("save")) {
            toleratedCodes.add(400);
        }
        try {
            if (m.getParameterCount() == 0) {
                m.invoke(c.newInstance(), new Object[0]);
            }
            if (m.getParameterCount() == 1) {
                m.invoke(c.newInstance(), 0L);
            }
        }
        catch (InvocationTargetException e) {
            int code = ((CytomineException)e.getCause()).getHttpCode();
            if (!toleratedCodes.contains(code)) {
                err.append("Error " + code + " : " + c.getSimpleName() + " : " + m.getName() + "\n");
            }
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
        catch (InstantiationException e) {
            e.printStackTrace();
        }
    }
}

