/*
 * Decompiled with CFR 0.152.
 */
package be.cytomine.client.collections;

import be.cytomine.client.Cytomine;
import be.cytomine.client.CytomineConnection;
import be.cytomine.client.CytomineException;
import be.cytomine.client.collections.Collection;
import be.cytomine.client.models.Model;
import be.cytomine.client.models.Property;

public class PropertyCollection
extends Collection {
    public PropertyCollection() {
        this(0, 0);
    }

    public PropertyCollection(int offset, int max) {
        super(Property.class, max, offset);
    }

    public static PropertyCollection fetchByAssociatedDomain(Model domain) throws CytomineException {
        return PropertyCollection.fetchByAssociatedDomain(Cytomine.getInstance().getDefaultCytomineConnection(), domain, 0, 0);
    }

    public static PropertyCollection fetchByAssociatedDomain(CytomineConnection connection, Model domain) throws CytomineException {
        return PropertyCollection.fetchByAssociatedDomain(connection, domain, 0, 0);
    }

    public static PropertyCollection fetchByAssociatedDomain(Model domain, int offset, int max) throws CytomineException {
        return PropertyCollection.fetchByAssociatedDomain(Cytomine.getInstance().getDefaultCytomineConnection(), domain, offset, max);
    }

    public static PropertyCollection fetchByAssociatedDomain(CytomineConnection connection, Model domain, int offset, int max) throws CytomineException {
        return (PropertyCollection)new PropertyCollection(max, offset).fetchWithFilter(connection, domain.getClass(), domain.getId(), offset, max);
    }

    @Override
    protected String getJSONResourceURL() throws CytomineException {
        if (this.isFilterBy("annotation") && this.isFilterBy("idDomain") && this.isFilterBy("nameIdDomain")) {
            return this.getJSONResourceURLWithFilter("annotation", "idDomain", "nameIdDomain");
        }
        if (this.isFilterBy("imageinstance") && this.isFilterBy("idDomain") && this.isFilterBy("nameIdDomain")) {
            return this.getJSONResourceURLWithFilter("imageinstance", "idDomain", "nameIdDomain");
        }
        if (this.isFilterBy("annotation") && this.isFilterBy("key")) {
            return this.getJSONResourceURLWithFilter("annotation", "key");
        }
        if (this.isFilterBy("project") && this.isFilterBy("key")) {
            return this.getJSONResourceURLWithFilter("project", "key");
        }
        if (this.isFilterBy("imageinstance") && this.isFilterBy("key")) {
            return this.getJSONResourceURLWithFilter("imageinstance", "key");
        }
        if (this.isFilterBy("annotation")) {
            return this.getJSONResourceURLWithFilter("annotation");
        }
        if (this.isFilterBy("project")) {
            return this.getJSONResourceURLWithFilter("project");
        }
        if (this.isFilterBy("imageinstance")) {
            return this.getJSONResourceURLWithFilter("imageinstance");
        }
        if (this.isFilterBy("domainClassName")) {
            return this.getJSONResourceURLWithFilter(this.getFilter("domainClassName"));
        }
        return super.getJSONResourceURL();
    }

    private String getJSONResourceURLWithFilter(String filter1Name) throws CytomineException {
        return "/api/" + filter1Name + "/" + this.getFilter(filter1Name) + "/" + this.getDomainName() + ".json";
    }

    private String getJSONResourceURLWithFilter(String filter1Name, String filter2Name) throws CytomineException {
        return "/api/" + filter1Name + "/" + this.getFilter(filter1Name) + "/" + filter2Name + "/" + this.getFilter(filter2Name) + "/" + this.getDomainName() + ".json";
    }

    private String getJSONResourceURLWithFilter(String domain, String idDomain, String nameIdDomain) throws CytomineException {
        return "/api/" + domain + "/" + this.getDomainName() + "/key.json?" + this.getFilter(nameIdDomain) + "=" + this.getFilter(idDomain);
    }
}

