/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jts.operation.overlay.validate;

import com.vividsolutions.jts.algorithm.PointLocator;
import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.CoordinateSequence;
import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.GeometryFactory;
import com.vividsolutions.jts.geom.LineSegment;
import com.vividsolutions.jts.geom.LineString;
import com.vividsolutions.jts.geom.MultiLineString;
import com.vividsolutions.jts.operation.overlay.validate.PolygonalLineworkExtracter;
import java.util.List;

public class FuzzyPointLocator {
    private Geometry g;
    private double boundaryDistanceTolerance;
    private MultiLineString linework;
    private PointLocator ptLocator = new PointLocator();
    private LineSegment seg = new LineSegment();

    public FuzzyPointLocator(Geometry g, double boundaryDistanceTolerance) {
        this.g = g;
        this.boundaryDistanceTolerance = boundaryDistanceTolerance;
        this.linework = this.extractLinework(g);
    }

    public int getLocation(Coordinate pt) {
        if (this.isWithinToleranceOfBoundary(pt)) {
            return 1;
        }
        return this.ptLocator.locate(pt, this.g);
    }

    private MultiLineString extractLinework(Geometry g) {
        PolygonalLineworkExtracter extracter = new PolygonalLineworkExtracter();
        g.apply(extracter);
        List linework = extracter.getLinework();
        LineString[] lines = GeometryFactory.toLineStringArray(linework);
        return g.getFactory().createMultiLineString(lines);
    }

    private boolean isWithinToleranceOfBoundary(Coordinate pt) {
        int i = 0;
        while (i < this.linework.getNumGeometries()) {
            LineString line = (LineString)this.linework.getGeometryN(i);
            CoordinateSequence seq = line.getCoordinateSequence();
            int j = 0;
            while (j < seq.size() - 1) {
                seq.getCoordinate(j, this.seg.p0);
                seq.getCoordinate(j + 1, this.seg.p1);
                double dist = this.seg.distance(pt);
                if (dist <= this.boundaryDistanceTolerance) {
                    return true;
                }
                ++j;
            }
            ++i;
        }
        return false;
    }
}

