/*
 * Decompiled with CFR 0.152.
 */
package org.bioimageanalysis.icy.icytomine.core.image.annotation;

import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.CoordinateSequence;
import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.LineString;
import com.vividsolutions.jts.geom.MultiPolygon;
import com.vividsolutions.jts.geom.Point;
import com.vividsolutions.jts.geom.Polygon;
import icy.roi.ROI;
import icy.sequence.Sequence;
import java.awt.geom.Path2D;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.bioimageanalysis.icy.icytomine.core.connection.client.CytomineClientException;
import org.bioimageanalysis.icy.icytomine.core.image.annotation.AnnotationInserterException;
import org.bioimageanalysis.icy.icytomine.core.model.Annotation;
import org.bioimageanalysis.icy.icytomine.core.view.converters.MagnitudeResolutionConverter;
import plugins.kernel.roi.roi2d.ROI2DPath;
import plugins.kernel.roi.roi2d.ROI2DPoint;
import plugins.kernel.roi.roi2d.ROI2DPolyLine;
import plugins.kernel.roi.roi2d.ROI2DPolygon;
import plugins.kernel.roi.roi2d.ROI2DShape;

public class AnnotationInserter {
    Sequence sequence;
    boolean retrieveProperties;
    Rectangle2D viewBoundsAtZeroResolution;
    double sequenceResolution;
    Set<Annotation> activeAnnotations;

    public AnnotationInserter(Sequence sequence) {
        this.sequence = sequence;
    }

    public void insertAnnotations(Rectangle2D viewBoundsAtZeroResolution, double sequenceResolution, Set<Annotation> activeAnnotations, boolean retrieveProperties) throws AnnotationInserterException {
        this.viewBoundsAtZeroResolution = viewBoundsAtZeroResolution;
        this.sequenceResolution = sequenceResolution;
        this.activeAnnotations = activeAnnotations;
        this.retrieveProperties = retrieveProperties;
        this.addAnnotationsToSequence();
    }

    private void addAnnotationsToSequence() throws AnnotationInserterException {
        this.activeAnnotations.forEach(a -> this.addAnnotationToSequence((Annotation)a, this.sequence));
    }

    private void addAnnotationToSequence(Annotation annotation, Sequence sequence) throws CytomineClientException, AnnotationInserterException {
        ROI2DShape roiInView = this.createRoiInView(annotation);
        roiInView.setName(Objects.toString(annotation.getId()));
        roiInView.setProperty("cytomineId", Objects.toString(annotation.getId()));
        if (this.retrieveProperties) {
            annotation.getAnnotationProperties(false).forEach(p -> {
                if (p.getKey().orElse("").equals("ANNOTATION_GROUP_ID")) {
                    roiInView.setName(p.getValue().orElse(Objects.toString(annotation.getId())));
                }
                roiInView.setProperty(p.getKey().orElse("Unknown"), p.getValue().orElse("Unknown"));
            });
        }
        roiInView.setColor(annotation.getColor());
        sequence.addROI((ROI)roiInView);
    }

    private ROI2DShape createRoiInView(Annotation annotation) throws CytomineClientException, AnnotationInserterException {
        Geometry geometry = annotation.getGeometryAtZeroResolution(false);
        if (geometry instanceof Point) {
            return this.createPoint((Point)geometry, annotation);
        }
        if (geometry instanceof LineString) {
            return this.createLineString((LineString)geometry, annotation);
        }
        if (geometry instanceof Polygon) {
            return this.createPolygon((Polygon)geometry, annotation);
        }
        if (geometry instanceof MultiPolygon) {
            return this.createMultiPolygon((MultiPolygon)geometry, annotation);
        }
        throw new AnnotationInserterException(String.format("Unsupported annotation geometry (%s)", geometry.getGeometryType()));
    }

    private ROI2DPoint createPoint(Point geometry, Annotation annotation) throws CytomineClientException {
        int maxY = annotation.getImage().getSizeY().get();
        double x = MagnitudeResolutionConverter.convertMagnitude(geometry.getCoordinate().x - this.viewBoundsAtZeroResolution.getMinX(), 0.0, this.sequenceResolution);
        double y = MagnitudeResolutionConverter.convertMagnitude((double)maxY - geometry.getCoordinate().y - this.viewBoundsAtZeroResolution.getMinY(), 0.0, this.sequenceResolution);
        return new ROI2DPoint(x, y);
    }

    private ROI2DPolyLine createLineString(LineString geometry, Annotation annotation) throws CytomineClientException {
        int maxY = annotation.getImage().getSizeY().get();
        CoordinateSequence coordinates = geometry.getCoordinateSequence();
        int size = coordinates.size();
        List points = IntStream.range(0, size).mapToObj(i -> {
            Coordinate coordinate = coordinates.getCoordinate(i);
            double x = MagnitudeResolutionConverter.convertMagnitude(coordinate.x - this.viewBoundsAtZeroResolution.getMinX(), 0.0, this.sequenceResolution);
            double y = MagnitudeResolutionConverter.convertMagnitude((double)maxY - coordinate.y - this.viewBoundsAtZeroResolution.getMinY(), 0.0, this.sequenceResolution);
            return new Point2D.Double(x, y);
        }).collect(Collectors.toList());
        return new ROI2DPolyLine(points);
    }

    private ROI2DShape createPolygon(Polygon geometry, Annotation annotation) throws CytomineClientException {
        int maxY = annotation.getImage().getSizeY().get();
        if (geometry.getNumInteriorRing() == 0) {
            Coordinate[] coordinates = geometry.getCoordinates();
            int size = coordinates.length;
            List points = IntStream.range(0, size - 1).mapToObj(i -> {
                Coordinate coordinate = coordinates[i];
                double x = MagnitudeResolutionConverter.convertMagnitude(coordinate.x - this.viewBoundsAtZeroResolution.getMinX(), 0.0, this.sequenceResolution);
                double y = MagnitudeResolutionConverter.convertMagnitude((double)maxY - coordinate.y - this.viewBoundsAtZeroResolution.getMinY(), 0.0, this.sequenceResolution);
                return new Point2D.Double(x, y);
            }).collect(Collectors.toList());
            return new ROI2DPolygon(points);
        }
        Path2D.Double path = new Path2D.Double();
        Coordinate[] exteriorRingCoordinates = geometry.getExteriorRing().getCoordinates();
        int extSize = exteriorRingCoordinates.length;
        IntStream.range(0, extSize).forEach(i -> {
            Coordinate coordinate = exteriorRingCoordinates[i];
            double x = MagnitudeResolutionConverter.convertMagnitude(coordinate.x - this.viewBoundsAtZeroResolution.getMinX(), 0.0, this.sequenceResolution);
            double y = MagnitudeResolutionConverter.convertMagnitude((double)maxY - coordinate.y - this.viewBoundsAtZeroResolution.getMinY(), 0.0, this.sequenceResolution);
            if (i == 0) {
                path.moveTo(x, y);
            } else if (i == extSize - 1) {
                path.closePath();
            } else {
                path.lineTo(x, y);
            }
        });
        int interiorRingCount = geometry.getNumInteriorRing();
        for (int r = 0; r < interiorRingCount; ++r) {
            Coordinate[] interiorCoords = geometry.getInteriorRingN(r).getCoordinates();
            int interiorSize = interiorCoords.length;
            IntStream.range(0, interiorSize).forEach(p -> {
                Coordinate coordinate = interiorCoords[p];
                double x = MagnitudeResolutionConverter.convertMagnitude(coordinate.x - this.viewBoundsAtZeroResolution.getMinX(), 0.0, this.sequenceResolution);
                double y = MagnitudeResolutionConverter.convertMagnitude((double)maxY - coordinate.y - this.viewBoundsAtZeroResolution.getMinY(), 0.0, this.sequenceResolution);
                if (p == 0) {
                    path.moveTo(x, y);
                } else if (p == interiorSize - 1) {
                    path.closePath();
                } else {
                    path.lineTo(x, y);
                }
            });
        }
        return new ROI2DPath((Path2D)path);
    }

    private ROI2DPath createMultiPolygon(MultiPolygon geometry, Annotation annotation) {
        int numPolygons = geometry.getNumGeometries();
        Path2D.Double path = new Path2D.Double();
        for (int i = 0; i < numPolygons; ++i) {
            ROI2DPoint internalROI;
            Geometry subGeometry = geometry.getGeometryN(i);
            if (subGeometry instanceof Point) {
                internalROI = this.createPoint((Point)subGeometry, annotation);
            } else if (subGeometry instanceof LineString) {
                internalROI = this.createLineString((LineString)subGeometry, annotation);
            } else if (subGeometry instanceof Polygon) {
                internalROI = this.createPolygon((Polygon)subGeometry, annotation);
            } else if (subGeometry instanceof Polygon) {
                internalROI = this.createMultiPolygon((MultiPolygon)subGeometry, annotation);
            } else {
                throw new AnnotationInserterException(String.format("Unsupported annotation geometry (%s)", subGeometry.getGeometryType()));
            }
            path.append(internalROI.getShape(), false);
        }
        return new ROI2DPath((Path2D)path);
    }
}

