/*
 * Decompiled with CFR 0.152.
 */
package org.bioimageanalysis.icy.icytomine.core.image.tile;

import java.awt.Dimension;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.geom.Dimension2D;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;

public class FixedTileCalculator {
    private Point2D targetOrigin;
    private Rectangle2D targetArea;
    private Dimension tileDimension;

    public FixedTileCalculator(Rectangle2D targetArea, Point2D targetOrigin, Dimension tileDimension) {
        this.targetArea = targetArea;
        if (targetOrigin == null) {
            targetOrigin = new Point();
        }
        this.targetOrigin = targetOrigin;
        this.tileDimension = tileDimension;
    }

    public Rectangle getTileGridBounds() {
        int xStart = (int)(this.targetArea.getMinX() - this.targetOrigin.getX());
        int xEnd = (int)Math.ceil(this.targetArea.getMaxX() - this.targetOrigin.getX()) - 1;
        int xStartTile = xStart / this.tileDimension.width;
        int xEndTile = (xEnd + this.tileDimension.width - 1) / this.tileDimension.width;
        int yStart = (int)(this.targetArea.getMinY() - this.targetOrigin.getY());
        int yEnd = (int)Math.ceil(this.targetArea.getMaxY() - this.targetOrigin.getY()) - 1;
        int yStartTile = yStart / this.tileDimension.height;
        int yEndTile = (yEnd + this.tileDimension.height - 1) / this.tileDimension.height;
        return new Rectangle(xStartTile, yStartTile, xEndTile - xStartTile, yEndTile - yStartTile);
    }

    public Rectangle getLimitedTileGridBounds(Dimension2D imageSize) {
        int maxXTile = (int)Math.ceil(imageSize.getWidth() / this.tileDimension.getWidth());
        int maxYTile = (int)Math.ceil(imageSize.getHeight() / this.tileDimension.getHeight());
        Rectangle imageTileGrid = new Rectangle(0, 0, maxXTile, maxYTile);
        Rectangle targetTileGrid = this.getTileGridBounds();
        return targetTileGrid.intersection(imageTileGrid);
    }
}

