/*
 * Decompiled with CFR 0.152.
 */
package org.bioimageanalysis.icy.icytomine.core.model;

import com.vividsolutions.jts.awt.PointTransformation;
import com.vividsolutions.jts.awt.ShapeWriter;
import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.Envelope;
import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.io.ParseException;
import com.vividsolutions.jts.io.WKTReader;
import com.vividsolutions.jts.simplify.TopologyPreservingSimplifier;
import java.awt.Color;
import java.awt.Shape;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.bioimageanalysis.icy.icytomine.core.connection.client.CytomineClient;
import org.bioimageanalysis.icy.icytomine.core.connection.client.CytomineClientException;
import org.bioimageanalysis.icy.icytomine.core.model.AnnotationTerm;
import org.bioimageanalysis.icy.icytomine.core.model.Entity;
import org.bioimageanalysis.icy.icytomine.core.model.Image;
import org.bioimageanalysis.icy.icytomine.core.model.Property;
import org.bioimageanalysis.icy.icytomine.core.model.Term;
import org.bioimageanalysis.icy.icytomine.core.model.User;
import org.json.simple.JSONArray;
import org.json.simple.JSONObject;

public class Annotation
extends Entity {
    private String location;
    Geometry geometry;
    Geometry latestSimplifiedGeometry;
    int latestSimplifiedGeometryResolution = 0;
    private List<AnnotationTerm> annotationTerms;
    private List<Property> annotationProperties;
    private Map<Long, Set<Long>> termUsers;
    private Rectangle2D adjustedBounds;
    private Rectangle2D approximativeBounds;
    private Rectangle2D adjustedApproximativeBounds;

    public static Entity retrieve(CytomineClient client, long annotationId) throws CytomineClientException {
        return client.getAnnotation(annotationId);
    }

    public Annotation(CytomineClient client, be.cytomine.client.models.Annotation internalAnnotation) {
        super(client, internalAnnotation);
    }

    public be.cytomine.client.models.Annotation getInternalAnnotation() {
        return (be.cytomine.client.models.Annotation)this.getModel();
    }

    public Optional<Long> getImageInstanceId() {
        return this.getLong("image");
    }

    public Optional<Long> getUserId() {
        return this.getLong("user");
    }

    public User getUser() throws CytomineClientException, NoSuchElementException {
        long userId = this.getUserId().get();
        return User.retrieve(this.getClient(), userId);
    }

    public Rectangle2D getYAdjustedBounds() {
        if (this.adjustedBounds == null) {
            Envelope envelope = this.getGeometryAtZeroResolution(false).getEnvelopeInternal();
            this.adjustedBounds = new Rectangle2D.Double(envelope.getMinX(), (double)this.getImage().getSizeY().get().intValue() - envelope.getMaxY(), envelope.getWidth(), envelope.getHeight());
            if (this.adjustedBounds.isEmpty()) {
                this.adjustedBounds = new Rectangle2D.Double(this.adjustedBounds.getX() - Double.MIN_VALUE, this.adjustedBounds.getY() - Double.MIN_VALUE, Double.MIN_VALUE, Double.MIN_VALUE);
            }
        }
        return this.adjustedBounds;
    }

    public Geometry getSimplifiedGeometryForResolution(int resolution) throws CytomineClientException {
        double pixelTolerance = 1.0;
        if (resolution > 0) {
            for (int i = 0; i < resolution; ++i) {
                pixelTolerance *= 2.0;
            }
        } else if (resolution < 0) {
            for (int i = 0; i < -resolution; ++i) {
                pixelTolerance /= 2.0;
            }
        }
        if (this.geometry == null || this.latestSimplifiedGeometry == null || this.latestSimplifiedGeometryResolution != resolution) {
            this.latestSimplifiedGeometry = this.getSimplifiedGeometry(pixelTolerance);
            this.latestSimplifiedGeometryResolution = resolution;
        }
        return this.latestSimplifiedGeometry;
    }

    public Rectangle2D getApproximativeBounds() throws CytomineClientException {
        if (this.approximativeBounds == null) {
            Geometry simplifiedGeometry = this.getSimplifiedGeometry(10.0);
            Envelope envelope = simplifiedGeometry.getEnvelopeInternal();
            this.approximativeBounds = new Rectangle2D.Double(envelope.getMinX(), envelope.getMinY(), envelope.getWidth(), envelope.getHeight());
        }
        return this.approximativeBounds;
    }

    public Rectangle2D getYAdjustedApproximativeBounds() throws CytomineClientException {
        if (this.adjustedApproximativeBounds == null) {
            Geometry simplifiedGeometry = this.getSimplifiedGeometry(10.0);
            Envelope envelope = simplifiedGeometry.getEnvelopeInternal();
            this.adjustedApproximativeBounds = new Rectangle2D.Double(envelope.getMinX(), (double)this.getImage().getSizeY().get().intValue() - envelope.getMaxY(), envelope.getWidth(), envelope.getHeight());
            if (this.adjustedApproximativeBounds.isEmpty()) {
                this.adjustedApproximativeBounds = new Rectangle2D.Double(this.adjustedApproximativeBounds.getX() - Double.MIN_VALUE, this.adjustedApproximativeBounds.getY() - Double.MIN_VALUE, Double.MIN_VALUE, Double.MIN_VALUE);
            }
        }
        return this.adjustedApproximativeBounds;
    }

    private Geometry getSimplifiedGeometry(double pixelTolerance) throws CytomineClientException {
        pixelTolerance = pixelTolerance > 0.0 ? pixelTolerance : 0.0;
        Geometry baseGeometry = this.getGeometryAtZeroResolution(false);
        if (baseGeometry == null) {
            throw new CytomineClientException(String.format("Null base geometry (annotation id=%d)", this.getId()));
        }
        TopologyPreservingSimplifier simplifier = new TopologyPreservingSimplifier(baseGeometry);
        simplifier.setDistanceTolerance(pixelTolerance);
        return simplifier.getResultGeometry();
    }

    public Geometry getGeometryAtZeroResolution(boolean recompute) throws CytomineClientException {
        if (this.geometry == null || recompute) {
            this.retrieveGeometry();
        }
        return this.geometry;
    }

    private void retrieveGeometry() throws CytomineClientException {
        this.geometry = null;
        Optional<String> location = this.getLocation();
        if (location.isPresent()) {
            WKTReader reader = new WKTReader();
            try {
                this.geometry = reader.read(location.get());
            }
            catch (ParseException e) {
                throw new CytomineClientException(String.format("Couldn't create geometry for annotation %d", this.getId()), e);
            }
        }
    }

    public Shape getShapeAtZeroResolution() throws CytomineClientException {
        final int maxY = this.getImage().getSizeY().get();
        this.getGeometryAtZeroResolution(false);
        ShapeWriter shapeWriter = new ShapeWriter(new PointTransformation(){

            @Override
            public void transform(Coordinate src, Point2D dest) {
                dest.setLocation(src.x, (double)maxY - src.y);
            }
        });
        return shapeWriter.toShape(this.geometry);
    }

    public Optional<String> getLocation() throws CytomineClientException {
        if (this.location == null) {
            Optional<String> locationString = this.getStr("location");
            this.location = locationString.isPresent() ? locationString.get() : (String)this.getClient().getAnnotationLocation(this.getId()).orElse(null);
        }
        return Optional.ofNullable(this.location);
    }

    public Image getImage() throws CytomineClientException {
        return Image.retrieve(this.getClient(), this.getImageInstanceId().get());
    }

    public Color getColor() {
        Set<Term> terms = this.getAssociatedTermsByCurrentUser();
        if (terms.isEmpty()) {
            terms = this.getAssociatedTerms();
        }
        Color color = !terms.isEmpty() ? terms.iterator().next().getColor() : Term.DEFAULT_TERM_COLOR;
        return color;
    }

    public Set<Term> getAssociatedTerms() throws CytomineClientException {
        return this.getTermUsers().keySet().stream().map(id -> this.getClient().getTerm((long)id)).collect(Collectors.toSet());
    }

    private Map<Long, Set<Long>> getTermUsers() throws CytomineClientException {
        if (this.termUsers == null) {
            try {
                this.termUsers = new HashMap<Long, Set<Long>>();
                JSONArray termUsersArray = (JSONArray)this.getInternalAnnotation().get("userByTerm");
                if (termUsersArray == null) {
                    termUsersArray = this.getClient().getAnnotationUsersByTerm(this);
                }
                for (Object tObject : termUsersArray) {
                    JSONArray userIds;
                    JSONObject termUser = (JSONObject)tObject;
                    long termId = (Long)termUser.get("term");
                    this.termUsers.putIfAbsent(termId, new HashSet());
                    try {
                        userIds = (JSONArray)termUser.get("user");
                    }
                    catch (ClassCastException e) {
                        userIds = new JSONArray();
                        userIds.add(termUser.get("user"));
                    }
                    for (Object uObject : userIds) {
                        long userId = (Long)uObject;
                        this.termUsers.get(termId).add(userId);
                    }
                }
            }
            catch (Exception e) {
                throw new CytomineClientException(String.format("Could not create term users map for annotation %d", this.getId()), e);
            }
        }
        return this.termUsers;
    }

    public Set<Term> getAssociatedTermsByCurrentUser() throws CytomineClientException {
        Long userId = this.getClient().getCurrentUser().getId();
        return this.getAssociatedTermsByUser(userId);
    }

    public Set<Term> getAssociatedTermsByUser(long userId) throws CytomineClientException {
        return this.getTermUsers().entrySet().stream().filter(entry -> ((Set)entry.getValue()).contains(userId)).map(e -> (Long)e.getKey()).distinct().map(id -> this.getClient().getTerm((long)id)).collect(Collectors.toSet());
    }

    public List<AnnotationTerm> getAnnotationTerms(boolean recompute) throws CytomineClientException {
        if (this.annotationTerms == null || recompute) {
            this.annotationTerms = this.getClient().downloadAnnotationTerms(this.getId());
        }
        return this.annotationTerms;
    }

    public void associateTerms(Map<Term, Boolean> termSelection) throws CytomineClientException {
        this.getClient().associateTerms(this, termSelection);
        this.updateModel();
    }

    public List<Property> getAnnotationProperties(boolean recompute) throws CytomineClientException {
        if (this.annotationProperties == null || recompute) {
            this.annotationProperties = this.getClient().getAnnotationProperties(this);
        }
        return this.annotationProperties;
    }

    private void updateModel() {
        Annotation newModel = this.getClient().downloadAnnotation(this.getId());
        this.getInternalAnnotation().setAttr(newModel.getInternalAnnotation().getAttr());
        this.termUsers = null;
        this.annotationTerms = null;
    }

    @Override
    public String toString() {
        return String.format("Annotation: id=%s", String.valueOf(this.getId()));
    }
}

