/*
 * Decompiled with CFR 0.152.
 */
package org.bioimageanalysis.icy.icytomine.core.model.filters;

import com.google.common.base.Objects;
import java.util.HashSet;
import java.util.Set;
import org.bioimageanalysis.icy.icytomine.core.model.Annotation;

public abstract class AnnotationFilter {
    private AnnotationFilter previousFilter;
    private AnnotationFilterUpdateListener previousFilterUpdateHandler;
    protected Set<Annotation> activeAnnotations;
    private Set<AnnotationFilterUpdateListener> updateListeners = new HashSet<AnnotationFilterUpdateListener>();

    public void setPreviousFilter(AnnotationFilter newPreviousFilter) {
        if (!Objects.equal((Object)this.previousFilter, (Object)newPreviousFilter)) {
            if (this.previousFilter != null) {
                this.previousFilter.removeAnnotationFilterUpdateListener(this.getPreviousFilterUpdateHandler());
            }
            this.previousFilter = newPreviousFilter;
            if (this.previousFilter != null) {
                this.previousFilter.addAnnotationFilterUpdateListener(this.getPreviousFilterUpdateHandler());
                this.computeActiveAnnotations(ComputationMode.RECOMPUTE_JUST_THIS);
            }
        }
    }

    private AnnotationFilterUpdateListener getPreviousFilterUpdateHandler() {
        if (this.previousFilterUpdateHandler == null) {
            this.previousFilterUpdateHandler = activeAnnotations -> this.computeActiveAnnotations(ComputationMode.RECOMPUTE_JUST_THIS);
        }
        return this.previousFilterUpdateHandler;
    }

    public AnnotationFilter getPreviousFilter() {
        return this.previousFilter;
    }

    public Set<Annotation> getActiveAnnotations(ComputationMode mode) {
        if (!this.isComputed() || mode != ComputationMode.USE_LAST_RESULT) {
            this.computeActiveAnnotations(mode);
        }
        return this.activeAnnotations;
    }

    private boolean isComputed() {
        return this.activeAnnotations != null;
    }

    public void computeActiveAnnotations(ComputationMode mode) {
        Set<Annotation> inputAnnotations = null;
        if (mode == ComputationMode.USE_LAST_RESULT) {
            if (!this.isComputed()) {
                inputAnnotations = this.previousFilter.getActiveAnnotations(mode);
                this.activeAnnotations = this.applyFilter(inputAnnotations);
                this.notifyUpdateListeners();
            }
        } else {
            inputAnnotations = mode == ComputationMode.RECOMPUTE_ALL ? this.previousFilter.getActiveAnnotations(mode) : this.previousFilter.getActiveAnnotations(ComputationMode.USE_LAST_RESULT);
            this.activeAnnotations = this.applyFilter(inputAnnotations);
            this.notifyUpdateListeners();
        }
    }

    protected abstract Set<Annotation> applyFilter(Set<Annotation> var1);

    protected void notifyUpdateListeners() {
        this.updateListeners.forEach(l -> l.filterUpdated(this.activeAnnotations));
    }

    public void addAnnotationFilterUpdateListener(AnnotationFilterUpdateListener listener) {
        this.updateListeners.add(listener);
    }

    public void removeAnnotationFilterUpdateListener(AnnotationFilterUpdateListener listener) {
        this.updateListeners.remove(listener);
    }

    public void disconnect() {
        AnnotationFilter previousFilter = this.getPreviousFilter();
        HashSet<AnnotationFilterUpdateListener> updateListenersCopy = new HashSet<AnnotationFilterUpdateListener>(this.updateListeners);
        for (AnnotationFilterUpdateListener listener : updateListenersCopy) {
            this.removeAnnotationFilterUpdateListener(listener);
            previousFilter.addAnnotationFilterUpdateListener(listener);
        }
        this.setPreviousFilter(null);
        previousFilter.computeActiveAnnotations(ComputationMode.RECOMPUTE_JUST_THIS);
    }

    public static interface AnnotationFilterUpdateListener {
        public void filterUpdated(Set<Annotation> var1);
    }

    public static enum ComputationMode {
        RECOMPUTE_ALL,
        RECOMPUTE_JUST_THIS,
        USE_LAST_RESULT;

    }
}

