/*
 * Decompiled with CFR 0.152.
 */
package org.bioimageanalysis.icy.icytomine.ui.core.explorer;

import icy.resource.ResourceUtil;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.image.BufferedImage;
import javax.swing.BoxLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import org.bioimageanalysis.icy.icytomine.core.model.Image;
import org.bioimageanalysis.icy.icytomine.ui.core.explorer.ImageDetailsPanelController;
import org.bioimageanalysis.icy.icytomine.ui.core.explorer.ImagePanel;
import org.ehcache.Cache;

public class ImageDetailsPanel
extends JPanel {
    private static final long serialVersionUID = 6055883183949045447L;
    protected static final ImageIcon defaultIcon = new ImageIcon(ResourceUtil.ICON_PICTURE);
    private JScrollPane scrollPaneDetails;
    private JPanel imageDetailsPanel;
    private JTextArea fileNameLabel;
    private JLabel previewLabel;
    private JTextArea imageIdTextArea;
    private JTextArea imageDimensionTextArea;
    private JTextArea imageMagnificationTextArea;
    private JButton imageMagnificationEditButton;
    private JTextArea numberOfAlgoAnnotationsTextArea;
    private JTextArea numberOfUserAnnotationsTextArea;
    private JTextArea imageSizeTextArea;
    private JTextArea imageResolutionTextArea;
    private JButton imageResolutionEditButton;
    private JTextArea imageDepthTextArea;
    private JTextArea imageCreationDateTextArea;
    private ImageDetailsPanelController controller;

    public ImageDetailsPanel() {
        this.setView();
        this.setController();
    }

    private void setView() {
        this.setMinimumSize(new Dimension(150, 300));
        this.setPreferredSize(new Dimension(301, 400));
        this.setLayout(new BoxLayout(this, 1));
        this.addTitleLabel();
        this.addImageDetailsPanel();
    }

    private void addTitleLabel() {
        JLabel lblImageDetails = new JLabel("Image Details");
        lblImageDetails.setAlignmentX(0.5f);
        lblImageDetails.setFont(new Font("Tahoma", 1, 11));
        this.add(lblImageDetails);
    }

    private void addImageDetailsPanel() {
        this.scrollPaneDetails = new JScrollPane();
        this.scrollPaneDetails.setMinimumSize(new Dimension(100, 23));
        this.add(this.scrollPaneDetails);
        this.imageDetailsPanel = new JPanel();
        this.imageDetailsPanel.setBackground(UIManager.getColor("Panel.background"));
        GridBagLayout imageDetailsPanelLayout = new GridBagLayout();
        imageDetailsPanelLayout.columnWidths = new int[]{0, 0, 0};
        imageDetailsPanelLayout.rowHeights = new int[]{30, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 30};
        imageDetailsPanelLayout.columnWeights = new double[]{0.0, 0.0, 0.0};
        imageDetailsPanelLayout.rowWeights = new double[]{Double.MIN_VALUE, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, Double.MIN_VALUE};
        this.imageDetailsPanel.setLayout(imageDetailsPanelLayout);
        this.scrollPaneDetails.setViewportView(this.imageDetailsPanel);
        this.addImageTitle();
        this.addImagePreview();
        this.addImageID();
        this.addImageDimension();
        this.addImageMagnification();
        this.addNumberOfAlgoAnnotations();
        this.addNumberOfUserAnnotations();
        this.addImageSize();
        this.addImageResolution();
        this.addImageDepth();
        this.addImageCreationDate();
    }

    private void addImageTitle() {
        this.fileNameLabel = new JTextArea("ImageFileName...longName");
        this.fileNameLabel.setMinimumSize(new Dimension(220, 22));
        this.fileNameLabel.setLineWrap(true);
        this.fileNameLabel.setOpaque(false);
        this.fileNameLabel.setFont(new Font("Tahoma", 1, 15));
        GridBagConstraints fileNameLabelConstraints = new GridBagConstraints(0, 1, 3, 1, 0.0, 0.0, 10, 1, new Insets(0, 10, 10, 10), 0, 0);
        this.imageDetailsPanel.add((Component)this.fileNameLabel, fileNameLabelConstraints);
    }

    private void addImagePreview() {
        this.previewLabel = new JLabel("");
        this.previewLabel.setDoubleBuffered(true);
        this.previewLabel.setMaximumSize(new Dimension(200, 200));
        this.previewLabel.setVerticalAlignment(1);
        this.previewLabel.setHorizontalAlignment(0);
        this.previewLabel.setIcon(defaultIcon);
        GridBagConstraints previewLabelConstraints = new GridBagConstraints(0, 2, 3, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 5, 0), 0, 0);
        this.imageDetailsPanel.add((Component)this.previewLabel, previewLabelConstraints);
    }

    private void addImageID() {
        JLabel imageIdLabel = new JLabel("ID");
        imageIdLabel.setFocusable(false);
        imageIdLabel.setFont(new Font("Tahoma", 1, 12));
        imageIdLabel.setHorizontalAlignment(4);
        GridBagConstraints gbc_lblId = new GridBagConstraints(0, 3, 1, 1, 0.0, 0.0, 13, 1, new Insets(0, 0, 5, 10), 0, 0);
        this.imageDetailsPanel.add((Component)imageIdLabel, gbc_lblId);
        this.imageIdTextArea = new JTextArea("12345678");
        this.imageIdTextArea.setEditable(false);
        this.imageIdTextArea.setLineWrap(true);
        this.imageIdTextArea.setWrapStyleWord(true);
        this.imageIdTextArea.setOpaque(false);
        this.imageIdTextArea.setFont(new Font("Tahoma", 0, 11));
        GridBagConstraints gbc_lblIdValue = new GridBagConstraints(1, 3, 2, 1, 0.0, 0.0, 17, 3, new Insets(0, 0, 5, 0), 0, 0);
        this.imageDetailsPanel.add((Component)this.imageIdTextArea, gbc_lblIdValue);
    }

    private void addImageDimension() {
        JLabel dimensionLabel = new JLabel("Dimension");
        dimensionLabel.setFocusable(false);
        dimensionLabel.setFont(new Font("Tahoma", 1, 12));
        dimensionLabel.setHorizontalAlignment(4);
        GridBagConstraints dimensionLabelConstraints = new GridBagConstraints(0, 4, 1, 1, 0.0, 0.0, 13, 13, new Insets(0, 0, 5, 10), 0, 0);
        this.imageDetailsPanel.add((Component)dimensionLabel, dimensionLabelConstraints);
        this.imageDimensionTextArea = new JTextArea("12.35 x 12.35 \u00b5m");
        this.imageDimensionTextArea.setEditable(false);
        this.imageDimensionTextArea.setLineWrap(true);
        this.imageDimensionTextArea.setWrapStyleWord(true);
        this.imageDimensionTextArea.setFont(new Font("Tahoma", 0, 11));
        this.imageDimensionTextArea.setOpaque(false);
        GridBagConstraints dimensionTextAreaConstraints = new GridBagConstraints(1, 4, 2, 1, 0.0, 0.0, 17, 3, new Insets(0, 0, 5, 0), 0, 0);
        this.imageDetailsPanel.add((Component)this.imageDimensionTextArea, dimensionTextAreaConstraints);
    }

    private void addImageMagnification() {
        JLabel magnificationLabel = new JLabel("Magnification");
        magnificationLabel.setFocusable(false);
        magnificationLabel.setFont(new Font("Tahoma", 1, 12));
        magnificationLabel.setHorizontalAlignment(4);
        GridBagConstraints magnificationLabelConstraints = new GridBagConstraints(0, 5, 1, 1, 0.0, 0.0, 13, 1, new Insets(0, 0, 5, 10), 0, 0);
        this.imageDetailsPanel.add((Component)magnificationLabel, magnificationLabelConstraints);
        this.imageMagnificationTextArea = new JTextArea("20X");
        this.imageMagnificationTextArea.setEditable(false);
        this.imageMagnificationTextArea.setLineWrap(true);
        this.imageMagnificationTextArea.setWrapStyleWord(true);
        this.imageMagnificationTextArea.setFont(new Font("Tahoma", 0, 11));
        this.imageMagnificationTextArea.setOpaque(false);
        GridBagConstraints magnificationTextAreaConstraints = new GridBagConstraints(1, 5, 1, 1, 0.0, 0.0, 17, 3, new Insets(0, 0, 5, 5), 0, 0);
        this.imageDetailsPanel.add((Component)this.imageMagnificationTextArea, magnificationTextAreaConstraints);
        this.imageMagnificationEditButton = new JButton("Edit");
        GridBagConstraints magnificationEditButtonConstraints = new GridBagConstraints(2, 5, 1, 1, 0.0, 0.0, 17, 1, new Insets(0, 0, 5, 0), 0, 0);
        this.imageDetailsPanel.add((Component)this.imageMagnificationEditButton, magnificationEditButtonConstraints);
    }

    private void addNumberOfAlgoAnnotations() {
        JLabel numberOfAlgoAnnotationsLabel = new JLabel("<html>Annotations<br>(Algorithms)");
        numberOfAlgoAnnotationsLabel.setFocusable(false);
        numberOfAlgoAnnotationsLabel.setHorizontalAlignment(4);
        numberOfAlgoAnnotationsLabel.setMaximumSize(new Dimension(80, 22));
        numberOfAlgoAnnotationsLabel.setFont(new Font("Tahoma", 1, 12));
        GridBagConstraints numberOfAlgoAnnotationLabelConstraints = new GridBagConstraints(0, 6, 1, 1, 0.0, 0.0, 13, 1, new Insets(0, 0, 5, 10), 0, 0);
        this.imageDetailsPanel.add((Component)numberOfAlgoAnnotationsLabel, numberOfAlgoAnnotationLabelConstraints);
        this.numberOfAlgoAnnotationsTextArea = new JTextArea("14");
        this.numberOfAlgoAnnotationsTextArea.setEditable(false);
        this.numberOfAlgoAnnotationsTextArea.setLineWrap(true);
        this.numberOfAlgoAnnotationsTextArea.setWrapStyleWord(true);
        this.numberOfAlgoAnnotationsTextArea.setFont(new Font("Tahoma", 0, 11));
        this.numberOfAlgoAnnotationsTextArea.setOpaque(false);
        GridBagConstraints numberOfAlgoAnnotationsTextAreaConstraints = new GridBagConstraints(1, 6, 2, 1, 0.0, 0.0, 17, 3, new Insets(0, 0, 5, 0), 0, 0);
        this.imageDetailsPanel.add((Component)this.numberOfAlgoAnnotationsTextArea, numberOfAlgoAnnotationsTextAreaConstraints);
    }

    private void addNumberOfUserAnnotations() {
        JLabel numberOfUserAnnotationsLabel = new JLabel("<html>Annotations<br>(User)");
        numberOfUserAnnotationsLabel.setFocusable(false);
        numberOfUserAnnotationsLabel.setHorizontalAlignment(4);
        numberOfUserAnnotationsLabel.setMaximumSize(new Dimension(80, 22));
        numberOfUserAnnotationsLabel.setFont(new Font("Tahoma", 1, 12));
        GridBagConstraints numberOfUserAnnotationLabelConstraints = new GridBagConstraints(0, 7, 1, 1, 0.0, 0.0, 13, 1, new Insets(0, 0, 5, 10), 0, 0);
        this.imageDetailsPanel.add((Component)numberOfUserAnnotationsLabel, numberOfUserAnnotationLabelConstraints);
        this.numberOfUserAnnotationsTextArea = new JTextArea("14");
        this.numberOfUserAnnotationsTextArea.setEditable(false);
        this.numberOfUserAnnotationsTextArea.setLineWrap(true);
        this.numberOfUserAnnotationsTextArea.setWrapStyleWord(true);
        this.numberOfUserAnnotationsTextArea.setOpaque(false);
        this.numberOfUserAnnotationsTextArea.setFont(new Font("Tahoma", 0, 11));
        GridBagConstraints numberOfUserAnnotationsTextAreaConstraints = new GridBagConstraints(1, 7, 2, 1, 0.0, 0.0, 17, 3, new Insets(0, 0, 5, 0), 0, 0);
        this.imageDetailsPanel.add((Component)this.numberOfUserAnnotationsTextArea, numberOfUserAnnotationsTextAreaConstraints);
    }

    private void addImageSize() {
        JLabel imageSizeLabel = new JLabel("Size");
        imageSizeLabel.setFocusable(false);
        imageSizeLabel.setHorizontalAlignment(4);
        imageSizeLabel.setFont(new Font("Tahoma", 1, 11));
        GridBagConstraints imageSizeLabelConstraints = new GridBagConstraints(0, 8, 1, 1, 0.0, 0.0, 13, 1, new Insets(0, 0, 5, 10), 0, 0);
        this.imageDetailsPanel.add((Component)imageSizeLabel, imageSizeLabelConstraints);
        this.imageSizeTextArea = new JTextArea("20000 x 20000 px");
        this.imageSizeTextArea.setEditable(false);
        this.imageSizeTextArea.setLineWrap(true);
        this.imageSizeTextArea.setWrapStyleWord(true);
        this.imageSizeTextArea.setOpaque(false);
        this.imageSizeTextArea.setFont(new Font("Tahoma", 0, 11));
        GridBagConstraints imageSizeTextAreaConstraints = new GridBagConstraints(1, 8, 2, 1, 0.0, 0.0, 17, 3, new Insets(0, 0, 5, 0), 0, 0);
        this.imageDetailsPanel.add((Component)this.imageSizeTextArea, imageSizeTextAreaConstraints);
    }

    private void addImageResolution() {
        JLabel imageResolutionLabel = new JLabel("Pixel Resolution");
        imageResolutionLabel.setFocusable(false);
        imageResolutionLabel.setFont(new Font("Tahoma", 1, 11));
        imageResolutionLabel.setHorizontalAlignment(4);
        GridBagConstraints imageResolutionLabelConstraints = new GridBagConstraints(0, 9, 1, 1, 0.0, 0.0, 13, 1, new Insets(0, 0, 5, 10), 0, 0);
        this.imageDetailsPanel.add((Component)imageResolutionLabel, imageResolutionLabelConstraints);
        this.imageResolutionTextArea = new JTextArea("2.8 \u00b5m/px");
        this.imageResolutionTextArea.setPreferredSize(new Dimension(80, 22));
        this.imageResolutionTextArea.setMinimumSize(new Dimension(60, 22));
        this.imageResolutionTextArea.setEditable(false);
        this.imageResolutionTextArea.setLineWrap(true);
        this.imageResolutionTextArea.setWrapStyleWord(true);
        this.imageResolutionTextArea.setOpaque(false);
        this.imageResolutionTextArea.setFont(new Font("Tahoma", 0, 11));
        GridBagConstraints imageResolutionTextAreaConstraints = new GridBagConstraints(1, 9, 1, 1, 0.0, 0.0, 17, 3, new Insets(0, 0, 5, 5), 0, 0);
        this.imageDetailsPanel.add((Component)this.imageResolutionTextArea, imageResolutionTextAreaConstraints);
        this.imageResolutionEditButton = new JButton("Edit");
        GridBagConstraints imageResolutionEditButtonConstraints = new GridBagConstraints(2, 9, 1, 1, 0.0, 0.0, 17, 1, new Insets(0, 0, 5, 0), 0, 0);
        this.imageDetailsPanel.add((Component)this.imageResolutionEditButton, imageResolutionEditButtonConstraints);
    }

    private void addImageDepth() {
        JLabel imageDepthLabel = new JLabel("Depth");
        imageDepthLabel.setFocusable(false);
        imageDepthLabel.setFont(new Font("Tahoma", 1, 11));
        imageDepthLabel.setHorizontalAlignment(4);
        GridBagConstraints imageDepthLabelConstraints = new GridBagConstraints(0, 10, 1, 1, 0.0, 0.0, 13, 1, new Insets(0, 0, 5, 10), 0, 0);
        this.imageDetailsPanel.add((Component)imageDepthLabel, imageDepthLabelConstraints);
        this.imageDepthTextArea = new JTextArea("8 levels");
        this.imageDepthTextArea.setEditable(false);
        this.imageDepthTextArea.setLineWrap(true);
        this.imageDepthTextArea.setWrapStyleWord(true);
        this.imageDepthTextArea.setOpaque(false);
        this.imageDepthTextArea.setFont(new Font("Tahoma", 0, 11));
        GridBagConstraints imageDepthTextAreaConstraints = new GridBagConstraints(1, 10, 2, 1, 0.0, 0.0, 17, 3, new Insets(0, 0, 5, 0), 0, 0);
        this.imageDetailsPanel.add((Component)this.imageDepthTextArea, imageDepthTextAreaConstraints);
    }

    private void addImageCreationDate() {
        JLabel imageCreationDateLabel = new JLabel("Created on");
        imageCreationDateLabel.setFocusable(false);
        imageCreationDateLabel.setFont(new Font("Tahoma", 1, 11));
        imageCreationDateLabel.setHorizontalAlignment(4);
        GridBagConstraints gbc_lblDateCreation = new GridBagConstraints(0, 11, 1, 1, 0.0, 0.0, 12, 1, new Insets(0, 0, 0, 10), 0, 0);
        this.imageDetailsPanel.add((Component)imageCreationDateLabel, gbc_lblDateCreation);
        this.imageCreationDateTextArea = new JTextArea("June 8, 2017");
        this.imageCreationDateTextArea.setEditable(false);
        this.imageCreationDateTextArea.setLineWrap(true);
        this.imageCreationDateTextArea.setWrapStyleWord(true);
        this.imageCreationDateTextArea.setOpaque(false);
        this.imageCreationDateTextArea.setFont(new Font("Tahoma", 0, 11));
        GridBagConstraints gbc_lblDateCreationValue = new GridBagConstraints(1, 11, 2, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0);
        this.imageDetailsPanel.add((Component)this.imageCreationDateTextArea, gbc_lblDateCreationValue);
    }

    private void setController() {
        this.controller = new ImageDetailsPanelController(this);
    }

    public void setCurrentImage(Image image) {
        this.controller.setCurrentImage(image);
    }

    public void updateLayout() {
        SwingUtilities.invokeLater(() -> {
            this.scrollPaneDetails.getVerticalScrollBar().setValue(this.scrollPaneDetails.getVerticalScrollBar().getMinimum());
            this.scrollPaneDetails.getHorizontalScrollBar().setValue(this.scrollPaneDetails.getHorizontalScrollBar().getMinimum());
        });
        this.imageDetailsPanel.revalidate();
        this.imageDetailsPanel.repaint();
    }

    public Image getCurrentImage() {
        return this.controller.getCurrentImage();
    }

    public void setPreviewCache(Cache<Long, BufferedImage> cache) {
        this.controller.setPreviewCache(cache);
    }

    public void addImagePreviewDoubleClickListener(ImagePanel.ImageSelectionListener listener) {
        this.controller.addImagePreviewDoubleClickListener(listener);
    }

    public void addImageMagnificationChangeListener(ImageDetailsPanelController.ImageMagnificationChangeListener listener) {
        this.controller.addImageMagnificationChangeListener(listener);
    }

    public void addImageResolutionChangeListener(ImageDetailsPanelController.ImageResolutionChangeListener listener) {
        this.controller.addImageResolutionChangeListener(listener);
    }

    protected static ImageIcon getDefaulticon() {
        return defaultIcon;
    }

    protected JTextArea getFileNameLabel() {
        return this.fileNameLabel;
    }

    protected JLabel getPreviewLabel() {
        return this.previewLabel;
    }

    protected JTextArea getImageIdTextArea() {
        return this.imageIdTextArea;
    }

    protected JTextArea getImageDimensionTextArea() {
        return this.imageDimensionTextArea;
    }

    protected JTextArea getImageMagnificationTextArea() {
        return this.imageMagnificationTextArea;
    }

    protected JButton getImageMagnificationEditButton() {
        return this.imageMagnificationEditButton;
    }

    protected JTextArea getNumberOfAlgoAnnotationsTextArea() {
        return this.numberOfAlgoAnnotationsTextArea;
    }

    protected JTextArea getNumberOfUserAnnotationsTextArea() {
        return this.numberOfUserAnnotationsTextArea;
    }

    protected JTextArea getImageSizeTextArea() {
        return this.imageSizeTextArea;
    }

    protected JTextArea getImageResolutionTextArea() {
        return this.imageResolutionTextArea;
    }

    protected JButton getImageResolutionEditButton() {
        return this.imageResolutionEditButton;
    }

    protected JTextArea getImageDepthTextArea() {
        return this.imageDepthTextArea;
    }

    protected JTextArea getImageCreationDateTextArea() {
        return this.imageCreationDateTextArea;
    }
}

