/*
 * Decompiled with CFR 0.152.
 */
package org.bioimageanalysis.icy.icytomine.ui.core.explorer;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.SystemColor;
import javax.swing.DefaultListModel;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import org.bioimageanalysis.icy.icytomine.core.model.Image;
import org.bioimageanalysis.icy.icytomine.core.model.Project;
import org.bioimageanalysis.icy.icytomine.ui.core.explorer.ImagePanelController;

public class ImagePanel
extends JPanel {
    private static final long serialVersionUID = 5990256964181871478L;
    private JLabel titleLabel;
    private JTextField searchBar;
    private JList<ImageItem> imageList;
    private ImagePanelController controller;

    private static GridBagConstraints getConstraints(int x, int y, int width, int height, Insets insets, int fill) {
        GridBagConstraints constraints = new GridBagConstraints();
        constraints.fill = fill;
        constraints.gridx = x;
        constraints.gridy = y;
        constraints.gridwidth = width;
        constraints.gridheight = height;
        constraints.insets = insets;
        return constraints;
    }

    public ImagePanel() {
        this.setView();
        this.setController();
    }

    private void setView() {
        this.setMinimumSize(new Dimension(50, 50));
        this.setPreferredSize(new Dimension(240, 400));
        this.setGridBagLayout();
        this.addTitleLabel();
        this.addSearchBar();
        this.addImageList();
    }

    private void setGridBagLayout() {
        GridBagLayout gridBagLayout = new GridBagLayout();
        gridBagLayout.columnWidths = new int[]{0, 0};
        gridBagLayout.rowHeights = new int[]{0, 0, 0};
        gridBagLayout.columnWeights = new double[]{0.0, 1.0};
        gridBagLayout.rowWeights = new double[]{0.0, 0.0, 1.0};
        this.setLayout(gridBagLayout);
    }

    private void addTitleLabel() {
        this.buildPanelTitle();
        this.add((Component)this.titleLabel, ImagePanel.getConstraints(0, 0, 2, 1, new Insets(0, 3, 3, 3), 1));
    }

    private void buildPanelTitle() {
        this.titleLabel = new JLabel("Images");
        this.titleLabel.setFont(new Font("Tahoma", 1, 11));
        this.titleLabel.setAlignmentX(0.5f);
        this.titleLabel.setToolTipText("Images available for the selected project");
        this.titleLabel.setBackground(SystemColor.control);
        this.titleLabel.setHorizontalAlignment(0);
    }

    private void addSearchBar() {
        JLabel searchBarTitle = new JLabel("Search:");
        this.add((Component)searchBarTitle, ImagePanel.getConstraints(0, 1, 1, 1, new Insets(0, 3, 3, 0), 1));
        this.buildSearchBar();
        this.add((Component)this.searchBar, ImagePanel.getConstraints(1, 1, 1, 1, new Insets(0, 3, 3, 3), 1));
    }

    private void buildSearchBar() {
        this.searchBar = new JTextField();
        this.searchBar.setToolTipText("Search projects by their name");
    }

    private void addImageList() {
        JScrollPane scrollPane = this.createImageList();
        this.add((Component)scrollPane, ImagePanel.getConstraints(0, 2, 2, 1, new Insets(0, 3, 3, 3), 1));
    }

    private JScrollPane createImageList() {
        JScrollPane scrollPane = new JScrollPane();
        this.imageList = new JList();
        this.imageList.setBackground(SystemColor.window);
        this.imageList.setModel(new DefaultListModel());
        this.imageList.setSelectionMode(0);
        this.titleLabel.setLabelFor(this.imageList);
        scrollPane.setViewportView(this.imageList);
        return scrollPane;
    }

    private void setController() {
        this.controller = new ImagePanelController(this);
    }

    public void setProject(Project project) {
        this.controller.setProject(project);
    }

    public void addImageSelectionListener(ImageSelectionListener listener) {
        this.controller.addImageSelectionListener(listener);
    }

    public void removeImageSelectionListener(ImageSelectionListener listener) {
        this.controller.removeImageSelectionListener(listener);
    }

    public void addImageDoubleClickListener(ImageSelectionListener listener) {
        this.controller.addImageDoubleClickListener(listener);
    }

    public void removeImageDoubleClickListener(ImageSelectionListener listener) {
        this.controller.removeImageDoubleClickListener(listener);
    }

    public JList<ImageItem> getImageList() {
        return this.imageList;
    }

    public JTextField getSearchBar() {
        return this.searchBar;
    }

    public Image getSelectedImage() {
        if (this.getImageList().isSelectionEmpty()) {
            return null;
        }
        return this.getImageList().getSelectedValue().getImage();
    }

    @FunctionalInterface
    public static interface ImageSelectionListener {
        public void imageSelected(Image var1);
    }

    public static class ImageItem {
        private Image image;

        public ImageItem(Image image) {
            this.image = image;
        }

        public Image getImage() {
            return this.image;
        }

        public boolean equals(Object obj) {
            if (obj == null) {
                return false;
            }
            if (!(obj instanceof ImageItem)) {
                return false;
            }
            ImageItem other = (ImageItem)obj;
            return this.getImage().equals(other.getImage());
        }

        public String toString() {
            return this.image.getName().orElse(String.format("Not specified (id=%d)", (long)this.image.getId()));
        }
    }
}

