/*
 * Decompiled with CFR 0.152.
 */
package org.bioimageanalysis.icy.icytomine.ui.core.explorer;

import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.ListSelectionListener;
import org.bioimageanalysis.icy.icytomine.core.connection.client.CytomineClientException;
import org.bioimageanalysis.icy.icytomine.core.model.Image;
import org.bioimageanalysis.icy.icytomine.core.model.Project;
import org.bioimageanalysis.icy.icytomine.ui.core.explorer.ImagePanel;

public class ImagePanelController {
    private ImagePanel panel;
    private Optional<Project> project;
    private Map<ImagePanel.ImageSelectionListener, ListSelectionListener> listSelectionListeners;
    private Map<ImagePanel.ImageSelectionListener, MouseListener> listDoubleClickListeners;
    private Set<Image> availableImages;
    private Image currentImage;

    public ImagePanelController(ImagePanel imagePanel) {
        this.panel = imagePanel;
        this.project = Optional.ofNullable(null);
        this.listSelectionListeners = new HashMap<ImagePanel.ImageSelectionListener, ListSelectionListener>();
        this.listDoubleClickListeners = new HashMap<ImagePanel.ImageSelectionListener, MouseListener>();
        this.availableImages = new HashSet<Image>(0);
        this.currentImage = null;
        this.panel.getSearchBar().getDocument().addDocumentListener(this.getSearchBarChangeHandler());
    }

    private DocumentListener getSearchBarChangeHandler() {
        return new DocumentListener(){

            @Override
            public void removeUpdate(DocumentEvent e) {
                ImagePanelController.this.updateImageList();
            }

            @Override
            public void insertUpdate(DocumentEvent e) {
                ImagePanelController.this.updateImageList();
            }

            @Override
            public void changedUpdate(DocumentEvent e) {
                ImagePanelController.this.updateImageList();
            }
        };
    }

    private void updateImageList() throws CytomineClientException {
        this.applySearchCriterion();
        ImagePanel.ImageItem[] images = this.getImageItemArray(this.availableImages);
        this.panel.getImageList().setValueIsAdjusting(true);
        this.panel.getImageList().setListData((ImagePanel.ImageItem[])images);
        if (this.availableImages.size() == 1) {
            this.panel.getImageList().setSelectedValue(images[0], true);
        } else if (this.currentImage != null && this.availableImages.contains(this.currentImage)) {
            this.panel.getImageList().setSelectedValue(new ImagePanel.ImageItem(this.currentImage), true);
        } else {
            this.panel.getImageList().clearSelection();
        }
        this.panel.getImageList().setValueIsAdjusting(false);
    }

    private ImagePanel.ImageItem[] getImageItemArray(Collection<Image> imageCollection) {
        return (ImagePanel.ImageItem[])imageCollection.stream().map(ima -> new ImagePanel.ImageItem((Image)ima)).toArray(ImagePanel.ImageItem[]::new);
    }

    private void applySearchCriterion() {
        Pattern searchPattern = this.getSearchPattern();
        this.availableImages = this.getProjectImages().stream().filter(p -> searchPattern.matcher(p.getName().orElse("not available").toLowerCase()).matches() || searchPattern.matcher(p.getId().toString()).matches()).collect(Collectors.toSet());
    }

    private Pattern getSearchPattern() {
        String searchCriterion = this.panel.getSearchBar().getText();
        if (searchCriterion.isEmpty()) {
            return Pattern.compile(".*");
        }
        return Pattern.compile(".*" + searchCriterion.toLowerCase() + ".*");
    }

    private List<Image> getProjectImages() {
        if (this.project.isPresent()) {
            return this.project.get().getImages(false);
        }
        return new ArrayList<Image>(0);
    }

    public void setProject(Project project) {
        if (!Objects.equals(this.project.orElse(null), project)) {
            this.project = Optional.ofNullable(project);
            try {
                this.updateImageList();
            }
            catch (CytomineClientException e) {
                e.printStackTrace();
            }
        }
    }

    public void addImageSelectionListener(ImagePanel.ImageSelectionListener listener) {
        ListSelectionListener listSelectionListener = this.createListSelectionListener(listener);
        this.listSelectionListeners.put(listener, listSelectionListener);
        this.panel.getImageList().addListSelectionListener(listSelectionListener);
    }

    private ListSelectionListener createListSelectionListener(ImagePanel.ImageSelectionListener listener) {
        return event -> {
            Image image;
            if (!event.getValueIsAdjusting() && !Objects.equals(this.currentImage, image = this.panel.getSelectedImage())) {
                this.currentImage = image;
                listener.imageSelected(this.currentImage);
            }
        };
    }

    public void removeImageSelectionListener(ImagePanel.ImageSelectionListener listener) {
        ListSelectionListener listSelectionListener = this.listSelectionListeners.remove(listener);
        if (listSelectionListener != null) {
            this.panel.getImageList().removeListSelectionListener(listSelectionListener);
        }
    }

    public void addImageDoubleClickListener(ImagePanel.ImageSelectionListener listener) {
        MouseListener listDoubleClickListener = this.createListDoubleClickListener(listener);
        this.listDoubleClickListeners.put(listener, listDoubleClickListener);
        this.panel.getImageList().addMouseListener(listDoubleClickListener);
    }

    private MouseListener createListDoubleClickListener(final ImagePanel.ImageSelectionListener listener) {
        return new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                int index;
                if (e.getClickCount() == 2 && (index = ImagePanelController.this.panel.getImageList().locationToIndex(e.getPoint())) > -1) {
                    listener.imageSelected(ImagePanelController.this.panel.getImageList().getSelectedValue().getImage());
                }
            }
        };
    }

    public void removeImageDoubleClickListener(ImagePanel.ImageSelectionListener listener) {
        MouseListener listDoubleClickListener = this.listDoubleClickListeners.remove(listener);
        if (listDoubleClickListener != null) {
            this.panel.getImageList().removeMouseListener(listDoubleClickListener);
        }
    }
}

