/*
 * Decompiled with CFR 0.152.
 */
package org.bioimageanalysis.icy.icytomine.ui.core.viewer.components.panel.annotations.actions;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.util.Set;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.bioimageanalysis.icy.icytomine.core.model.Term;
import org.bioimageanalysis.icy.icytomine.ui.core.viewer.components.panel.annotations.actions.AnnotationTermSelectionPanelController;
import org.bioimageanalysis.icy.icytomine.ui.general.JCheckedComboBox;

public class AnnotationTermSelectionPanel
extends JPanel {
    private JCheckedComboBox<TermItem> termComboBox;
    private JButton termSetButton;
    private AnnotationTermSelectionPanelController panelController;

    public AnnotationTermSelectionPanel() {
        this.setView();
        this.setController();
    }

    private void setView() {
        this.setGridBagLayout();
        this.addLabel();
        this.addTermComboBox();
        this.addTermSetButton();
    }

    private void setGridBagLayout() {
        GridBagLayout gridBagLayout = new GridBagLayout();
        gridBagLayout.columnWidths = new int[]{0, 0, 0, 0};
        gridBagLayout.rowHeights = new int[]{23, 0};
        gridBagLayout.columnWeights = new double[]{0.0, 0.0, 0.0, Double.MIN_VALUE};
        gridBagLayout.rowWeights = new double[]{0.0, Double.MIN_VALUE};
        this.setLayout(gridBagLayout);
    }

    private void addLabel() {
        JLabel titleLabel = new JLabel("Associated terms");
        GridBagConstraints titleLabelConstraints = new GridBagConstraints();
        titleLabelConstraints.insets = new Insets(2, 5, 2, 5);
        titleLabelConstraints.gridx = 0;
        titleLabelConstraints.gridy = 0;
        this.add((Component)titleLabel, titleLabelConstraints);
    }

    private void addTermComboBox() {
        this.termComboBox = new JCheckedComboBox();
        GridBagConstraints termComboBoxConstraints = new GridBagConstraints();
        termComboBoxConstraints.weightx = 1.0;
        termComboBoxConstraints.fill = 2;
        termComboBoxConstraints.insets = new Insets(2, 0, 2, 5);
        termComboBoxConstraints.gridx = 1;
        termComboBoxConstraints.gridy = 0;
        this.add(this.termComboBox, termComboBoxConstraints);
    }

    private void addTermSetButton() {
        this.termSetButton = new JButton("Set");
        GridBagConstraints termSetConstraints = new GridBagConstraints();
        termSetConstraints.insets = new Insets(2, 0, 2, 5);
        termSetConstraints.gridx = 2;
        termSetConstraints.gridy = 0;
        this.add((Component)this.termSetButton, termSetConstraints);
    }

    private void setController() {
        this.panelController = new AnnotationTermSelectionPanelController(this);
    }

    public void setAvailableTerms(Set<Term> terms) {
        this.panelController.setAvailableTerms(terms);
    }

    public JCheckedComboBox<TermItem> getTermComboBox() {
        return this.termComboBox;
    }

    public JButton getTermSetButton() {
        return this.termSetButton;
    }

    public void setSelectedTerms(Set<Term> terms) {
        this.panelController.setSelectedTerms(terms);
    }

    public void addTermSelectionCommitListener(AnnotationTermSelectionPanelController.AnnotationTermSelectionCommitListener listener) {
        this.panelController.addTermSelectionCommitListener(listener);
    }

    public void removeTermSelectionCommitListener(AnnotationTermSelectionPanelController.AnnotationTermSelectionCommitListener listener) {
        this.panelController.removeTermSelectionCommitListener(listener);
    }

    static class TermItem {
        public static final TermItem NO_TERM = new TermItem(null);
        private Term term;

        public TermItem(Term term) {
            this.term = term;
        }

        public Term getTerm() {
            return this.term;
        }

        public String toString() {
            if (this.term != null) {
                return this.term.getName().orElse("Not specified");
            }
            return "No term";
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.term == null ? 0 : this.term.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (!(obj instanceof TermItem)) {
                return false;
            }
            TermItem other = (TermItem)obj;
            return !(this.term == null ? other.term != null : !this.term.equals(other.term));
        }
    }
}

