/*
 * Decompiled with CFR 0.152.
 */
package org.bioimageanalysis.icy.icytomine.ui.core.viewer.components.panel.annotations.filter;

import java.awt.event.ActionEvent;
import java.util.HashSet;
import java.util.Set;
import java.util.stream.Collectors;
import javax.swing.ComboBoxModel;
import org.bioimageanalysis.icy.icytomine.core.model.User;
import org.bioimageanalysis.icy.icytomine.core.model.filters.AnnotationFilter;
import org.bioimageanalysis.icy.icytomine.core.model.filters.AnnotationFilterByUser;
import org.bioimageanalysis.icy.icytomine.ui.core.viewer.components.panel.annotations.filter.AnnotationFilterPanel;
import org.bioimageanalysis.icy.icytomine.ui.general.JCheckableItem;
import org.bioimageanalysis.icy.icytomine.ui.general.JCheckedComboBox;

public class AnnotationFilterByUserPanel
extends AnnotationFilterPanel<AnnotationFilterByUser.UserItem> {
    AnnotationFilterByUser userFilter;
    private Set<AnnotationFilterByUser.UserItem> userItems;

    public AnnotationFilterByUserPanel() {
        this.setLabelText("Users:");
        this.userFilter = new AnnotationFilterByUser();
        this.setFilter(this.userFilter);
    }

    public void setPreviousFilter(AnnotationFilter previousFilter) {
        this.userFilter.setPreviousFilter(previousFilter);
    }

    public void setUsers(Set<User> users) {
        this.userItems = users.stream().map(u -> new AnnotationFilterByUser.UserItem((User)u)).collect(Collectors.toSet());
        this.userItems.add(AnnotationFilterByUser.UserItem.NO_USER);
        this.userItems.add(AnnotationFilterByUser.UserItem.ALL);
        this.userItems.add(AnnotationFilterByUser.UserItem.NONE);
        this.userFilter.setActiveUsers(new HashSet<AnnotationFilterByUser.UserItem>(this.userItems));
        this.setModel(this.userItems.toArray(new AnnotationFilterByUser.UserItem[this.userItems.size()]), u -> u.toString());
    }

    @Override
    protected void choiceChanged(ActionEvent e) {
        JCheckableItem checkableItem = (JCheckableItem)((JCheckedComboBox)e.getSource()).getSelectedItem();
        AnnotationFilterByUser.UserItem userItem = (AnnotationFilterByUser.UserItem)checkableItem.object;
        if (userItem == AnnotationFilterByUser.UserItem.ALL) {
            Set<AnnotationFilterByUser.UserItem> activeUsers = this.userFilter.getActiveUsers();
            this.userItems.stream().filter(u -> u != AnnotationFilterByUser.UserItem.ALL && u != AnnotationFilterByUser.UserItem.NONE).forEach(u -> activeUsers.add((AnnotationFilterByUser.UserItem)u));
            ComboBoxModel model = ((JCheckedComboBox)e.getSource()).getModel();
            for (int i = 0; i < model.getSize(); ++i) {
                JCheckableItem elem = (JCheckableItem)model.getElementAt(i);
                if (elem.getObject() == AnnotationFilterByUser.UserItem.NONE) {
                    elem.setSelected(false);
                    continue;
                }
                elem.setSelected(true);
            }
            ((JCheckedComboBox)e.getSource()).invalidate();
        } else if (userItem == AnnotationFilterByUser.UserItem.NONE) {
            this.userFilter.getActiveUsers().removeAll(this.userItems);
            ComboBoxModel model = ((JCheckedComboBox)e.getSource()).getModel();
            for (int i = 0; i < model.getSize(); ++i) {
                JCheckableItem elem = (JCheckableItem)model.getElementAt(i);
                elem.setSelected(false);
            }
            ((JCheckedComboBox)e.getSource()).invalidate();
        } else if (!checkableItem.isSelected()) {
            this.userFilter.getActiveUsers().add(userItem);
        } else {
            this.userFilter.getActiveUsers().remove(userItem);
        }
        this.userFilter.computeActiveAnnotations(AnnotationFilter.ComputationMode.RECOMPUTE_JUST_THIS);
    }
}

