/*
 * Decompiled with CFR 0.152.
 */
package org.bioimageanalysis.icy.icytomine.ui.core.viewer.components.panel.annotations.filter;

import java.util.HashSet;
import java.util.LinkedList;
import java.util.Objects;
import java.util.Set;
import org.bioimageanalysis.icy.icytomine.core.connection.client.CytomineClientException;
import org.bioimageanalysis.icy.icytomine.core.model.Annotation;
import org.bioimageanalysis.icy.icytomine.core.model.Image;
import org.bioimageanalysis.icy.icytomine.core.model.Term;
import org.bioimageanalysis.icy.icytomine.core.model.User;
import org.bioimageanalysis.icy.icytomine.core.model.filters.AnnotationFilter;
import org.bioimageanalysis.icy.icytomine.core.model.filters.AnnotationFilterInput;
import org.bioimageanalysis.icy.icytomine.ui.core.viewer.components.panel.annotations.filter.AnnotationFilterByTermPanel;
import org.bioimageanalysis.icy.icytomine.ui.core.viewer.components.panel.annotations.filter.AnnotationFilterByUserPanel;
import org.bioimageanalysis.icy.icytomine.ui.core.viewer.components.panel.annotations.filter.AnnotationFilterPanel;
import org.bioimageanalysis.icy.icytomine.ui.core.viewer.components.panel.annotations.filter.AnnotationFilteringPanel;

public class AnnotationFilteringPanelController {
    private AnnotationFilteringPanel panel;
    private Set<AnnotationFilter.AnnotationFilterUpdateListener> filteringListeners;
    private AnnotationFilterInput filterInput;
    private LinkedList<AnnotationFilter> filters;
    private Image imageInformation;

    public AnnotationFilteringPanelController(AnnotationFilteringPanel panel) {
        this.panel = panel;
        this.filteringListeners = new HashSet<AnnotationFilter.AnnotationFilterUpdateListener>();
        this.filterInput = new AnnotationFilterInput();
        this.filters = new LinkedList();
        this.filters.add(this.filterInput);
        panel.addFilterAdditionListener(filterName -> this.addFilterPanel(filterName));
    }

    public void setImageInformation(Image imageInformation) {
        HashSet<Annotation> annotations;
        this.imageInformation = imageInformation;
        try {
            annotations = new HashSet<Annotation>(imageInformation.getAnnotations(false));
        }
        catch (CytomineClientException e) {
            e.printStackTrace();
            annotations = new HashSet();
        }
        this.filterInput.setActiveAnnotations(annotations);
        this.filterInput.computeActiveAnnotations(AnnotationFilter.ComputationMode.USE_LAST_RESULT);
    }

    private synchronized void addFilterPanel(String filterName) {
        AnnotationFilterPanel<?> filterPanel = this.configureFilterPanel(filterName);
        this.panel.addFilterPanel(filterPanel);
    }

    private AnnotationFilterPanel<?> configureFilterPanel(String filterName) {
        AnnotationFilterPanel<?> filterPanel = this.createFilterPanel(filterName);
        filterPanel.addRemoveButtonListener(event -> this.removeFilter(filterPanel));
        AnnotationFilter lastFilter = this.getLastFilter();
        AnnotationFilter currentFilter = filterPanel.getFilter();
        for (AnnotationFilter.AnnotationFilterUpdateListener listener : this.filteringListeners) {
            lastFilter.removeAnnotationFilterUpdateListener(listener);
            currentFilter.addAnnotationFilterUpdateListener(listener);
        }
        this.filters.add(currentFilter);
        return filterPanel;
    }

    private AnnotationFilterPanel<?> createFilterPanel(String filterName) {
        AnnotationFilterPanel filterPanel = null;
        AnnotationFilter lastFilter = this.getLastFilter();
        if (Objects.equals(filterName, "User")) {
            AnnotationFilterByUserPanel userFilterPanel = new AnnotationFilterByUserPanel();
            userFilterPanel.setPreviousFilter(lastFilter);
            userFilterPanel.setUsers(this.getImageUsers());
            filterPanel = userFilterPanel;
        } else if (Objects.equals(filterName, "Term")) {
            AnnotationFilterByTermPanel termFilterPanel = new AnnotationFilterByTermPanel();
            termFilterPanel.setPreviousFilter(lastFilter);
            termFilterPanel.setTerms(this.getImageTerms());
            filterPanel = termFilterPanel;
        }
        return filterPanel;
    }

    private void removeFilter(AnnotationFilterPanel<?> filterPanel) {
        this.panel.removeFilterPanel(filterPanel);
        AnnotationFilter filter = filterPanel.getFilter();
        filter.disconnect();
        this.filters.remove(filter);
    }

    private Set<User> getImageUsers() {
        try {
            return new HashSet<User>(this.imageInformation.getAnnotationUsers());
        }
        catch (Exception e) {
            e.printStackTrace();
            return new HashSet<User>(0);
        }
    }

    private Set<Term> getImageTerms() {
        try {
            return this.imageInformation.getProject().getOntology().getTerms(false);
        }
        catch (CytomineClientException e) {
            e.printStackTrace();
            return new HashSet<Term>(0);
        }
    }

    public AnnotationFilter getLastFilter() {
        return this.filters.getLast();
    }

    public void addAnnotationFilterUpdateListener(AnnotationFilter.AnnotationFilterUpdateListener listener) {
        this.filteringListeners.add(listener);
    }

    public void removeAnnotationFilterUpdateListener(AnnotationFilter.AnnotationFilterUpdateListener listener) {
        this.filteringListeners.remove(listener);
    }

    public Set<Annotation> getActiveAnnotations() {
        return this.getLastFilter().getActiveAnnotations(AnnotationFilter.ComputationMode.USE_LAST_RESULT);
    }
}

