/*
 * Decompiled with CFR 0.152.
 */
package plugins.danyfel80.cytomine.batch;

import icy.sequence.Sequence;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.geom.Dimension2D;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import org.bioimageanalysis.icy.icytomine.core.image.annotation.AnnotationInserter;
import org.bioimageanalysis.icy.icytomine.core.image.importer.TiledImageImporter;
import org.bioimageanalysis.icy.icytomine.core.image.tile.FixedTileCalculator;
import org.bioimageanalysis.icy.icytomine.core.model.Annotation;
import org.bioimageanalysis.icy.icytomine.core.model.Image;
import org.bioimageanalysis.icy.icytomine.core.view.converters.MagnitudeResolutionConverter;
import plugins.adufour.blocks.lang.Loop;
import plugins.adufour.blocks.util.VarList;
import plugins.adufour.vars.lang.Var;
import plugins.adufour.vars.lang.VarBoolean;
import plugins.adufour.vars.lang.VarInteger;
import plugins.adufour.vars.lang.VarSequence;
import vars.cytomine.VarCytomineImage;
import vars.geom.VarDimension;
import vars.geom.VarRectangle;

public class CytomineImageLoop
extends Loop {
    private VarList inputMap;
    private VarCytomineImage imageVar;
    private VarInteger resolutionLevelVar;
    private VarRectangle loadedAreaVar;
    private VarDimension tileSizeVar;
    private VarDimension tileMarginVar;
    private VarBoolean loadAnnotationsVar;
    private VarBoolean loadAnnotationsPropertiesVar;
    private Image targetImageInstance;
    private Rectangle targetArea;
    private int targetResolution;
    private Dimension tileDimensionAtZeroResolution;
    private Dimension tileMarginAtZeroResolution;
    private Rectangle tileGridBounds;
    private int numberOfTiles;
    private boolean loadAnnotations;
    private boolean loadAnnotationProperties;
    private VarSequence currentTileSequenceVar;
    private int currentTileIndex;
    private Rectangle2D currentTileArea;
    private List<Annotation> currentTileAnnotations;
    private Sequence currentTileSequence;

    public void declareInput(VarList inputMap) {
        super.declareInput(inputMap);
        this.setInputMap(inputMap);
        this.initializeInputVariables();
        this.addInputVariables();
    }

    private void setInputMap(VarList list) {
        this.inputMap = list;
    }

    private void initializeInputVariables() {
        this.imageVar = VarCytomineImage.ofNullable(null);
        this.resolutionLevelVar = new VarInteger("resolutionLevel", 0);
        this.loadedAreaVar = new VarRectangle("Loaded area");
        this.tileSizeVar = new VarDimension("Tile size");
        this.tileMarginVar = new VarDimension("Tile margin");
        this.loadAnnotationsVar = new VarBoolean("Load annotations", false);
        this.loadAnnotationsPropertiesVar = new VarBoolean("Load annotation properties", false);
    }

    private void addInputVariables() {
        this.inputMap.add(this.imageVar.getName(), (Var)this.imageVar);
        this.inputMap.add(this.resolutionLevelVar.getName(), (Var)this.resolutionLevelVar);
        this.inputMap.add(this.loadedAreaVar.getName(), (Var)this.loadedAreaVar);
        this.inputMap.add(this.tileSizeVar.getName(), (Var)this.tileSizeVar);
        this.inputMap.add(this.tileMarginVar.getName(), (Var)this.tileMarginVar);
        this.inputMap.add(this.loadAnnotationsVar.getName(), (Var)this.loadAnnotationsVar);
        this.inputMap.add(this.loadAnnotationsPropertiesVar.getName(), (Var)this.loadAnnotationsPropertiesVar);
    }

    public void declareOutput(VarList outputMap) {
        super.declareOutput(outputMap);
        for (Var var : this.inputMap) {
            outputMap.add(var.getName(), var);
        }
        this.currentTileSequenceVar = new VarSequence("Current sequence", null);
        this.currentTileSequenceVar.setEnabled(false);
        outputMap.add(this.currentTileSequenceVar.getName(), (Var)this.currentTileSequenceVar);
    }

    public void declareLoopVariables(List<Var<?>> loopVariables) {
        for (Var var : this.inputMap) {
            loopVariables.add(var);
        }
        loopVariables.add((Var<?>)this.currentTileSequenceVar);
    }

    public void initializeLoop() {
        this.computeTilesToLoad();
        this.currentTileIndex = 0;
    }

    private void computeTilesToLoad() {
        this.targetImageInstance = (Image)this.imageVar.getValue(true);
        Dimension imageSize = this.targetImageInstance.getSize().get();
        this.targetResolution = this.resolutionLevelVar.getValue(true);
        this.targetArea = ((Rectangle)Optional.ofNullable(this.loadedAreaVar.getValue()).orElse(new Rectangle(imageSize))).intersection(new Rectangle(imageSize));
        Dimension tileDimension = (Dimension)this.tileSizeVar.getValue();
        if (tileDimension != null) {
            Dimension2D tileDimension2DAtZeroResolution = MagnitudeResolutionConverter.convertDimension2D(tileDimension, this.targetResolution, 0.0);
            this.tileDimensionAtZeroResolution = new Dimension((int)Math.ceil(tileDimension2DAtZeroResolution.getWidth()), (int)Math.ceil(tileDimension2DAtZeroResolution.getHeight()));
        } else {
            this.tileDimensionAtZeroResolution = new Dimension(this.targetImageInstance.getSizeX().get(), this.targetImageInstance.getSizeY().get());
        }
        Dimension tileMargin = (Dimension)this.tileMarginVar.getValue();
        if (tileMargin != null) {
            Dimension2D tileMargin2DAtZeroResolution = MagnitudeResolutionConverter.convertDimension2D(tileMargin, this.targetResolution, 0.0);
            this.tileMarginAtZeroResolution = new Dimension((int)Math.ceil(tileMargin2DAtZeroResolution.getWidth()), (int)Math.ceil(tileMargin2DAtZeroResolution.getHeight()));
        } else {
            this.tileMarginAtZeroResolution = new Dimension(0, 0);
        }
        FixedTileCalculator calculator = new FixedTileCalculator(this.targetArea, new Point(this.targetArea.x, this.targetArea.y), this.tileDimensionAtZeroResolution);
        this.tileGridBounds = calculator.getTileGridBounds();
        this.numberOfTiles = this.tileGridBounds.width * this.tileGridBounds.height;
        this.loadAnnotations = (Boolean)this.loadAnnotationsVar.getValue(true);
        this.loadAnnotationProperties = (Boolean)this.loadAnnotationsPropertiesVar.getValue(true);
    }

    public void beforeIteration() {
        this.importCurrentTile();
        this.currentTileSequenceVar.setValue(this.currentTileSequence);
    }

    private void importCurrentTile() {
        this.computeCurrentTileArea();
        BufferedImage tileImage = this.importTileArea(this.currentTileArea);
        this.setCurrentTileSequence(tileImage);
        this.setCurrentTileSequenceLocation(this.currentTileArea);
        if (this.loadAnnotations) {
            Rectangle2D.Double adjustedCurrentTileArea = new Rectangle2D.Double(this.currentTileArea.getX(), (double)this.targetImageInstance.getSizeY().get().intValue() - this.currentTileArea.getMaxY(), this.currentTileArea.getWidth(), this.currentTileArea.getHeight());
            this.currentTileAnnotations = this.targetImageInstance.getAnnotationsWithGeometryOf(adjustedCurrentTileArea);
            this.insertCurrentTileAnnotationsToCurrentTileSequence();
        }
    }

    private void computeCurrentTileArea() {
        double xPosition = this.targetArea.getMinX() + (double)(this.currentTileIndex % this.tileGridBounds.width) * this.tileDimensionAtZeroResolution.getWidth() - this.tileMarginAtZeroResolution.getWidth();
        double yPosition = this.targetArea.getMinY() + (double)(this.currentTileIndex / this.tileGridBounds.width) * this.tileDimensionAtZeroResolution.getHeight() - this.tileMarginAtZeroResolution.getHeight();
        this.currentTileArea = new Rectangle2D.Double(xPosition, yPosition, this.tileDimensionAtZeroResolution.getWidth() + 2.0 * this.tileMarginAtZeroResolution.getWidth(), this.tileDimensionAtZeroResolution.getHeight() + 2.0 * this.tileMarginAtZeroResolution.getHeight()).createIntersection(new Rectangle(this.targetImageInstance.getSize().get()));
    }

    private BufferedImage importTileArea(Rectangle2D tileArea) {
        TiledImageImporter importer = new TiledImageImporter(this.targetImageInstance);
        Future<BufferedImage> futureTileImage = importer.requestImage(this.targetResolution, tileArea);
        try {
            return futureTileImage.get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw new RuntimeException(e);
        }
    }

    private void setCurrentTileSequence(BufferedImage tileImage) {
        this.currentTileSequence = new Sequence(tileImage);
        this.currentTileSequence.setName(this.targetImageInstance.getName().orElse("Imported_image") + "_" + this.currentTileArea.getX() + "_" + this.currentTileArea.getY());
    }

    private void setCurrentTileSequenceLocation(Rectangle2D tileArea) {
        double pixelSize = this.targetImageInstance.getResolution().orElse(1.0);
        double pixelSizeAtTargetResolution = this.getPixelSizeAtTargetResolution();
        this.currentTileSequence.setPositionX(tileArea.getX() * pixelSize);
        this.currentTileSequence.setPositionY(tileArea.getY() * pixelSize);
        this.currentTileSequence.setPixelSizeX(pixelSizeAtTargetResolution);
        this.currentTileSequence.setPixelSizeY(pixelSizeAtTargetResolution);
    }

    private double getPixelSizeAtTargetResolution() {
        double pixelSize = this.targetImageInstance.getResolution().orElse(1.0);
        double scaleFactor = Math.pow(2.0, this.targetResolution);
        return pixelSize * scaleFactor;
    }

    private void insertCurrentTileAnnotationsToCurrentTileSequence() {
        AnnotationInserter inserter = new AnnotationInserter(this.currentTileSequence);
        inserter.insertAnnotations(this.currentTileArea, this.targetResolution, new HashSet<Annotation>(this.currentTileAnnotations), this.loadAnnotationProperties);
    }

    public void afterIteration() {
        ++this.currentTileIndex;
        super.afterIteration();
    }

    public boolean isStopConditionReached() {
        return this.currentTileIndex >= this.numberOfTiles;
    }
}

