/*
 * Decompiled with CFR 0.152.
 */
package plugins.danyfel80.cytomine.batch;

import java.util.Iterator;
import java.util.List;
import org.bioimageanalysis.icy.icytomine.core.model.Image;
import org.bioimageanalysis.icy.icytomine.core.model.Project;
import plugins.adufour.blocks.lang.Loop;
import plugins.adufour.blocks.util.VarList;
import plugins.adufour.vars.lang.Var;
import vars.cytomine.VarCytomineImage;
import vars.cytomine.VarCytomineProject;

public class CytomineProjectLoop
extends Loop {
    private VarList inputMap;
    private VarCytomineProject projectVar;
    Project project;
    List<Image> images;
    Iterator<Image> imageIterator;
    private VarCytomineImage currentImageVar;
    private Image currentImage;

    public void declareInput(VarList inputMap) {
        super.declareInput(inputMap);
        this.setInputMap(inputMap);
        this.initializeInputVariables();
        this.addInputVariables();
    }

    private void setInputMap(VarList inputMap) {
        this.inputMap = inputMap;
    }

    private void initializeInputVariables() {
        this.projectVar = VarCytomineProject.ofNullable(null);
    }

    private void addInputVariables() {
        this.inputMap.add(this.projectVar.getName(), (Var)this.projectVar);
    }

    public void declareOutput(VarList outputMap) {
        super.declareOutput(outputMap);
        for (Var var : this.inputMap) {
            outputMap.add(var.getName(), var);
        }
        this.currentImageVar = VarCytomineImage.ofNullable(null);
        this.currentImageVar.setEnabled(false);
        outputMap.add(this.currentImageVar.getName(), (Var)this.currentImageVar);
    }

    public void declareLoopVariables(List<Var<?>> loopVariables) {
        for (Var var : this.inputMap) {
            loopVariables.add(var);
        }
        loopVariables.add(this.currentImageVar);
    }

    public void initializeLoop() {
        this.computeNumberOfImages();
    }

    private void computeNumberOfImages() {
        this.project = (Project)this.projectVar.getValue(true);
        this.images = this.project.getImages(true);
        this.imageIterator = this.images.iterator();
    }

    public void beforeIteration() {
        this.retrieveCurrentImage();
        this.currentImageVar.setValue(this.currentImage);
    }

    private void retrieveCurrentImage() {
        this.currentImage = this.imageIterator.next();
    }

    public void afterIteration() {
        super.afterIteration();
    }

    public boolean isStopConditionReached() {
        return !this.imageIterator.hasNext();
    }
}

