/*
 * Decompiled with CFR 0.152.
 */
package plugins.fab.spotDetector;

import icy.plugin.PluginDescriptor;
import icy.plugin.PluginLoader;
import icy.plugin.abstract_.Plugin;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JComboBox;
import javax.swing.JPanel;
import plugins.fab.spotDetector.GeneralSpotDetectionPanel;
import plugins.fab.spotDetector.GlobalDetectionToken;
import plugins.fab.spotDetector.SpotDetector;
import plugins.fab.spotDetector.display.DisplayDetectionAbstract;

public class DisplayDetectionPanel
extends GeneralSpotDetectionPanel
implements ActionListener {
    private static final long serialVersionUID = 8859908731727831128L;
    JComboBox inputChoice = new JComboBox();
    JPanel pluginPanel = new JPanel();
    DisplayDetectionAbstract displayDetectionPlugin = null;

    public void process(GlobalDetectionToken gdt) {
        this.displayDetectionPlugin.process(gdt);
    }

    public DisplayDetectionPanel(SpotDetector spotDetector) {
        super(spotDetector);
        this.setTitle("Display");
        this.pluginPanel.setLayout(new BorderLayout());
        this.add((Component)this.inputChoice, "North");
        this.add((Component)this.pluginPanel, "Center");
        this.buildInputChoice();
        this.inputChoice.addActionListener(this);
        this.refreshInterface();
    }

    private void buildInputChoice() {
        this.inputChoice.removeAll();
        for (PluginDescriptor pluginDescriptor : PluginLoader.getPlugins()) {
            if (!pluginDescriptor.isInstanceOf(DisplayDetectionAbstract.class) || pluginDescriptor.isAbstract()) continue;
            this.inputChoice.addItem(pluginDescriptor);
            if (!pluginDescriptor.getName().contains("currentSequenceInputDetection")) continue;
            this.inputChoice.setSelectedItem(pluginDescriptor);
        }
    }

    public void close() {
        if (this.displayDetectionPlugin != null) {
            this.displayDetectionPlugin.close();
        }
    }

    private void refreshInterface() {
        PluginDescriptor pluginDescriptor = (PluginDescriptor)this.inputChoice.getSelectedItem();
        this.pluginPanel.removeAll();
        Plugin plugin = null;
        try {
            plugin = (Plugin)pluginDescriptor.getPluginClass().newInstance();
        }
        catch (InstantiationException e1) {
            e1.printStackTrace();
        }
        catch (IllegalAccessException e1) {
            e1.printStackTrace();
        }
        this.displayDetectionPlugin = (DisplayDetectionAbstract)plugin;
        this.pluginPanel.add((Component)this.displayDetectionPlugin.getPanel(), "Center");
        this.pluginPanel.updateUI();
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.inputChoice) {
            this.refreshInterface();
        }
    }
}

