/*
 * Decompiled with CFR 0.152.
 */
package plugins.fab.spotDetector;

import icy.plugin.PluginDescriptor;
import icy.plugin.PluginLoader;
import icy.plugin.abstract_.Plugin;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JComboBox;
import javax.swing.JPanel;
import plugins.fab.spotDetector.GeneralSpotDetectionPanel;
import plugins.fab.spotDetector.GlobalDetectionToken;
import plugins.fab.spotDetector.SpotDetector;
import plugins.fab.spotDetector.filtering.FilteringDetectionAbstract;
import plugins.fab.spotDetector.filtering.NoFiltering;

public class FilteringPanel
extends GeneralSpotDetectionPanel
implements ActionListener {
    private static final long serialVersionUID = 5740790564702066787L;
    JComboBox inputChoice = new JComboBox();
    JPanel pluginPanel = new JPanel();
    FilteringDetectionAbstract filteringDetection = null;

    public FilteringPanel(SpotDetector spotDetector) {
        super(spotDetector);
        this.setTitle("Filtering");
        this.pluginPanel.setLayout(new BorderLayout());
        this.add((Component)this.inputChoice, "North");
        this.add((Component)this.pluginPanel, "Center");
        this.buildInputChoice();
        this.inputChoice.addActionListener(this);
        this.refreshInterface();
    }

    private void buildInputChoice() {
        this.inputChoice.removeAll();
        for (PluginDescriptor pluginDescriptor : PluginLoader.getPlugins()) {
            if (!pluginDescriptor.isInstanceOf(FilteringDetectionAbstract.class) || pluginDescriptor.isAbstract()) continue;
            this.inputChoice.addItem(pluginDescriptor);
            if (!pluginDescriptor.isInstanceOf(NoFiltering.class)) continue;
            this.inputChoice.setSelectedItem(pluginDescriptor);
        }
    }

    private void refreshInterface() {
        PluginDescriptor pluginDescriptor = (PluginDescriptor)this.inputChoice.getSelectedItem();
        this.pluginPanel.removeAll();
        Plugin plugin = null;
        try {
            plugin = (Plugin)pluginDescriptor.getPluginClass().newInstance();
        }
        catch (InstantiationException e1) {
            e1.printStackTrace();
        }
        catch (IllegalAccessException e1) {
            e1.printStackTrace();
        }
        this.filteringDetection = (FilteringDetectionAbstract)plugin;
        this.pluginPanel.add((Component)this.filteringDetection.getPanel(), "Center");
        this.pluginPanel.updateUI();
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.inputChoice) {
            this.refreshInterface();
        }
    }

    public void process(GlobalDetectionToken gdt) throws InterruptedException {
        this.filteringDetection.process(gdt);
    }
}

