/*
 * Decompiled with CFR 0.152.
 */
package plugins.fab.spotDetector.detector;

import icy.roi.BooleanMask3D;
import icy.roi.ROI;
import icy.system.SystemUtil;
import icy.system.thread.Processor;
import icy.type.point.Point3D;
import icy.type.point.Point5D;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import plugins.fab.spotDetector.DetectionSpot;
import plugins.fab.spotDetector.Point3D;
import plugins.kernel.roi.roi2d.ROI2DArea;
import plugins.kernel.roi.roi3d.ROI3DArea;

public class DetectionToROI {
    public static ArrayList<ROI> convertDetectionToROI(ArrayList<DetectionSpot> detectionList) throws InterruptedException {
        Processor processor = new Processor(detectionList.size(), SystemUtil.getNumberOfCPUs() * 2);
        ArrayList<Future> tasks = new ArrayList<Future>();
        int size = detectionList.size();
        int groupsSize = 1000;
        for (int i = 0; i < detectionList.size(); i += 1000) {
            tasks.add(processor.submit((Callable)new DetectionToROIConverter(detectionList.subList(i, Math.min(i + 1000, size)), i)));
        }
        ArrayList<ROI> result = new ArrayList<ROI>();
        for (Future task : tasks) {
            try {
                result.addAll((Collection)task.get());
            }
            catch (InterruptedException e) {
                break;
            }
            catch (ExecutionException e) {
                e.getCause().printStackTrace();
                break;
            }
        }
        return result;
    }

    static class DetectionToROIConverter
    implements Callable<List<ROI>> {
        final List<DetectionSpot> spots;
        final int baseIndex;

        public DetectionToROIConverter(List<DetectionSpot> spots, int baseIndex) {
            this.spots = spots;
            this.baseIndex = baseIndex;
        }

        @Override
        public List<ROI> call() throws Exception {
            ArrayList<ROI> result = new ArrayList<ROI>(this.spots.size());
            for (int s = 0; s < this.spots.size(); ++s) {
                ROI3DArea roi;
                DetectionSpot spot = this.spots.get(s);
                int size = spot.points.size();
                if (size == 0) continue;
                icy.type.point.Point3D[] p3ds = new icy.type.point.Point3D[size];
                for (int p = 0; p < size; ++p) {
                    Point3D pt = spot.points.get(p);
                    p3ds[p] = new Point3D.Double(pt.x, pt.y, pt.z);
                }
                BooleanMask3D bm3d = new BooleanMask3D(p3ds);
                ROI3DArea roi3D = new ROI3DArea(bm3d);
                if (roi3D.getSizeZ() == 1) {
                    ROI2DArea roi2D = (ROI2DArea)roi3D.getSlice((int)roi3D.getPosition().getZ());
                    roi2D.setZ(roi3D.getPosition().z);
                    roi = roi2D;
                } else {
                    roi = roi3D;
                }
                Point5D pos = roi.getPosition5D();
                pos.setT((double)spot.getT());
                roi.setPosition5D(pos);
                roi.setName("spot #" + (this.baseIndex + s));
                result.add((ROI)roi);
            }
            return result;
        }
    }
}

