/*
 * Decompiled with CFR 0.152.
 */
package plugins.fab.spotDetector.detector;

import icy.gui.util.GuiUtil;
import icy.image.ImageUtil;
import icy.main.Icy;
import icy.resource.ResourceUtil;
import icy.roi.ROI;
import icy.util.XLSUtil;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Image;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.InputStream;
import java.util.ArrayList;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.border.TitledBorder;
import jxl.write.WritableSheet;
import plugins.fab.spotDetector.GlobalDetectionToken;
import plugins.fab.spotDetector.detector.DetectorDetectionAbstract;
import plugins.fab.spotDetector.detector.UDWTScale;
import plugins.fab.spotDetector.detector.UDWTWaveletCore;
import plugins.fab.spotDetector.detector.wavelets.UDWT.B3SplineUDWT;

public class UDWTWaveletDetector
extends DetectorDetectionAbstract
implements ActionListener {
    ArrayList<UDWTScale> UDWTScaleArrayList = new ArrayList();
    UDWTWaveletCore waveletCore = new UDWTWaveletCore();
    JButton addScaleButton;
    JButton removeScaleButton;
    JPanel scalePanel;
    JScrollPane scrollPane;
    JRadioButton detectNegativeRadio = new JRadioButton("Detect dark spot over bright blackground");
    JRadioButton detectPositiveRadio = new JRadioButton("Detect bright spot over dark blackground");
    ButtonGroup buttonGroup = new ButtonGroup();
    JCheckBox computeWATwithROICheckBox = new JCheckBox("compute Wat considering ROIs");
    JPanel examplePanel;
    JPanel positiveExamplePanel;
    JCheckBox displayBinaryImageCheckBox = new JCheckBox("Display binary image (before filtering)", false);
    JCheckBox use2DWaveletsFor3DImages = new JCheckBox("Force use of 2D Wavelets for 3D", false);

    public UDWTWaveletDetector() {
        this.getPanel().setLayout(new BorderLayout());
        this.getPanel().add((Component)this.getConfigurationPanel(), "Center");
    }

    @Override
    public void process(GlobalDetectionToken gdt) throws InterruptedException {
        boolean detectNegative = this.detectNegativeRadio.isSelected();
        boolean computeWATwithROI = this.computeWATwithROICheckBox.isSelected();
        boolean force2DWaveletsFor2D = this.use2DWaveletsFor3DImages.isSelected();
        for (ROI roi : gdt.inputSequence.getROIs()) {
            String name = roi.getName();
            ROI roiCopy = roi.getCopy();
            roi.setName(name);
            roiCopy.setName(name);
            gdt.inputComputationSequence.addROI(roiCopy);
        }
        gdt.detectionResult = this.waveletCore.computeDetection(this.displayBinaryImageCheckBox.isSelected(), this.UDWTScaleArrayList, gdt.inputComputationSequence, detectNegative, computeWATwithROI, force2DWaveletsFor2D);
        if (this.displayBinaryImageCheckBox.isSelected()) {
            Icy.getMainInterface().addSequence(this.waveletCore.getBinarySequence());
        }
    }

    JPanel getConfigurationPanel() {
        this.use2DWaveletsFor3DImages.setToolTipText("If enabled, each images of a 3D stack will be computed separatly by a 2D wavelet. This helps to bypass the scale size limitation due to a too small number of z in the image.");
        JPanel configurationPanel = new JPanel();
        configurationPanel.setLayout(new BorderLayout());
        this.addScaleButton = new JButton("Add scale");
        this.addScaleButton.addActionListener(this);
        this.removeScaleButton = new JButton("Remove scale");
        this.removeScaleButton.addActionListener(this);
        this.buttonGroup.add(this.detectNegativeRadio);
        this.buttonGroup.add(this.detectPositiveRadio);
        this.detectNegativeRadio.setSelected(true);
        this.detectNegativeRadio.addActionListener(this);
        this.detectPositiveRadio.addActionListener(this);
        configurationPanel.add((Component)GuiUtil.besidesPanel((Component[])new Component[]{this.removeScaleButton, this.addScaleButton}), "South");
        this.scalePanel = new JPanel();
        this.scalePanel.setLayout(new BoxLayout(this.scalePanel, 3));
        this.scalePanel.setBorder(new TitledBorder("Size of spots to detect: (scale and sensitivity)"));
        this.scrollPane = new JScrollPane(this.scalePanel);
        this.addScalePanel(false);
        this.addScalePanel(true);
        this.addScalePanel(false);
        this.examplePanel = new JPanel();
        this.examplePanel.setLayout(new BoxLayout(this.examplePanel, 3));
        this.examplePanel.setBorder(new TitledBorder("Examples of input image that would use this setting:"));
        this.refreshExamplePanel();
        JPanel negativePositivePanel = new JPanel();
        negativePositivePanel.setLayout(new BoxLayout(negativePositivePanel, 3));
        negativePositivePanel.add(Box.createVerticalStrut(5));
        negativePositivePanel.add(GuiUtil.createLineBoxPanel((Component[])new Component[]{Box.createHorizontalGlue(), this.detectPositiveRadio, Box.createHorizontalGlue()}));
        negativePositivePanel.add(GuiUtil.createLineBoxPanel((Component[])new Component[]{Box.createHorizontalGlue(), this.detectNegativeRadio, Box.createHorizontalGlue()}));
        negativePositivePanel.add(Box.createVerticalStrut(5));
        negativePositivePanel.add(GuiUtil.createLineBoxPanel((Component[])new Component[]{this.examplePanel}));
        negativePositivePanel.add(GuiUtil.createLineBoxPanel((Component[])new Component[]{this.displayBinaryImageCheckBox}));
        negativePositivePanel.add(GuiUtil.createLineBoxPanel((Component[])new Component[]{this.use2DWaveletsFor3DImages}));
        negativePositivePanel.add(GuiUtil.createLineBoxPanel((Component[])new Component[]{this.computeWATwithROICheckBox}));
        negativePositivePanel.add(Box.createVerticalStrut(10));
        configurationPanel.add((Component)negativePositivePanel, "North");
        configurationPanel.add((Component)this.scrollPane, "Center");
        return configurationPanel;
    }

    private void refreshExamplePanel() {
        this.examplePanel.removeAll();
        if (this.detectNegativeRadio.isSelected()) {
            this.examplePanel.add(GuiUtil.createLineBoxPanel((Component[])new Component[]{Box.createHorizontalGlue(), this.getIcon("plugins/fab/spotDetector/detector/neg1.png"), Box.createHorizontalStrut(5), this.getIcon("plugins/fab/spotDetector/detector/neg2.png"), Box.createHorizontalStrut(5), this.getIcon("plugins/fab/spotDetector/detector/neg3.png"), Box.createHorizontalGlue()}));
        } else {
            this.examplePanel.add(GuiUtil.createLineBoxPanel((Component[])new Component[]{Box.createHorizontalGlue(), this.getIcon("plugins/fab/spotDetector/detector/pos1.png"), Box.createHorizontalGlue()}));
        }
        this.examplePanel.add(Box.createVerticalStrut(5));
        if (this.examplePanel.getParent() != null) {
            this.examplePanel.getParent().validate();
        }
    }

    private JLabel getIcon(String name) {
        ImageIcon icon = ResourceUtil.getImageIcon((Image)ImageUtil.loadImage((InputStream)this.getResourceAsStream(name)));
        JLabel label = new JLabel(icon);
        label.setSize(64, 64);
        label.setPreferredSize(new Dimension(64, 64));
        return label;
    }

    private void addScalePanel(boolean enabled) {
        UDWTScale scale = new UDWTScale(this.UDWTScaleArrayList.size() + 1, enabled, 100.0);
        this.UDWTScaleArrayList.add(scale);
        this.rebuildScalePanel();
    }

    private void rebuildScalePanel() {
        this.scalePanel.removeAll();
        this.scalePanel.add(UDWTScale.getHeaderPanel());
        for (UDWTScale b3Scale : this.UDWTScaleArrayList) {
            this.scalePanel.add(b3Scale.getPanel());
        }
        this.scalePanel.add(Box.createVerticalGlue());
        this.scalePanel.repaint();
        this.scrollPane.validate();
    }

    private void removeScalePanel() {
        if (this.UDWTScaleArrayList.size() == 0) {
            return;
        }
        this.UDWTScaleArrayList.remove(this.UDWTScaleArrayList.size() - 1);
        this.rebuildScalePanel();
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.detectNegativeRadio || e.getSource() == this.detectPositiveRadio) {
            this.refreshExamplePanel();
        }
        if (e.getSource() == this.addScaleButton) {
            this.addScalePanel(true);
        }
        if (e.getSource() == this.removeScaleButton) {
            this.removeScalePanel();
        }
    }

    @Override
    public void saveXLS(WritableSheet page, GlobalDetectionToken gdt) {
        int row = page.getRows();
        XLSUtil.setCellString((WritableSheet)page, (int)0, (int)row, (String)"Detector:");
        XLSUtil.setCellString((WritableSheet)page, (int)1, (int)row, (String)"UDWT Wavelet Detector");
        XLSUtil.setCellString((WritableSheet)page, (int)0, (int)(++row), (String)"Parameters:");
        ++row;
        for (UDWTScale b3Scale : this.UDWTScaleArrayList) {
            XLSUtil.setCellString((WritableSheet)page, (int)0, (int)row, (String)("Scale " + b3Scale.scaleNumber));
            if (b3Scale.isEnabled()) {
                XLSUtil.setCellString((WritableSheet)page, (int)1, (int)row, (String)"Enabled");
            } else {
                XLSUtil.setCellString((WritableSheet)page, (int)1, (int)row, (String)"Disabled");
            }
            XLSUtil.setCellString((WritableSheet)page, (int)2, (int)row, (String)"Threshold:");
            XLSUtil.setCellNumber((WritableSheet)page, (int)3, (int)row, (double)b3Scale.getThreshold());
            ++row;
        }
        B3SplineUDWT waveletTransform = new B3SplineUDWT();
        if (B3SplineUDWT.isNumberOfScaleOkForImage3D(gdt.inputSequence.getSizeX(), gdt.inputSequence.getSizeY(), gdt.inputSequence.getSizeZ(), this.waveletCore.getNumberOfMaxEnabledScale())) {
            XLSUtil.setCellString((WritableSheet)page, (int)0, (int)row, (String)"ERROR : Scale configuration error");
            int minSize = B3SplineUDWT.getMinSize(this.waveletCore.getNumberOfMaxEnabledScale());
            XLSUtil.setCellString((WritableSheet)page, (int)0, (int)(++row), (String)("Scales selected needs an image of size " + minSize + "x" + minSize + "x" + minSize + " image"));
            XLSUtil.setCellString((WritableSheet)page, (int)0, (int)(++row), (String)("Input Image size is: " + gdt.inputSequence.getSizeX() + "x" + gdt.inputSequence.getSizeY() + "x" + gdt.inputSequence.getSizeZ() + " image"));
        }
    }
}

