/*
 * Decompiled with CFR 0.152.
 */
package plugins.fab.spotDetector.preProcessing;

import icy.gui.util.GuiUtil;
import icy.image.IcyBufferedImage;
import icy.sequence.Sequence;
import icy.type.DataType;
import icy.type.collection.array.Array1DUtil;
import icy.util.XLSUtil;
import java.awt.Component;
import java.awt.image.BufferedImage;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JLabel;
import javax.swing.border.TitledBorder;
import jxl.write.WritableSheet;
import plugins.fab.spotDetector.GlobalDetectionToken;
import plugins.fab.spotDetector.preProcessing.PreProcessingAbstract;

public class MeanOfAllChannelsPreProcessor
extends PreProcessingAbstract {
    public MeanOfAllChannelsPreProcessor() {
        this.getPanel().setLayout(new BoxLayout(this.getPanel(), 3));
        this.getPanel().setBorder(new TitledBorder("Mean (Average) of all channels"));
        this.getPanel().add(GuiUtil.createLineBoxPanel((Component[])new Component[]{Box.createVerticalGlue()}));
        this.getPanel().add(GuiUtil.createLineBoxPanel((Component[])new Component[]{new JLabel("The input creates the average of all channels")}));
        this.getPanel().add(GuiUtil.createLineBoxPanel((Component[])new Component[]{new JLabel("and keep z and t image location")}));
        this.getPanel().add(GuiUtil.createLineBoxPanel((Component[])new Component[]{Box.createVerticalGlue()}));
    }

    @Override
    public void process(GlobalDetectionToken gdt) {
        gdt.inputComputationSequence = new Sequence();
        for (int t = 0; t < gdt.inputSequence.getSizeT(); ++t) {
            for (int z = 0; z < gdt.inputSequence.getSizeZ(t); ++z) {
                IcyBufferedImage image = gdt.inputSequence.getImage(t, z);
                IcyBufferedImage averageImage = new IcyBufferedImage(image.getWidth(), image.getHeight(), 1, DataType.DOUBLE);
                double[] result = new double[image.getSizeX() * image.getSizeY()];
                double[][] imageArray = new double[image.getSizeC()][];
                for (int c = 0; c < image.getSizeC(); ++c) {
                    imageArray[c] = Array1DUtil.arrayToDoubleArray((Object)image.getDataCopyXY(0), (boolean)image.isSignedDataType());
                }
                int i = 0;
                while (i < image.getSizeX() * image.getSizeY()) {
                    result[i] = 0.0;
                    for (int c = 0; c < image.getSizeC(); ++c) {
                        int n = i;
                        result[n] = result[n] + imageArray[c][i];
                    }
                    int n = i++;
                    result[n] = result[n] / (double)image.getSizeC();
                }
                averageImage.setDataXYAsDouble(0, result);
                gdt.inputComputationSequence.setImage(t, z, (BufferedImage)averageImage);
            }
        }
    }

    @Override
    public void saveXLS(WritableSheet page, GlobalDetectionToken gdt) {
        int row = page.getRows();
        XLSUtil.setCellString((WritableSheet)page, (int)0, (int)row, (String)"Pre processor :");
        XLSUtil.setCellString((WritableSheet)page, (int)1, (int)row, (String)"Average of all channels :");
    }
}

