/*
 * Decompiled with CFR 0.152.
 */
package plugins.fab.spotDetector.roi;

import icy.gui.frame.progress.FailedAnnounceFrame;
import icy.gui.main.MainAdapter;
import icy.gui.main.MainEvent;
import icy.gui.main.MainListener;
import icy.gui.util.GuiUtil;
import icy.main.Icy;
import icy.roi.ROI;
import icy.roi.ROI2D;
import icy.roi.ROI3D;
import icy.sequence.Sequence;
import java.awt.Color;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import java.util.HashMap;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.border.TitledBorder;
import jxl.write.WritableSheet;
import plugins.fab.spotDetector.DetectionSpot;
import plugins.fab.spotDetector.GlobalDetectionToken;
import plugins.fab.spotDetector.roi.ROIDetectionAbstract;
import plugins.fab.spotDetector.roi.ROI_XLS_Common_Saver;
import plugins.kernel.roi.roi2d.ROI2DRectangle;

public class ROIFixedFromSequence
extends ROIDetectionAbstract
implements ActionListener {
    JLabel currentSequenceNameLabel = new JLabel();
    Color labelDefaultColor = null;
    JButton loadROIButton = new JButton("Click to load reference ROIs from focused Sequence.");
    ArrayList<ROI2D> roiListStored = new ArrayList();

    public ROIFixedFromSequence() {
        this.getPanel().setLayout(new BoxLayout(this.getPanel(), 3));
        this.getPanel().setBorder(new TitledBorder("use same ROI for all sequences"));
        this.getPanel().add(GuiUtil.createLineBoxPanel((Component[])new Component[]{Box.createVerticalGlue()}));
        this.getPanel().add(GuiUtil.createLineBoxPanel((Component[])new Component[]{new JLabel("Click on the button to copy the ROIs")}));
        this.getPanel().add(GuiUtil.createLineBoxPanel((Component[])new Component[]{new JLabel("from the current focused sequence:")}));
        this.getPanel().add(GuiUtil.createLineBoxPanel((Component[])new Component[]{new JLabel("** WARNING: existing ROIs")}));
        this.getPanel().add(GuiUtil.createLineBoxPanel((Component[])new Component[]{new JLabel("in batch files will be replaced")}));
        this.getPanel().add(GuiUtil.createLineBoxPanel((Component[])new Component[]{new JLabel("by the reference ROI**")}));
        this.getPanel().add(GuiUtil.createLineBoxPanel((Component[])new Component[]{Box.createVerticalStrut(10)}));
        this.getPanel().add(GuiUtil.createLineBoxPanel((Component[])new Component[]{this.currentSequenceNameLabel}));
        this.getPanel().add(GuiUtil.createLineBoxPanel((Component[])new Component[]{Box.createVerticalStrut(10)}));
        this.getPanel().add(GuiUtil.createLineBoxPanel((Component[])new Component[]{this.loadROIButton}));
        this.getPanel().add(GuiUtil.createLineBoxPanel((Component[])new Component[]{Box.createVerticalGlue()}));
        this.refreshCurrentSequenceLabel();
        this.loadROIButton.addActionListener(this);
        Icy.getMainInterface().addListener((MainListener)new MainAdapter(){

            public void sequenceFocused(MainEvent event) {
                ROIFixedFromSequence.this.refreshCurrentSequenceLabel();
            }
        });
    }

    private void refreshCurrentSequenceLabel() {
        Sequence sequence = this.getFocusedSequence();
        if (sequence == null) {
            this.currentSequenceNameLabel.setForeground(Color.red);
            this.currentSequenceNameLabel.setText("No sequence loaded");
        } else {
            this.currentSequenceNameLabel.setForeground(this.labelDefaultColor);
            this.currentSequenceNameLabel.setText(sequence.getName());
        }
    }

    @Override
    public void process(GlobalDetectionToken gdt) {
        gdt.inputSequence.removeAllROI();
        for (ROI rOI : this.roiListStored) {
            gdt.inputSequence.addROI(rOI);
        }
        ArrayList roiArrayList = gdt.inputSequence.getROIs();
        ArrayList<DetectionSpot> cloneDetectionList = new ArrayList<DetectionSpot>(gdt.detectionResult);
        for (ROI roi : roiArrayList) {
            if (roi.getColor().getRed() != 0 || roi.getColor().getGreen() != 0 || roi.getColor().getBlue() != 0) continue;
            if (roi instanceof ROI2D) {
                ROI2D roi2d = (ROI2D)roi;
                for (DetectionSpot detectionSpot : cloneDetectionList) {
                    if (!roi2d.contains(detectionSpot.getMassCenter().x, detectionSpot.getMassCenter().y)) continue;
                    gdt.detectionResult.remove(detectionSpot);
                }
                continue;
            }
            if (!(roi instanceof ROI3D)) continue;
            ROI3D roi3d = (ROI3D)roi;
            for (DetectionSpot detectionSpot : cloneDetectionList) {
                if (!roi3d.contains(detectionSpot.getMassCenter().x, detectionSpot.getMassCenter().y, detectionSpot.getMassCenter().z)) continue;
                gdt.detectionResult.remove(detectionSpot);
            }
        }
        HashMap hashMap = new HashMap();
        if (roiArrayList.size() == 0) {
            hashMap.put(new ROI2DRectangle((Rectangle2D)gdt.inputSequence.getBounds2D()), (ArrayList)gdt.detectionResult.clone());
        } else {
            for (ROI roi : roiArrayList) {
                hashMap.put(roi, new ArrayList());
            }
            for (ROI roi : roiArrayList) {
                if (roi instanceof ROI2D) {
                    ROI2D roi2d = (ROI2D)roi;
                    for (DetectionSpot spot : gdt.detectionResult) {
                        if (!roi2d.contains(spot.getMassCenter().x, spot.getMassCenter().y)) continue;
                        ((ArrayList)hashMap.get(roi)).add(spot);
                    }
                    continue;
                }
                if (!(roi instanceof ROI3D)) continue;
                ROI3D roi3d = (ROI3D)roi;
                for (DetectionSpot spot : gdt.detectionResult) {
                    if (!roi3d.contains(spot.getMassCenter().x, spot.getMassCenter().y, spot.getMassCenter().z)) continue;
                    ((ArrayList)hashMap.get(roi)).add(spot);
                }
            }
        }
        gdt.detectionResult.clear();
        for (ROI roi : hashMap.keySet()) {
            for (DetectionSpot detectionSpot : (ArrayList)hashMap.get(roi)) {
                gdt.detectionResult.add(detectionSpot);
            }
        }
        gdt.roi2detection = hashMap;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        Sequence sequence = Icy.getMainInterface().getFocusedSequence();
        if (sequence == null) {
            new FailedAnnounceFrame("No sequence loaded");
            return;
        }
        this.roiListStored = sequence.getROI2Ds();
        if (this.roiListStored.size() == 0) {
            new FailedAnnounceFrame("No ROI found in the focused sequence. (" + sequence.getName() + ")");
            return;
        }
        this.loadROIButton.setText("" + this.roiListStored.size() + " ROI(s) Loaded.");
    }

    @Override
    public void saveXLS(WritableSheet page, GlobalDetectionToken gdt) throws InterruptedException {
        ROI_XLS_Common_Saver.saveXLS(page, gdt, "ROI From Sequence module");
    }
}

