/*
 * Decompiled with CFR 0.152.
 */
package plugins.stef.roi.bloc.op;

import icy.plugin.abstract_.Plugin;
import icy.plugin.interface_.PluginBundled;
import icy.plugin.interface_.PluginLibrary;
import icy.roi.ROI;
import icy.roi.ROIUtil;
import java.util.ArrayList;
import plugins.adufour.blocks.tools.roi.ROIBlock;
import plugins.adufour.blocks.util.VarList;
import plugins.adufour.vars.lang.Var;
import plugins.adufour.vars.lang.VarBoolean;
import plugins.adufour.vars.lang.VarInteger;
import plugins.adufour.vars.lang.VarROIArray;
import plugins.stef.roi.bloc.RoiBlocks;

public class Scale2xROI
extends Plugin
implements ROIBlock,
PluginLibrary,
PluginBundled {
    protected final VarROIArray input = new VarROIArray("ROI(s)", null);
    protected final VarROIArray output = new VarROIArray("ROI(s)", null);
    protected final VarInteger factor = new VarInteger("Power 2 factor (2^x)", 0, null);
    protected final VarBoolean scaleZ = new VarBoolean("Scale Z", Boolean.TRUE);

    public void run() {
        ROI[] rois = (ROI[])this.input.getValue();
        ArrayList<ROI> result = new ArrayList<ROI>();
        int f = this.factor.getValue();
        boolean sz = (Boolean)this.scaleZ.getValue();
        try {
            if (rois != null) {
                for (ROI roi : rois) {
                    if (roi == null) continue;
                    ROI r = roi;
                    int it = Math.abs(f);
                    if (it == 0) {
                        r = r.getCopy();
                    } else {
                        while (it-- > 0) {
                            r = ROIUtil.get2XScaled((ROI)r, (boolean)sz, (f < 0 ? 1 : 0) != 0);
                        }
                    }
                    result.add(r);
                }
            }
            this.output.setValue((Object)result.toArray(new ROI[result.size()]));
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
    }

    public void declareInput(VarList inputMap) {
        inputMap.add("input", (Var)this.input);
        inputMap.add("factor", (Var)this.factor);
        inputMap.add("scaleZ", (Var)this.scaleZ);
    }

    public void declareOutput(VarList outputMap) {
        outputMap.add("output", (Var)this.output);
    }

    public String getMainPluginClassName() {
        return RoiBlocks.class.getName();
    }
}

